/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean.ui;

import com.installshield.util.TTYPrompt;
import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import com.sybase.ismp.ase.lang.SISResourceGetter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Category;

public class TextBrowseButtonComponent
extends AbstractUIComponent
implements ConsoleUIComponent,
ActionListener {
    private static final Category LOG = Category.getInstance((class$com$sybase$ismp$ase$wizardbean$ui$TextBrowseButtonComponent == null ? (class$com$sybase$ismp$ase$wizardbean$ui$TextBrowseButtonComponent = TextBrowseButtonComponent.class$("com.sybase.ismp.ase.wizardbean.ui.TextBrowseButtonComponent")) : class$com$sybase$ismp$ase$wizardbean$ui$TextBrowseButtonComponent).getName());
    protected JButton _browseButton = null;
    protected boolean _renderedFlag = false;
    protected boolean _inConsoleMode = false;
    private String _labelText = "";
    private String _defaultValue = null;
    private JTextField _textField = null;
    private JPanel _buttonPanel = null;
    private boolean _checkForWritePermission = false;
    private String _consoleValue = null;
    private boolean _isDirectory = false;
    static /* synthetic */ Class class$com$sybase$ismp$ase$wizardbean$ui$TextBrowseButtonComponent;

    public TextBrowseButtonComponent(String string, int n, boolean bl) {
        this._defaultValue = string;
        this._checkForWritePermission = bl;
        this.init(string, n);
    }

    public TextBrowseButtonComponent(String string, int n, boolean bl, boolean bl2) {
        this._defaultValue = string;
        this._checkForWritePermission = bl;
        this._isDirectory = bl2;
        this.init(string, n);
    }

    public TextBrowseButtonComponent(String string, String string2, int n, boolean bl) {
        this._labelText = string;
        this._defaultValue = string2;
        this._checkForWritePermission = bl;
        this.init(string2, n);
    }

    public TextBrowseButtonComponent(String string, String string2, int n, boolean bl, boolean bl2) {
        this._labelText = string;
        this._defaultValue = string2;
        this._checkForWritePermission = bl;
        this._isDirectory = bl2;
        this.init(string2, n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._browseButton) {
            JFileChooser jFileChooser = new JFileChooser(this.getText());
            if (this._isDirectory) {
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.changeToParentDirectory();
            }
            jFileChooser.setDialogTitle(this._labelText);
            jFileChooser.setApproveButtonMnemonic(SISResourceGetter.getString("button_ok_short").charAt(0));
            boolean bl = false;
            while (!bl) {
                bl = true;
                int n = jFileChooser.showDialog(null, SISResourceGetter.getString("button_ok"));
                if (n != 0) continue;
                this._defaultValue = jFileChooser.getSelectedFile().getAbsolutePath();
                this._textField.setText(this._defaultValue);
                if (!this._checkForWritePermission) continue;
                File file = new File(this._defaultValue);
                if ((this._isDirectory || file.getParentFile().canWrite()) && (!this._isDirectory || file.canWrite())) continue;
                JOptionPane.showMessageDialog(null, SISResourceGetter.getString("file_no_write_permission"), SISResourceGetter.getString("file_no_write_permission"), 0);
                bl = false;
            }
        }
    }

    public void init(String string, int n) {
        if (!this._inConsoleMode) {
            this._browseButton = new JButton(SISResourceGetter.getString("browse_button_label"));
            this._browseButton.addActionListener(this);
            this._buttonPanel = new JPanel();
            this._buttonPanel.setLayout(new BoxLayout(this._buttonPanel, 0));
            this._textField = new JTextField(this._defaultValue, n);
            this._buttonPanel.add(this._textField);
            this._buttonPanel.add(this._browseButton);
            LOG.debug("ButtonPanel added...textvalue=" + this._defaultValue);
        }
    }

    public void consoleInteraction() {
        this._inConsoleMode = true;
        this.getTTYDisplay().printLine();
        boolean bl = true;
        TTYPrompt tTYPrompt = new TTYPrompt();
        tTYPrompt.setDefaultValue(this._defaultValue);
        this._consoleValue = this.getTTYDisplay().prompt(tTYPrompt);
        if (this._checkForWritePermission) {
            while (bl) {
                File file = new File(this._consoleValue);
                if (!this._isDirectory && !file.getParentFile().canWrite() || this._isDirectory && !file.canWrite()) {
                    this.getTTYDisplay().printLine(SISResourceGetter.getString("file_no_write_permission"));
                    this.getTTYDisplay().printLine();
                    tTYPrompt = new TTYPrompt();
                    tTYPrompt.setDefaultValue(this._defaultValue);
                    this._consoleValue = this.getTTYDisplay().prompt(tTYPrompt);
                    continue;
                }
                bl = false;
            }
        }
    }

    public void createComponentUI() {
        super.removeAll();
        super.add(this._buttonPanel);
        this._renderedFlag = true;
    }

    public Component getField() {
        return this._textField;
    }

    public String getText() {
        if (this._inConsoleMode) {
            return this._consoleValue;
        }
        return this._textField.getText();
    }

    public void setText(String string) {
        this._textField.setText(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

