/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean.ui;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends JTextField {
    private Toolkit toolkit;
    private NumberFormat integerFormatter;
    private int length = Integer.MAX_VALUE;

    public WholeNumberField(String string) {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setParseIntegerOnly(true);
        this.setText(string);
    }

    public WholeNumberField(String string, int n) {
        super(n);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setParseIntegerOnly(true);
        this.setText(string);
    }

    public WholeNumberField(String string, int n, int n2) {
        super(n);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setParseIntegerOnly(true);
        this.setText(string);
        this.length = n2;
    }

    public String getText() {
        try {
            this.integerFormatter.parse(super.getText());
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
        }
        return super.getText();
    }

    public void setText(String string) {
        try {
            this.integerFormatter.parse(string);
            super.setText(string);
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
        }
    }

    public Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() > WholeNumberField.this.length) {
                WholeNumberField.this.toolkit.beep();
                return;
            }
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (Character.isDigit(cArray[i])) {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                WholeNumberField.this.toolkit.beep();
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

