/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sis.util.swing;

import com.sybase.sis.util.swing.HtmlLoadException;
import com.sybase.sis.util.swing.HtmlLoadInterface;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlLoad {
    protected static final Pattern CHAR_SET_PATTERN = Pattern.compile("(?:.*?;)*?\\s*charset\\s*=\\s*(.*?)\\s*(?:;.*?)*?");
    protected HTMLEditorKit _kit;
    protected HTMLDocument _doc;
    protected PageStream _loading;
    protected Thread _loadThread;
    private HtmlLoadInterface _htmlLoadInterface;

    public HtmlLoad(HTMLEditorKit hTMLEditorKit, HTMLDocument hTMLDocument, HtmlLoadInterface htmlLoadInterface) {
        this._kit = hTMLEditorKit;
        this._doc = hTMLDocument;
        this._htmlLoadInterface = htmlLoadInterface;
        this._loadThread = new PageLoader(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPage() throws HtmlLoadException {
        HtmlLoad htmlLoad = this;
        synchronized (htmlLoad) {
            if (this._loading == null) {
                return;
            }
            this._loading.cancel();
            this._loading = null;
        }
        try {
            this._loadThread.join();
        }
        catch (InterruptedException interruptedException) {
            throw new HtmlLoadException("Error Canceling Stream ", interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPage(URL uRL) throws IOException, HtmlLoadException {
        if (uRL == null) {
            throw new HtmlLoadException("HtmlLoad.setPage() URL is null", new NullPointerException());
        }
        this.cancelPage();
        URL uRL2 = (URL)this._doc.getProperty("stream");
        if (uRL2 != null && uRL != null && uRL2.sameFile(uRL)) {
            this._htmlLoadInterface.finishedRead();
            return;
        }
        if (this._doc.getAsynchronousLoadPriority() >= 0) {
            HtmlLoad htmlLoad = this;
            synchronized (htmlLoad) {
                this._loading = new PageStream(uRL);
                this._loadThread = new PageLoader(this._loading);
                this._loadThread.start();
            }
        } else {
            HtmlLoad.load(uRL, this._kit, this._doc);
        }
    }

    public static void clearDoc(HTMLDocument hTMLDocument) {
        try {
            Enumeration<?> enumeration = hTMLDocument.getStyleNames();
            while (enumeration.hasMoreElements()) {
                hTMLDocument.removeStyle(enumeration.nextElement().toString());
            }
            hTMLDocument.remove(0, hTMLDocument.getLength());
            hTMLDocument.putProperty("stream", null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void read(PageStream pageStream, HTMLEditorKit hTMLEditorKit, HTMLDocument hTMLDocument) throws IOException, HtmlLoadException {
        HtmlLoad.clearDoc(hTMLDocument);
        URL uRL = pageStream.getPage();
        if (uRL == null) {
            hTMLDocument.putProperty("stream", null);
            return;
        }
        URLConnection uRLConnection = uRL.openConnection();
        String string = uRLConnection.getContentType();
        if (string == null) {
            string = hTMLEditorKit.getContentType();
        }
        if (!hTMLEditorKit.getContentType().equalsIgnoreCase(string)) {
            throw new IOException("URL's content-type \"" + string + "\" must be \"" + hTMLEditorKit.getContentType() + "\"");
        }
        hTMLDocument.putProperty("content-encoding", uRLConnection.getContentEncoding());
        Object object = hTMLDocument.getProperty("IgnoreCharsetDirective");
        hTMLDocument.putProperty("IgnoreCharsetDirective", false);
        try {
            HtmlLoad.smartRead(pageStream, hTMLEditorKit, hTMLDocument);
            hTMLDocument.putProperty("stream", pageStream.getPage());
        }
        finally {
            hTMLDocument.putProperty("IgnoreCharsetDirective", object);
        }
    }

    public static void load(URL uRL, HTMLEditorKit hTMLEditorKit, HTMLDocument hTMLDocument) throws IOException, HtmlLoadException {
        HtmlLoad.read(new PageStream(uRL), hTMLEditorKit, hTMLDocument);
    }

    protected static void smartRead(PageStream pageStream, HTMLEditorKit hTMLEditorKit, HTMLDocument hTMLDocument) throws IOException {
        boolean bl;
        do {
            Object object;
            pageStream.restartStream();
            String string = (String)hTMLDocument.getProperty("content-encoding");
            Charset charset = null;
            try {
                charset = Charset.forName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                InputStreamReader inputStreamReader;
                if (charset != null) {
                    inputStreamReader = new InputStreamReader((InputStream)pageStream, charset);
                } else {
                    inputStreamReader = new InputStreamReader(pageStream);
                    try {
                        string = inputStreamReader.getEncoding();
                        charset = Charset.forName(string);
                    }
                    catch (Exception exception) {
                        string = null;
                    }
                }
                hTMLDocument.putProperty("content-encoding", string);
                hTMLEditorKit.read(inputStreamReader, (Document)hTMLDocument, 0);
                bl = true;
            }
            catch (BadLocationException badLocationException) {
                object = new IOException("Unable to finish reading");
                ((Throwable)object).initCause(badLocationException);
                throw object;
            }
            catch (ChangedCharSetException changedCharSetException) {
                Matcher matcher;
                object = changedCharSetException.getCharSetSpec();
                if (!changedCharSetException.keyEqualsCharSet() && (matcher = CHAR_SET_PATTERN.matcher((CharSequence)object)).matches()) {
                    object = matcher.group(1);
                }
                hTMLDocument.putProperty("content-encoding", object);
                try {
                    if (Charset.forName((String)object).equals(charset)) {
                        hTMLDocument.putProperty("IgnoreCharsetDirective", true);
                    }
                }
                catch (Exception exception) {
                    hTMLDocument.putProperty("content-encoding", null);
                    hTMLDocument.putProperty("IgnoreCharsetDirective", true);
                }
                HtmlLoad.clearDoc(hTMLDocument);
                bl = false;
            }
        } while (!bl);
    }

    protected class PageLoader
    extends Thread {
        PageStream _pageStream;

        PageLoader(PageStream pageStream) {
            this._pageStream = pageStream;
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HtmlLoad.read(this._pageStream, HtmlLoad.this._kit, HtmlLoad.this._doc);
                HtmlLoad htmlLoad = HtmlLoad.this;
                synchronized (htmlLoad) {
                    HtmlLoad.this._loading = null;
                }
            }
            catch (HtmlLoadException htmlLoadException) {
                HtmlLoad.this._htmlLoadInterface.errorOccurred("HtmlLoadException occured while loading file", htmlLoadException);
            }
            catch (IOException iOException) {
                HtmlLoad.this._htmlLoadInterface.errorOccurred("IOException occured while loading file", iOException);
            }
            finally {
                HtmlLoad.this._htmlLoadInterface.finishedRead();
            }
        }
    }

    protected static class PageStream
    extends FilterInputStream {
        boolean _canceled;
        URL _page;

        public PageStream(URL uRL) {
            super(null);
            this._page = uRL;
            this._canceled = false;
        }

        public void restartStream() throws IOException {
            this.checkCanceled();
            this.in = this._page.openStream();
        }

        public synchronized void cancel() {
            this._canceled = true;
        }

        protected synchronized void checkCanceled() throws IOException {
            if (this._canceled) {
                throw new IOException("HtmlLoad$PageStream.checkCanceled() canceled stream was ");
            }
        }

        public synchronized int read() throws IOException {
            this.checkCanceled();
            return super.read();
        }

        public long skip(long l) throws IOException {
            this.checkCanceled();
            return super.skip(l);
        }

        public int available() throws IOException {
            this.checkCanceled();
            return super.available();
        }

        public void reset() throws IOException {
            this.checkCanceled();
            super.reset();
        }

        public URL getPage() {
            return this._page;
        }
    }
}

