/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sis.wizardbean.licensepanel;

import com.sybase.sis.wizardbean.licensepanel.Country;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class CountryList {
    public static final String LEGAL_FILES_PROPERITES_FILE = "SybaseLicenseLegalFiles.properties";
    public static final String COUNTRY_NAMES_RESOURCE_BUNDLE = "SybaseLicenseCountryNames";
    private ResourceBundle RB = ResourceBundle.getBundle("com/sybase/sis/lang/SybaseLicensePanel");
    public static final int CONSOLE_MODE = 0;
    public static final int SWING_MODE = 1;
    private static final String HTML_EXTENTION = ".htm";
    private static final String TXT_EXTENTION = ".txt";
    private String baseURL = "";

    private void getPropertiesFromFile(Properties properties) {
        String string = this.baseURL + "/" + LEGAL_FILES_PROPERITES_FILE;
        try {
            properties.load(this.makeUrl(string).openStream());
        }
        catch (Exception exception) {
            System.err.println("Error reading in properties file : " + string);
        }
    }

    private URL makeUrl(String string) {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        return uRL;
    }

    public Country[] getCountryList(int n, String string) {
        Object[] objectArray;
        this.baseURL = string;
        Properties properties = new Properties();
        this.getPropertiesFromFile(properties);
        Vector<Country> vector = new Vector<Country>();
        if (n == 1) {
            vector.add(new Country(this.RB.getString("please_select"), null, "please_select"));
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            objectArray = enumeration.nextElement().toString();
            if (n == 1) {
                vector.add(new Country(this.getCountryNameFromFile((String)objectArray), this.makeUrl(this.baseURL + "/" + properties.getProperty((String)objectArray) + HTML_EXTENTION), (String)objectArray));
                continue;
            }
            vector.add(new Country(this.getCountryNameFromFile((String)objectArray), this.makeUrl(this.baseURL + "/" + properties.getProperty((String)objectArray) + TXT_EXTENTION), (String)objectArray));
        }
        objectArray = vector.toArray(new Country[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String getCountryNameFromFile(String string) {
        String string2;
        try {
            string2 = ResourceBundle.getBundle(this.baseURL + "/" + COUNTRY_NAMES_RESOURCE_BUNDLE).getString(string);
        }
        catch (Exception exception) {
            string2 = "Error reading from Resource file:  " + this.baseURL + "/" + COUNTRY_NAMES_RESOURCE_BUNDLE;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Error: need to specify the location of the license files set");
            System.exit(-1);
        }
        CountryList countryList = new CountryList();
        Country[] countryArray = countryList.getCountryList(1, stringArray[0]);
        for (int i = 0; i < countryArray.length; ++i) {
            countryArray[i].printLicensedCountryInfo();
        }
    }
}

