/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sis.wizardbean.licensepanel;

import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Vector;

public class SybaseLicensePanel
extends WizardPanel {
    private String[] _licenseSet = new String[0];
    private String[] _licenseSetDir = new String[0];
    private String _displayLicense = "";
    private Vector _locationIDs;
    private Vector _locationNames;
    private String[] _consoleLocationNames = null;
    private static final String THIS_BEANID = "SybaseLicense";
    private static ResourceBundle RB;
    private boolean _agreeToLicense;

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        boolean bl = super.queryEnter(wizardBeanEvent);
        RB = ResourceBundle.getBundle("com/sybase/sis/lang/SybaseLicensePanel");
        return bl;
    }

    public String getBeanId() {
        return THIS_BEANID;
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putPackage("com.sybase.sis.wizardbean.licensepanel", true);
            wizardBuilderSupport.putPackage("com.sybase.sis.lang", true);
            wizardBuilderSupport.putPackage("com.sybase.sis.util.swing", true);
            if (this._licenseSet.length != this._licenseSetDir.length) {
                wizardBuilderSupport.logEvent(this, "err", "SybaseLicensePanel.LicenseFilesSet and SybaseLicensePanel.LicenseFilesSetDirectory properties must contain number of items.");
                wizardBuilderSupport.setBuildCanceled(true);
            }
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        if (wizardBeanEvent.getUserInterface() == null) {
            RB = ResourceBundle.getBundle("com/sybase/sis/lang/SybaseLicensePanel");
            if (this.getAgreeToLicense()) {
                return;
            }
            super.getWizard().exit(1, RB.getString("agree_license_missing"));
        }
        super.execute(wizardBeanEvent);
    }

    public static void main(String[] stringArray) {
        new SybaseLicensePanel();
    }

    public String getPleaseSelectText() {
        return RB.getString("please_select");
    }

    public String getLicenseApprovalText() {
        return RB.getString("license_approval_text");
    }

    public String getLicenseDisapprovalText() {
        return RB.getString("license_disapproval_text");
    }

    public char getLicenseApprovalShort() {
        return RB.getString("license_approval_short").charAt(0);
    }

    public char getLicenseDisapprovalShort() {
        return RB.getString("license_disapproval_short").charAt(0);
    }

    public static String getFileLoadErrorText() {
        return RB.getString("file_load_error");
    }

    public String getLicenseNotesText() {
        return RB.getString("license_notes");
    }

    public boolean getAgreeToLicense() {
        return this._agreeToLicense;
    }

    public void setAgreeToLicense(boolean bl) {
        this._agreeToLicense = bl;
    }

    public String getLicenseFileText(URL uRL) {
        Object object;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = new InputStreamReader(uRL.openStream(), "utf-8");
            char[] cArray = new char[2048];
            while (((InputStreamReader)object).read(cArray, 0, 2048) != -1) {
                stringBuffer.append(cArray);
                Arrays.fill(cArray, 0, 2048, ' ');
            }
            ((InputStreamReader)object).close();
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
        }
        string = stringBuffer.toString();
        try {
            if (string.length() > 0 && (object = (Object)string.getBytes("utf-8"))[0] == -17 && object[1] == -69 && object[2] == -65) {
                string = string.substring(1);
            }
        }
        catch (IOException iOException) {
            this.logEvent(this, "err", iOException);
        }
        return string;
    }

    public String getBaseURL() {
        String string = "com/sybase/sis/wizardbean/licensepanel/LegalFiles";
        String string2 = this.resolveString(this._displayLicense);
        for (int i = 0; i < this._licenseSet.length; ++i) {
            if (!string2.equals(this._licenseSet[i])) continue;
            string = this._licenseSetDir[i];
            break;
        }
        return string;
    }

    public boolean isUseProductionLicenses() {
        String string = this.resolveString(this._displayLicense);
        for (int i = 0; i < this._licenseSet.length; ++i) {
            if (!string.equals(this._licenseSet[i])) continue;
            return false;
        }
        return true;
    }

    public void setLicenseFilesSet(String[] stringArray) {
        this._licenseSet = stringArray;
    }

    public String[] getLicenseFilesSet() {
        return this._licenseSet;
    }

    public void setLicenseFilesSetDirectory(String[] stringArray) {
        this._licenseSetDir = stringArray;
    }

    public String[] getLicenseFilesSetDirectory() {
        return this._licenseSetDir;
    }

    public void setDisplayLicenseFilesSet(String string) {
        this._displayLicense = string;
    }

    public String getDisplayLicenseFilesSet() {
        return this._displayLicense;
    }
}

