/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sis.wizardbean.licensepanel;

import com.installshield.util.HtmlToTextConverter;
import com.installshield.util.TTYDisplay;
import com.installshield.util.TTYPrompt;
import com.installshield.wizard.console.DefaultConsoleWizardPanelImpl;
import com.sybase.sis.wizardbean.licensepanel.Country;
import com.sybase.sis.wizardbean.licensepanel.CountryList;
import com.sybase.sis.wizardbean.licensepanel.SybaseLicensePanel;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class SybaseLicensePanelConsoleImpl
extends DefaultConsoleWizardPanelImpl {
    private static ResourceBundle RB;

    private SybaseLicensePanel getSybaseLicensePanel() {
        return (SybaseLicensePanel)this.getPanel();
    }

    protected void consoleInteraction(TTYDisplay tTYDisplay) {
        Object object;
        super.consoleInteraction(tTYDisplay);
        try {
            RB = ResourceBundle.getBundle("com/sybase/sis/lang/SybaseLicensePanel");
        }
        catch (Exception exception) {
            System.err.println(SybaseLicensePanelConsoleImpl.getNoLiceseFileText());
        }
        SybaseLicensePanel sybaseLicensePanel = (SybaseLicensePanel)this.getPanel();
        String string = sybaseLicensePanel.getBaseURL();
        this.logEvent(this, "dbg", "Using license files set: " + string);
        Country[] countryArray = new CountryList().getCountryList(0, string);
        this.displayTable(this.buildTable(countryArray));
        String string2 = this.getLicensePromptText() + "(1-" + countryArray.length + ")";
        int n = tTYDisplay.promptInt(string2, 1, 1, countryArray.length);
        try {
            object = countryArray[n - 1].getLicenseFileUrl();
            if (object == null) {
                System.out.println("");
                System.out.println(sybaseLicensePanel.getFileLoadErrorText() + " " + countryArray[n].getDisplayName());
                System.out.println("");
                System.out.println(this.getConsoleLoadErrorText());
                System.out.println("");
            }
            tTYDisplay.printPage(sybaseLicensePanel.getLicenseFileText((URL)object));
        }
        catch (Exception exception) {
            this.logEvent(this, "dbg", exception);
        }
        object = new TTYPrompt();
        ((TTYPrompt)object).setText(new HtmlToTextConverter().convertText(sybaseLicensePanel.getLicenseApprovalText()) + this.getYesNoOptionText());
        ((TTYPrompt)object).setOptions(new String[]{this.getYesShortText(), this.getNoShortText()});
        ((TTYPrompt)object).setDefaultValue(this.getNoShortText());
        ((TTYPrompt)object).setIgnoreCase(true);
        TTYPrompt tTYPrompt = new TTYPrompt();
        tTYPrompt.setText(this.getLicenseAssureText());
        tTYPrompt.setOptions(new String[]{this.getYesShortText(), this.getNoShortText()});
        tTYPrompt.setDefaultValue(this.getNoShortText());
        tTYPrompt.setIgnoreCase(true);
        boolean bl = true;
        while (bl) {
            String string3 = tTYDisplay.prompt((TTYPrompt)object);
            if (string3.equalsIgnoreCase(this.getYesShortText())) {
                bl = false;
                continue;
            }
            if (string3.equalsIgnoreCase(this.getNoShortText())) {
                String string4 = tTYDisplay.prompt(tTYPrompt);
                if (string4.equalsIgnoreCase(this.getYesShortText())) {
                    System.exit(0);
                    continue;
                }
                if (string4.equalsIgnoreCase(this.getNoShortText())) continue;
                System.err.println(this.getConsoleSystemErrorText());
                System.exit(0);
                continue;
            }
            System.err.println(this.getConsoleSystemErrorText());
            System.exit(0);
        }
    }

    public Vector buildTable(Country[] countryArray) {
        Vector vector = new Vector();
        for (int i = 0; i < countryArray.length; ++i) {
            Vector<String> vector2 = new Vector<String>();
            if (i / 10 == 0) {
                vector2.addElement(i + 1 + ")  " + countryArray[i]);
            } else {
                vector2.addElement(i + 1 + ") " + countryArray[i]);
            }
            if (++i / 10 == 0 && i < countryArray.length) {
                vector2.addElement(i + 1 + ")  " + countryArray[i]);
            } else if (i < countryArray.length) {
                vector2.addElement(i + 1 + ") " + countryArray[i]);
            }
            vector.addElement(vector2);
        }
        return vector;
    }

    public void displayTable(Vector vector) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        printWriter.print(this.createTable(vector));
        printWriter.flush();
    }

    private String createTable(Vector vector) {
        int n;
        String string;
        Object object;
        int n2;
        Object object2;
        int n3 = 79;
        String string2 = new String();
        int n4 = vector.size();
        int n5 = 0;
        String[][] stringArray = vector.elements();
        while (stringArray.hasMoreElements()) {
            object2 = (Vector)stringArray.nextElement();
            if (((Vector)object2).size() <= n5) continue;
            n5 = ((Vector)object2).size();
        }
        stringArray = new String[n4][n5];
        object2 = new int[n5];
        for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
            object2[n2] = false;
        }
        n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector2.elements();
            for (object = 0; object < n5; ++object) {
                string = "";
                if (enumeration2.hasMoreElements()) {
                    string = (String)enumeration2.nextElement();
                }
                if (string == null || string.equals("")) {
                    string = " ";
                }
                stringArray[n2][object] = string;
                if (this.byteLength(string) <= object2[object]) continue;
                object2[object] = this.byteLength(string);
            }
            ++n2;
        }
        int n6 = 0;
        for (n = 0; n < ((Object)object2).length; ++n) {
            n6 += object2[n] + 2;
        }
        while (n6 > n3) {
            Object object3 = object2;
            int n7 = this.arrayLargest((int[])object2);
            object3[n7] = object3[n7] - true;
            --n6;
        }
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < stringArray[0].length; ++i) {
                object = object2[i];
                string = stringArray[n][i];
                int n8 = this.byteLength(string);
                if (n8 > object) {
                    string = string.substring(0, (int)object);
                }
                if (n8 < object) {
                    for (int j = n8; j < object; ++j) {
                        string = string + " ";
                    }
                }
                string = " " + string + " ";
                string2 = string2 + string;
            }
            string2 = string2 + System.getProperty("line.separator");
        }
        return string2;
    }

    private int byteLength(String string) {
        byte[] byArray = string.getBytes();
        return byArray.length;
    }

    private int arrayLargest(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i] <= nArray[n] ? n : i;
        }
        return n;
    }

    private String getLicensePromptText() {
        return RB.getString("license_prompt");
    }

    private static String getNoLiceseFileText() {
        return RB.getString("no_license_file");
    }

    private String getYesNoOptionText() {
        return RB.getString("yes_no_option");
    }

    private String getNoShortText() {
        return RB.getString("no_short");
    }

    private String getYesShortText() {
        return RB.getString("yes_short");
    }

    private String getAgreeLicenseMissingText() {
        return RB.getString("agree_license_missing");
    }

    private String getLicenseAssureText() {
        return RB.getString("license_assure");
    }

    private String getConsoleLoadErrorText() {
        return RB.getString("console_load_error");
    }

    private String getConsoleSystemErrorText() {
        return RB.getString("console_system_error");
    }
}

