/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.FastEntries;
import com.sun.javaws.cache.FastFilename;
import com.sun.javaws.cache.FastFilenames;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.security.JavawsHttpsCertStore;
import com.sun.javaws.util.BASE64Encoder;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DiskCache {
    private static final int BUF_SIZE = 32768;
    public static final char DIRECTORY_TYPE = 'D';
    public static final char TEMP_TYPE = 'X';
    public static final char VERSION_TYPE = 'V';
    public static final char INDIRECT_TYPE = 'I';
    public static final char RESOURCE_TYPE = 'R';
    public static final char APPLICATION_TYPE = 'A';
    public static final char EXTENSION_TYPE = 'E';
    public static final char MUFFIN_TYPE = 'P';
    private File _baseDir;
    public static final char MAIN_FILE_TAG = 'M';
    public static final char NATIVELIB_FILE_TAG = 'N';
    public static final char TIMESTAMP_FILE_TAG = 'T';
    public static final char CERTIFICATE_FILE_TAG = 'C';
    public static final char LAP_FILE_TAG = 'L';
    public static final char MAPPED_IMAGE_FILE_TAG = 'B';
    public static final char MUFFIN_ATTR_FILE_TAG = 'U';
    public static final int MUFFIN_TAG_INDEX = 0;
    public static final int MUFFIN_MAXSIZE_INDEX = 1;
    private static final String LAST_ACCESS_FILE = "lastAccessed";
    private static final String ORPHAN_LIST_FILE = "orphans";
    private static final String BEGIN_CERT_MARK = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT_MARK = "-----END CERTIFICATE-----";
    FastEntries fastentries = new FastEntries();
    FastFilenames fastnames = new FastFilenames();

    public long getCacheSize() throws IOException {
        if (Globals.TraceDiskCache) {
            Debug.println("Computing diskcache size: " + this._baseDir.getAbsoluteFile());
        }
        SizeVisitor sizeVisitor = new SizeVisitor(this);
        this.visitDiskCache('R', sizeVisitor);
        return sizeVisitor.getSize();
    }

    long getLastUpdate() {
        File file = new File(this._baseDir, LAST_ACCESS_FILE);
        return file.lastModified();
    }

    private void recordLastUpdate() {
        File file = new File(this._baseDir, LAST_ACCESS_FILE);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void uninstallCache() {
        this.deleteFile(this._baseDir);
        if (this._baseDir.exists()) {
            this.recordLastUpdate();
        }
    }

    void visitDiskCache(char c, DiskCacheVisitor diskCacheVisitor) throws IOException {
        this.visitDiskCacheHelper(this._baseDir, 0, c, diskCacheVisitor);
    }

    public void removeEntry(DiskCacheEntry diskCacheEntry) {
        char c = diskCacheEntry.getType();
        URL uRL = diskCacheEntry.getLocation();
        this.removeOrphans(uRL);
        String string = diskCacheEntry.getVersionId();
        this.deleteEntry(c, 'M', uRL, string);
        this.deleteEntry(c, 'T', uRL, string);
        this.deleteEntry(c, 'C', uRL, string);
        this.deleteEntry(c, 'N', uRL, string);
        this.deleteEntry(c, 'B', uRL, string);
        this.deleteEntry(c, 'L', uRL, string);
        if (c == 'R') {
            this.deleteEntry('I', 'M', uRL, string);
        }
        this.removeEmptyDirs(uRL);
    }

    public void removeMuffinEntry(DiskCacheEntry diskCacheEntry) {
        char c = diskCacheEntry.getType();
        URL uRL = diskCacheEntry.getLocation();
        String string = diskCacheEntry.getVersionId();
        this.deleteEntry(c, 'M', uRL, string);
        this.deleteEntry(c, 'U', uRL, string);
    }

    public DiskCache(File file) {
        this._baseDir = file;
    }

    private void deleteFile(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.deleteFile(fileArray[i]);
            }
        }
        file.delete();
    }

    private void removeEmptyDirs(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            boolean bl = false;
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.removeEmptyDirs(fileArray[i]);
                    if (!fileArray[i].exists()) continue;
                    bl = true;
                }
            }
            if (!bl) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    Debug.ignoredException(exception);
                }
            }
        }
    }

    public boolean isMainMuffinFile(File file) throws IOException {
        DiskCacheEntry diskCacheEntry = this.fileToEntry(file);
        return file.equals(this.getFileFromCache('P', 'M', diskCacheEntry.getLocation(), null, false));
    }

    public long getMuffinSize(URL uRL) throws IOException {
        long l = 0L;
        File file = this.getFileFromCache('P', 'M', uRL, null, true);
        if (file != null && file.exists()) {
            l += file.length();
        }
        return l;
    }

    private void removeEmptyDirs(URL uRL) {
        String string = this.getBaseDirForHost(uRL);
        if (string != null) {
            this.removeEmptyDirs(new File(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeOrphans(URL var1_1) {
        block21: {
            var2_2 = this.getOrphanFileForHost(var1_1);
            if (var2_2 == null) return;
            if (var2_2.exists() == false) return;
            var3_3 = null;
            var4_4 = null;
            var5_5 = false;
            var6_6 = new ArrayList<String>();
            try {
                var7_7 = new FileInputStream(var2_2);
                var3_3 = new BufferedReader(new InputStreamReader(var7_7));
                while ((var8_11 = var3_3.readLine()) != null) {
                    var6_6.add(var8_11);
                }
                for (var9_12 = var6_6.size() - 1; var9_12 >= 0; --var9_12) {
                    var10_13 = new File((String)var6_6.get(var9_12));
                    var10_13.delete();
                    if (var10_13.exists()) continue;
                    var5_5 = true;
                    var6_6.remove(var9_12);
                }
                var12_14 = null;
                if (var3_3 == null) break block21;
                ** GOTO lbl49
            }
            catch (IOException var7_8) {
                Debug.ignoredException(var7_8);
                var12_14 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var13_16) {
                        Debug.ignoredException(var13_16);
                    }
                }
                break block21;
            }
            {
                catch (Throwable var11_18) {
                    var12_15 = null;
                    if (var3_3 == null) throw var11_18;
                    ** try [egrp 2[TRYBLOCK] [4 : 179->186)] { 
lbl44:
                    // 1 sources

                    var3_3.close();
                    throw var11_18;
lbl46:
                    // 1 sources

                    catch (IOException var13_17) {
                        Debug.ignoredException(var13_17);
                    }
                    throw var11_18;
                }
lbl49:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 179->186)] { 
lbl50:
                // 1 sources

                var3_3.close();
lbl52:
                // 1 sources

                catch (IOException var13_16) {}
                Debug.ignoredException(var13_16);
            }
        }
        if (var5_5 == false) return;
        try {
            if (var6_6.isEmpty()) {
                if (Globals.TraceDiskCache) {
                    Debug.println("emptying orphans file");
                }
                var2_2.delete();
                return;
            }
            var4_4 = new PrintStream(new FileOutputStream(var2_2));
            var7_9 = 0;
            while (var7_9 < var6_6.size()) {
                if (Globals.TraceDiskCache) {
                    Debug.println("Remaining orphan: " + var6_6.get(var7_9));
                }
                var4_4.println((String)var6_6.get(var7_9));
                ++var7_9;
            }
            return;
        }
        catch (Exception var7_10) {
            Debug.ignoredException(var7_10);
            return;
        }
        finally {
            if (var4_4 != null) {
                var4_4.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getMuffinAttributes(URL uRL) throws IOException {
        BufferedReader bufferedReader = null;
        long l = -1L;
        long l2 = -1L;
        try {
            InputStream inputStream = this.getInputStream('P', 'U', uRL, null);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            try {
                l = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            string = bufferedReader.readLine();
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return new long[]{l, l2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMuffinAttributes(URL uRL, int n, long l) throws IOException {
        PrintStream printStream = new PrintStream(this.getOutputStream('P', 'U', uRL, null));
        try {
            printStream.println(n);
            printStream.println(l);
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    private void visitDiskCacheHelper(File file, int n, char c, DiskCacheVisitor diskCacheVisitor) throws IOException {
        String string = file.getName();
        if (file.isDirectory() && (string.length() <= 2 || file.getName().charAt(1) != 'N')) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.visitDiskCacheHelper(fileArray[i], n + 1, c, diskCacheVisitor);
            }
        } else if (string.length() > 2 && n > 3) {
            char c2 = string.charAt(0);
            char c3 = string.charAt(1);
            if (c2 == c && c3 == 'M') {
                DiskCacheEntry diskCacheEntry = this.getCacheEntryFromFile(file);
                Debug.jawsAssert(diskCacheEntry != null, "should never return null");
                diskCacheVisitor.visitEntry(diskCacheEntry);
            }
        }
    }

    private DiskCacheEntry fileToEntry(File file) {
        Object object;
        String string;
        if (Globals.TraceDiskCache) {
            Debug.println("FileToEntry: " + file);
        }
        char c = '\u0000';
        URL uRL = null;
        String string2 = null;
        long l = 0L;
        String string3 = file.getAbsolutePath();
        if (!string3.startsWith(string = this._baseDir.getAbsolutePath())) {
            return null;
        }
        string3 = string3.substring(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string3, File.separator, false);
        try {
            object = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (string4.length() < 1) {
                return null;
            }
            string4 = string4.substring(1);
            String string5 = stringTokenizer.nextToken();
            if (string5.length() < 1) {
                return null;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string5.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreElements()) {
                String string6 = stringTokenizer.nextToken();
                if ((string6 = DiskCache.removeEscapes(string6)).length() < 1) {
                    return null;
                }
                c = string6.charAt(0);
                if (c == 'V') {
                    string2 = string6.substring(1);
                    continue;
                }
                stringBuffer.append('/');
                stringBuffer.append(string6.substring(2));
            }
            uRL = new URL((String)object, string4, n, stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        object = new DiskCacheEntry(c, uRL, string2, file, 0L);
        if (Globals.TraceDiskCache) {
            Debug.println("Returning: " + object);
        }
        return object;
    }

    public DiskCacheEntry getCacheEntryFromFile(File file) throws IOException {
        DiskCacheEntry diskCacheEntry = this.fileToEntry(file);
        if (diskCacheEntry.getType() == 'P') {
            return this.getMuffinEntry(diskCacheEntry.getType(), diskCacheEntry.getLocation());
        }
        return this.getCacheEntry(diskCacheEntry.getType(), diskCacheEntry.getLocation(), diskCacheEntry.getVersionId());
    }

    public DiskCacheEntry getMuffinEntry(char c, URL uRL) throws IOException {
        File file = this.getFileFromCache(c, 'M', uRL, null, true);
        if (file == null) {
            return null;
        }
        File file2 = this.getFileFromCache(c, 'U', uRL, null, true);
        return new DiskCacheEntry(c, uRL, null, file, -1L, null, null, null, file2);
    }

    public File getMuffinFileForURL(URL uRL) {
        try {
            return this.getFileFromCache('P', 'M', uRL, null, false);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private File getOrphanFileForHost(URL uRL) {
        try {
            return new File(this.getBaseDirForHost(uRL), ORPHAN_LIST_FILE);
        }
        catch (Exception exception) {
            Debug.ignoredException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphan(URL uRL, File file) {
        if (Globals.TraceDiskCache) {
            Debug.println("addOrphan: " + file);
        }
        File file2 = this.getOrphanFileForHost(uRL);
        PrintStream printStream = null;
        if (file2 != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(file2.getPath(), true));
                printStream.println(file.getCanonicalPath());
            }
            catch (Exception exception) {
                Debug.ignoredException(exception);
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
            }
        }
    }

    public void insertMuffinEntry(URL uRL, File file, int n, long l) throws IOException {
        File file2 = this.getFileFromCache('P', 'M', uRL, null, false);
        if (file2.exists()) {
            file.delete();
            throw new IOException("insert failed in cache: target already exixts");
        }
        if (!file.renameTo(file2)) {
            throw new IOException("rename failed in cache");
        }
        this.putMuffinAttributes(uRL, n, l);
    }

    private String convertURLfile(char c, char c2, String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.substring(i).startsWith("..\\")) {
                i += 2;
                continue;
            }
            if (string.charAt(i) == '/') {
                stringBuffer.append(File.separatorChar);
                stringBuffer.append('D');
                stringBuffer.append('M');
                n = stringBuffer.length();
                continue;
            }
            if (string.charAt(i) == ':') {
                stringBuffer.append("&c");
                continue;
            }
            if (string.charAt(i) == '&') {
                stringBuffer.append("&&");
                continue;
            }
            if (string.charAt(i) == '%') {
                stringBuffer.append("&p");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        if (n == -1) {
            stringBuffer.insert(0, c);
            stringBuffer.insert(1, c2);
        } else {
            stringBuffer.setCharAt(n - 2, c);
            stringBuffer.setCharAt(n - 1, c2);
        }
        return stringBuffer.toString();
    }

    private static String removeEscapes(String string) {
        int n;
        if (string == null || string.indexOf(38) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (n = 0; n < string.length() - 1; ++n) {
            char c = string.charAt(n);
            char c2 = string.charAt(n + 1);
            if (c == '&' && c2 == 'p') {
                ++n;
                stringBuffer.append('%');
                continue;
            }
            if (c == '&' && c2 == 'c') {
                ++n;
                stringBuffer.append(':');
                continue;
            }
            if (c == '&' && c2 == '&') continue;
            stringBuffer.append(c);
        }
        if (n < string.length()) {
            stringBuffer.append(string.charAt(n));
        }
        return stringBuffer.toString();
    }

    private void deleteEntry(char c, char c2, URL uRL, String string) {
        File file = null;
        try {
            file = c2 == 'B' ? this.getMappedImage(c, c2, uRL, string, false) : this.getFileFromCache(c, c2, uRL, string, false);
            this.deleteFile(file);
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        if (file != null && file.exists() && c == 'R' && c2 == 'M') {
            this.addOrphan(uRL, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getEntryContent(char c, char c2, URL uRL, String string) throws IOException {
        File file = this.getFileFromCache(c, c2, uRL, string, true);
        if (file == null) {
            return null;
        }
        long l = file.length();
        if (l > 0x40000000L) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);
        byte[] byArray = new byte[32768];
        try {
            int n = bufferedInputStream.read(byArray);
            while (n >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
        }
        finally {
            byteArrayOutputStream.close();
            bufferedInputStream.close();
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeAtomic(char c, char c2, URL uRL, String string, byte[] byArray) throws IOException {
        File file = this.getTempCacheFile(uRL, string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray2 = new byte[32768];
        try {
            int n = byteArrayInputStream.read(byArray2);
            while (n >= 0) {
                bufferedOutputStream.write(byArray2, 0, n);
                n = byteArrayInputStream.read(byArray2);
            }
        }
        finally {
            bufferedOutputStream.close();
            ((InputStream)byteArrayInputStream).close();
        }
        this.putFileInCache(c, c2, uRL, string, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    long getTimeStamp(char c, URL uRL, String string) {
        BufferedReader bufferedReader = null;
        InputStream inputStream = this.getInputStream(c, 'T', uRL, string);
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        long l = Long.parseLong(string2);
        Object var11_11 = null;
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        return l;
        {
            catch (NumberFormatException numberFormatException) {
                long l2 = 0L;
                Object var11_12 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
                return l2;
                catch (IOException iOException) {
                    long l3;
                    try {
                        l3 = 0L;
                        Object var11_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException2) {
                            Debug.ignoredException(iOException2);
                        }
                        throw throwable;
                    }
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException3) {
                        Debug.ignoredException(iOException3);
                    }
                    return l3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putTimeStamp(char c, URL uRL, String string, long l) throws IOException {
        if (l == 0L) {
            l = new Date().getTime();
        }
        PrintStream printStream = new PrintStream(this.getOutputStream(c, 'T', uRL, string));
        try {
            printStream.println(l);
            printStream.println("# " + new Date(l));
        }
        finally {
            printStream.close();
        }
    }

    public String getBaseDirForHost(URL uRL) {
        try {
            URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "");
            String string = this.keyToFileLocation('R', 'M', uRL2, null);
            int n = string.lastIndexOf(File.separator);
            return string.substring(0, n);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.shouldNotReachHere();
            return null;
        }
    }

    public URL[] getAccessibleMuffins(URL uRL) throws IOException {
        MuffinAccessVisitor muffinAccessVisitor = new MuffinAccessVisitor(this, uRL);
        this.visitDiskCache('P', muffinAccessVisitor);
        return muffinAccessVisitor.getAccessibleMuffins();
    }

    private ArrayList getCacheEntries(char c, URL uRL) throws IOException {
        Object object;
        int n;
        ArrayList<DiskCacheEntry> arrayList = new ArrayList<DiskCacheEntry>();
        String string = this.keyToFileLocation(c, 'M', uRL, "MATCH");
        int n2 = string.indexOf(File.separator + 'V' + "MATCH" + File.separator);
        Debug.jawsAssert(n2 != -1, "Must be found");
        String string2 = string.substring(0, n2);
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        for (n = 0; n < fileArray.length; ++n) {
            String string3;
            File file2;
            object = fileArray[n].getName();
            if (object.length() <= 0 || object.charAt(0) != 'V' || (file2 = this.getFileFromCache(c, 'M', uRL, string3 = object.substring(1), true)) == null) continue;
            DiskCacheEntry diskCacheEntry = this.getCacheEntry(c, uRL, string3);
            arrayList.add(diskCacheEntry);
        }
        n = arrayList.size();
        if (n > 1) {
            object = new DiskCacheEntry[n];
            object = arrayList.toArray((T[])object);
            Arrays.sort(object, new Comparator(this){
                private final DiskCache this$0;
                {
                    this.this$0 = diskCache;
                }

                public int compare(Object object, Object object2) {
                    VersionID versionID;
                    DiskCacheEntry diskCacheEntry = (DiskCacheEntry)object;
                    DiskCacheEntry diskCacheEntry2 = (DiskCacheEntry)object2;
                    VersionID versionID2 = new VersionID(diskCacheEntry.getVersionId());
                    return versionID2.isGreaterThan(versionID = new VersionID(diskCacheEntry2.getVersionId())) ? -1 : 1;
                }
            });
            for (int i = 0; i < n; ++i) {
                arrayList.set(i, object[i]);
            }
        }
        if ((object = this.getFileFromCache(c, 'M', uRL, null, true)) != null) {
            DiskCacheEntry diskCacheEntry = this.getCacheEntry(c, uRL, null);
            arrayList.add(diskCacheEntry);
        }
        return arrayList;
    }

    public DiskCacheEntry getCacheEntry(char c, URL uRL, String string) throws IOException {
        File file = this.getFileFromCache(c, 'M', uRL, string, true);
        if (file == null) {
            return null;
        }
        File file2 = this.getFileFromCache(c, 'N', uRL, string, true);
        File file3 = this.getMappedImage(c, 'B', uRL, string, true);
        File file4 = this.getFileFromCache(c, 'C', uRL, string, false);
        Certificate[] certificateArray = this.getCertificateChain(c, uRL, string);
        long l = this.getTimeStamp(c, uRL, string);
        DiskCacheEntry diskCacheEntry = new DiskCacheEntry(c, uRL, string, file, l, file4, file2, file3, null);
        diskCacheEntry.setCertificateChain(certificateArray);
        return diskCacheEntry;
    }

    public DiskCacheEntry getFastCacheEntry(char c, URL uRL, String string, boolean bl) throws IOException {
        Object object;
        long l;
        if (Globals.TraceDiskCache) {
            Debug.println("getFastCacheEntry: t=" + c + "u=" + uRL + ",v=" + string);
        }
        String string2 = this.keyToFileLocation(c, 'M', uRL, string);
        FastFilename fastFilename = new FastFilename(c, string2);
        File file = new File(string2);
        long l2 = file.lastModified();
        if ('R' == c && (l = new File((String)(object = fastFilename.getFilename('I', 'M'))).lastModified()) > l2) {
            l2 = l;
        }
        if (l2 == 0L) {
            if (Globals.TraceDiskCache) {
                Debug.println("getFastCacheEntry: Not found " + string2);
            }
            return null;
        }
        object = this.fastentries.get(string2);
        if (object != null) {
            if (l2 != ((FastEntries.FastCacheEntry)object).getLastModified()) {
                if (Globals.TraceDiskCache) {
                    Debug.println("Stale FastCacheEntry: " + ((FastEntries.FastCacheEntry)object).getDiskEntry());
                }
            } else {
                if (Globals.TraceDiskCache) {
                    Debug.println("using FastCacheEntry: " + ((FastEntries.FastCacheEntry)object).getDiskEntry());
                }
                return ((FastEntries.FastCacheEntry)object).getDiskEntry();
            }
        }
        if (!bl) {
            return null;
        }
        this.fastnames.put(uRL, string, fastFilename);
        DiskCacheEntry diskCacheEntry = this.getCacheEntry(c, uRL, string);
        this.fastentries.add(string2, diskCacheEntry);
        if (Globals.TraceDiskCache) {
            Debug.println("Created FastCacheEntry for : " + diskCacheEntry);
        }
        return diskCacheEntry;
    }

    public DiskCacheEntry[] getCacheEntries(char c, URL uRL, String string, boolean bl) throws IOException {
        DiskCacheEntry[] diskCacheEntryArray;
        if (string == null) {
            DiskCacheEntry diskCacheEntry = this.getCacheEntry(c, uRL, null);
            if (diskCacheEntry == null) {
                return new DiskCacheEntry[0];
            }
            return new DiskCacheEntry[]{diskCacheEntry};
        }
        ArrayList arrayList = this.getCacheEntries(c, uRL);
        VersionString versionString = new VersionString(string);
        DiskCacheEntry[] diskCacheEntryArray2 = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            diskCacheEntryArray = (DiskCacheEntry[])iterator.next();
            String string2 = diskCacheEntryArray.getVersionId();
            if (string2 == null) {
                iterator.remove();
                continue;
            }
            if (versionString.contains(string2)) continue;
            if (diskCacheEntryArray2 == null && versionString.containsGreaterThan(string2)) {
                diskCacheEntryArray2 = diskCacheEntryArray;
            }
            iterator.remove();
        }
        if (!bl && arrayList.size() == 0 && diskCacheEntryArray2 != null) {
            arrayList.add(diskCacheEntryArray2);
        }
        diskCacheEntryArray = new DiskCacheEntry[arrayList.size()];
        return arrayList.toArray(diskCacheEntryArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromCache(char c, char c2, URL uRL, String string, boolean bl) throws IOException {
        File file;
        BufferedReader bufferedReader = null;
        if (c == 'R' && c2 == 'M' && (file = this.getFileFromCache('I', c2, uRL, string, false)).exists()) {
            try {
                File file2;
                InputStream inputStream = this.getInputStream('I', 'M', uRL, string);
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string2 = bufferedReader.readLine();
                File file3 = file2 = new File(string2);
                return file3;
            }
            catch (IOException iOException) {
                if (bl) {
                    File file4 = null;
                    return file4;
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        File file5 = new File(this.keyToFileLocation(c, c2, uRL, string));
        if (bl && !file5.exists()) {
            return null;
        }
        return file5;
    }

    public File getMappedImage(char c, char c2, URL uRL, String string, boolean bl) throws IOException {
        String string2;
        File file = this.getFileFromCache(c, c2, uRL, string, bl);
        if (!(file != null && file.exists() || (string2 = uRL.getFile()).endsWith(".ico"))) {
            string2 = string2 + ".ico";
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string2);
            file = this.getFileFromCache(c, c2, uRL, string, bl);
        }
        return file;
    }

    void insertEntry(char c, URL uRL, String string, File file, long l) throws IOException {
        this.putTimeStamp(c, uRL, string, l);
        this.putFileInCache(c, 'M', uRL, string, file);
        this.recordLastUpdate();
    }

    File createNativeLibDir(URL uRL, String string) throws IOException {
        File file = this.getFileFromCache('R', 'N', uRL, string, false);
        file.mkdirs();
        return file;
    }

    public File getTempCacheFile(URL uRL, String string) throws IOException {
        String string2 = this.keyToFileLocation('X', 'M', uRL, string);
        File file = new File(string2);
        File file2 = file.getParentFile();
        file2.mkdirs();
        return File.createTempFile("java-" + file.getName(), "tmp", file2);
    }

    private InputStream getInputStream(char c, char c2, URL uRL, String string) throws IOException {
        return new FileInputStream(this.getFileFromCache(c, c2, uRL, string, false));
    }

    private OutputStream getOutputStream(char c, char c2, URL uRL, String string) throws IOException {
        File file = this.getFileFromCache(c, c2, uRL, string, false);
        file.getParentFile().mkdirs();
        file.createNewFile();
        this.recordLastUpdate();
        return new FileOutputStream(file);
    }

    private String keyToFileLocation(char c, char c2, URL uRL, String string) {
        FastFilename fastFilename = this.fastnames.get(uRL, string);
        if (fastFilename != null) {
            String string2 = fastFilename.getFilename(c, c2);
            if (Globals.TraceDiskCache) {
                Debug.println("Using fastfilename: " + string2);
            }
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(uRL.toString().length() + (string == null ? 0 : string.length()) * 2);
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(File.separatorChar);
        stringBuffer.append('D');
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(File.separatorChar);
        String string3 = null;
        string3 = uRL.getPort() == -1 && uRL.getProtocol().equals("http") ? "P80" : "P" + new Integer(uRL.getPort()).toString();
        stringBuffer.append(string3);
        stringBuffer.append(File.separatorChar);
        if (string != null) {
            stringBuffer.append('V');
            stringBuffer.append(string);
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(this.convertURLfile(c, c2, uRL.getFile()));
        return this._baseDir.getAbsolutePath() + File.separator + stringBuffer.toString();
    }

    public void putLaunchFile(char c, URL uRL, String string, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF8");
        this.storeAtomic(c, 'M', uRL, string, byArray);
        this.putTimeStamp(c, uRL, string, new Date().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate[] getCertificateChain(char c, URL uRL, String string) throws IOException {
        Certificate[] certificateArray;
        File file = this.getFileFromCache(c, 'C', uRL, string, false);
        if (!file.exists()) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        try {
            certificateArray = CertificateFactory.getInstance("X.509");
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            while (byteArrayInputStream.available() > 0) {
                arrayList.add(certificateArray.generateCertificate(byteArrayInputStream));
            }
        }
        catch (CertificateException certificateException) {
            Debug.ignoredException(certificateException);
        }
        finally {
            dataInputStream.close();
        }
        if (arrayList.size() == 0) {
            return null;
        }
        certificateArray = new Certificate[arrayList.size()];
        return arrayList.toArray(certificateArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCertificateChain(char c, URL uRL, String string, Certificate[] certificateArray) throws IOException {
        PrintStream printStream = new PrintStream(this.getOutputStream(c, 'C', uRL, string));
        try {
            if (certificateArray != null) {
                for (int i = 0; i < certificateArray.length; ++i) {
                    BASE64Encoder bASE64Encoder = new BASE64Encoder();
                    byte[] byArray = certificateArray[i].getEncoded();
                    printStream.println(BEGIN_CERT_MARK);
                    bASE64Encoder.encodeBuffer(byArray, (OutputStream)printStream);
                    printStream.println(END_CERT_MARK);
                }
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Debug.ignoredException(certificateEncodingException);
        }
        finally {
            printStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File putFileInCache(char c, char c2, URL uRL, String string, File file) throws IOException {
        File file2;
        File file3 = new File(this.keyToFileLocation(c, c2, uRL, string));
        this.removeOrphans(uRL);
        file3.delete();
        if (!file.renameTo(file3)) {
            this.deleteEntry(c, c2, uRL, string);
            if (c == 'R' && c2 == 'M') {
                PrintStream printStream = new PrintStream(this.getOutputStream('I', 'M', uRL, string));
                try {
                    printStream.println(file.getCanonicalPath());
                }
                finally {
                    printStream.close();
                }
                return file;
            }
            throw new IOException("rename failed in cache to: " + file3);
        }
        if (c == 'R' && c2 == 'M' && (file2 = this.getFileFromCache('I', c2, uRL, string, false)).exists()) {
            this.deleteEntry(c, c2, uRL, string);
            this.deleteEntry('I', c2, uRL, string);
        }
        return file3;
    }

    public File putMappedImage(URL uRL, String string, File file) throws IOException {
        Object object;
        if (file.getPath().endsWith(".ico") && !((String)(object = uRL.getFile())).endsWith(".ico")) {
            object = (String)object + ".ico";
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), (String)object);
        }
        object = this.putFileInCache('R', 'B', uRL, string, file);
        this.recordLastUpdate();
        return object;
    }

    public String getLaunchFile(char c, URL uRL, String string, String string2) throws IOException {
        byte[] byArray = this.getEntryContent(c, 'M', uRL, string);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, "UTF8");
    }

    private static class DeleteVisitor
    implements DiskCacheVisitor {
        private DiskCache _diskCache;

        DeleteVisitor(DiskCache diskCache) {
            this._diskCache = diskCache;
        }

        public void visitEntry(DiskCacheEntry diskCacheEntry) {
            this._diskCache.removeEntry(diskCacheEntry);
        }
    }

    public static interface DiskCacheVisitor {
        public void visitEntry(DiskCacheEntry var1);
    }

    private static class MuffinAccessVisitor
    implements DiskCacheVisitor {
        private DiskCache _diskCache;
        private URL _theURL;
        private URL[] _urls = new URL[255];
        private int _counter = 0;

        public void visitEntry(DiskCacheEntry diskCacheEntry) {
            URL uRL = diskCacheEntry.getLocation();
            if (uRL == null) {
                return;
            }
            if (uRL.getHost().equals(this._theURL.getHost())) {
                this._urls[this._counter++] = uRL;
            }
        }

        public URL[] getAccessibleMuffins() {
            return this._urls;
        }

        MuffinAccessVisitor(DiskCache diskCache, URL uRL) {
            this._diskCache = diskCache;
            this._theURL = uRL;
        }
    }

    private static class SizeVisitor
    implements DiskCacheVisitor {
        private DiskCache _diskCache;
        long _size = 0L;

        public long getSize() {
            return this._size;
        }

        SizeVisitor(DiskCache diskCache) {
            this._diskCache = diskCache;
            this._size = new File(JavawsHttpsCertStore.getJavawsHttpsFilename()).length();
        }

        public void visitEntry(DiskCacheEntry diskCacheEntry) {
            if (diskCacheEntry.getDirectory() != null && diskCacheEntry.getDirectory().exists()) {
                File[] fileArray = diskCacheEntry.getDirectory().listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this._size += fileArray[i].length();
                }
            } else {
                this._size += diskCacheEntry.getFile().length();
            }
        }
    }
}

