/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.debug.Debug;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;

public class KeyStoreManager {
    private static KeyStore _cacerts = null;
    private static boolean _initialized = false;
    private static final String ksLocation = ConfigProperties.getApplicationHome() + File.separator + "cacerts";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void initialize() throws KeyStoreException {
        block13: {
            FileInputStream fileInputStream = null;
            _cacerts = KeyStore.getInstance("JKS");
            fileInputStream = new FileInputStream(ksLocation);
            _cacerts.load(fileInputStream, null);
            _initialized = true;
            Object var3_1 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block13;
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
            }
            break block13;
            {
                catch (CertificateException certificateException) {
                    throw new KeyStoreException("Error loading keystore");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new KeyStoreException("Error loading keystore");
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                    Object var3_2 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block13;
                    }
                    catch (IOException iOException2) {
                        Debug.ignoredException(iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
                throw throwable;
            }
        }
    }

    static KeyStore getKeyStore() throws KeyStoreException {
        if (_initialized) {
            return _cacerts;
        }
        KeyStoreManager.initialize();
        if (_initialized) {
            return _cacerts;
        }
        return null;
    }

    static boolean isCertificateTrusted(Certificate certificate) {
        if (_cacerts != null) {
            try {
                String string = _cacerts.getCertificateAlias(certificate);
                if (string != null) {
                    return _cacerts.isCertificateEntry(string);
                }
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return false;
    }

    static void saveKeyStore(KeyStore keyStore, String string) throws Exception {
        if (_initialized) {
            FilterOutputStream filterOutputStream = null;
            try {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(new File(ksLocation)));
                keyStore.store(filterOutputStream, string.toCharArray());
                _cacerts = keyStore;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
        }
    }

    static boolean isSigner(Certificate certificate, Certificate certificate2) {
        try {
            certificate.verify(certificate2.getPublicKey());
            return true;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    static Certificate[] makeTrusted(Certificate[] certificateArray) {
        Certificate certificate = certificateArray[certificateArray.length - 1];
        Certificate[] certificateArray2 = certificateArray;
        if (KeyStoreManager.isSigner(certificate, certificate)) {
            if (certificateArray.length == 1 || KeyStoreManager.isCertificateTrusted(certificate)) {
                return certificateArray;
            }
            certificateArray = new Certificate[certificateArray.length - 1];
            System.arraycopy(certificateArray2, 0, certificateArray, 0, certificateArray.length);
            certificate = certificateArray[certificateArray.length - 1];
        }
        try {
            Enumeration<String> enumeration = _cacerts.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Certificate certificate2 = _cacerts.getCertificate(string);
                if (!KeyStoreManager.isSigner(certificate, certificate2)) continue;
                Certificate[] certificateArray3 = new Certificate[certificateArray.length + 1];
                System.arraycopy(certificateArray, 0, certificateArray3, 0, certificateArray.length);
                certificateArray3[certificateArray.length] = certificate2;
                return certificateArray3;
            }
        }
        catch (KeyStoreException keyStoreException) {
            Debug.ignoredException(keyStoreException);
        }
        return certificateArray2;
    }
}

