/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.security.CertificateStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class RootCACertificateStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _cacerts = null;

    static {
        _filename = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.loading" + new Object[]{_filename});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                private final RootCACertificateStore this$0;
                {
                    this.this$0 = rootCACertificateStore;
                }

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (RootCACertificateStore.access$000(this.this$0) == null) {
                        RootCACertificateStore.access$002(this.this$0, KeyStore.getInstance("JKS"));
                        RootCACertificateStore.access$000(this.this$0).load(null, null);
                    }
                    if ((file = new File(RootCACertificateStore.access$100())).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        RootCACertificateStore.access$000(this.this$0).load(bufferedInputStream, null);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    } else if (Globals.TraceHttpsCert) {
                        Debug.println("rootcertstore.cert.noload" + new Object[]{RootCACertificateStore.access$100()});
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            privilegedActionException.printStackTrace();
        }
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.loaded" + new Object[]{_filename});
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.saving" + new Object[]{_filename});
        }
    }

    static String access$100() {
        return _filename;
    }

    public void add(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.adding");
        }
        throw new KeyStoreException("Cannot add root CA certificate");
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.removing");
        }
        throw new KeyStoreException("Cannot remove root CA certificate");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.instore");
        }
        return false;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.canverify");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.tobeverified" + new Object[]{certificate});
        }
        Enumeration<String> enumeration = this._cacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = this._cacerts.getCertificate(string);
            if (Globals.TraceHttpsCert) {
                Debug.println("rootcertstore.cert.tobecompared" + new Object[]{certificate2});
            }
            try {
                certificate.verify(certificate2.getPublicKey());
                if (Globals.TraceHttpsCert) {
                    Debug.println("rootcertstore.cert.verify.ok");
                }
                return true;
            }
            catch (Exception exception) {
            }
        }
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.verify.fail");
        }
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("rootcertstore.cert.iterator");
        }
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._cacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._cacerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }

    static KeyStore access$000(RootCACertificateStore rootCACertificateStore) {
        return rootCACertificateStore._cacerts;
    }

    static KeyStore access$002(RootCACertificateStore rootCACertificateStore, KeyStore keyStore) {
        rootCACertificateStore._cacerts = keyStore;
        return rootCACertificateStore._cacerts;
    }
}

