/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.connector.repra.RepraCustomClient;
import com.sybase.connector.repra.logging.RaLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class GoransDummyRepConnectorClient
implements RepraCustomClient {
    private RaLogger _logger = null;
    private String _propFile = null;
    private Properties _prop = new Properties();
    private boolean _logToStdOut = false;
    private String _fileTemplate = null;
    private String _fileName = null;
    private String _dirName = null;
    private boolean _singleFile = true;

    private String getName() {
        return "GoransDummyRepConnectorClient";
    }

    private void error(String msg) {
        String message = String.valueOf(this.getName()) + ": " + msg;
        if (this._logToStdOut || this._logger == null) {
            System.out.println("ERROR - " + msg);
        } else {
            this._logger.error(message);
        }
    }

    private void error(String msg, Throwable t) {
        String message = String.valueOf(this.getName()) + ": " + msg;
        if (this._logToStdOut || this._logger == null) {
            System.out.println("ERROR - " + msg);
        } else {
            this._logger.error(message, t);
        }
    }

    private void warn(String msg) {
        String message = String.valueOf(this.getName()) + ": " + msg;
        if (this._logToStdOut || this._logger == null) {
            System.out.println("WARN - " + msg);
        } else {
            this._logger.warn(message);
        }
    }

    private void info(String msg) {
        String message = String.valueOf(this.getName()) + ": " + msg;
        if (this._logToStdOut || this._logger == null) {
            System.out.println("INFO - " + msg);
        } else {
            this._logger.info(message);
        }
    }

    private void debug(String msg) {
        String message = String.valueOf(this.getName()) + ": " + msg;
        if (this._logToStdOut || this._logger == null) {
            System.out.println("DEBUG - " + msg);
        } else {
            this._logger.debug(message);
        }
    }

    public void configureClient() throws Exception {
        this.info("Starting '" + this.getName() + "'.");
        String baseDir = "";
        baseDir = System.getProperty("os.name").startsWith("Windows") ? "c:\\" : "/tmp/";
        this._fileTemplate = this._prop.getProperty("destination.file.template", null);
        this._fileName = this._prop.getProperty("destination.file.name", "GoransDummyRepConnectorClient.out");
        this._dirName = this._prop.getProperty("destination.file.dir", baseDir);
        this._singleFile = this._prop.getProperty("destination.file.single", "true").equalsIgnoreCase("true");
        this._logToStdOut = this._prop.getProperty("log.to.stdout", "false").equalsIgnoreCase("true");
        this.info("Properties file used '" + this._propFile + "'.");
        this.info("Configuration: destination.file.template = " + this._fileTemplate);
        this.info("Configuration: destination.file.name     = " + this._fileName);
        this.info("Configuration: destination.file.dir      = " + this._dirName);
        this.info("Configuration: destination.file.single   = " + this._singleFile);
        this.info("Configuration: log.to.stdout             = " + this._logToStdOut);
        File dir = new File(this._dirName);
        if (!dir.isDirectory()) {
            String msg = "The config 'destination.dirName' does NOT exists, or is NOT a directory. Can't continue.";
            this.error(msg);
            throw new Exception(msg);
        }
        if (this._fileTemplate != null) {
            String str = null;
            if (this._fileTemplate.indexOf("${dir}") == -1) {
                str = "Prop 'destination.file.template' must contain '${dir}'.";
            }
            if (this._fileTemplate.indexOf("${name}") == -1) {
                str = "Prop 'destination.file.template' must contain '${name}'.";
            }
            if (this._fileTemplate.indexOf("${ts}") == -1) {
                str = "Prop 'destination.file.template' must contain '${ts}'.";
            }
            if (this._fileTemplate.indexOf("${cnt}") == -1) {
                str = "Prop 'destination.file.template' must contain '${cnt}'.";
            }
            if (str != null) {
                this.error("Problems with 'destination.file.template' property. It must contain all ${dir}, ${name}, ${ts} and ${cnt}. one/all of them is missing.");
                this.error(str);
                throw new Exception(str);
            }
        }
    }

    public boolean sendEvent(Object repmsg) throws Exception {
        String filename = null;
        BufferedWriter writer = null;
        if (this._singleFile) {
            filename = String.valueOf(this._dirName) + File.separator + this._fileName;
            writer = new BufferedWriter(new FileWriter(filename, true));
        } else {
            int c = 0;
            while (c < 100000) {
                if (this._fileTemplate == null) {
                    filename = String.valueOf(this._dirName) + File.separator + this._fileName + "." + System.currentTimeMillis() + "." + c + ".out";
                } else {
                    String nowStr = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS").format(new Date());
                    filename = this._fileTemplate;
                    filename = filename.replace("${dir}", this._dirName);
                    filename = filename.replace("${name}", this._fileName);
                    filename = filename.replace("${ts}", nowStr);
                    filename = filename.replace("${cnt}", Integer.toString(c));
                }
                File f = new File(filename);
                if (!f.exists()) break;
                ++c;
            }
            writer = new BufferedWriter(new FileWriter(filename, false));
        }
        System.out.println(String.valueOf(this.getName()) + ": sendEvent(): Writing message to file '" + filename + "'.");
        this.info("sendEvent(): Writing message to file '" + filename + "'.");
        this.debug("sendEvent(): repmsg.class='" + repmsg.getClass().getName() + "'.");
        this.debug("sendEvent(): repmsg='" + repmsg + "'.");
        String msg = repmsg.toString();
        writer.write(msg);
        writer.flush();
        writer.close();
        return true;
    }

    public boolean isReady() {
        return true;
    }

    public void close() {
        this.debug("close()");
    }

    public void setLogger(RaLogger logger) {
        this._logger = logger;
        this.debug("setLogger(): logger.class='" + logger.getClass().getName() + "'.");
        this.debug("setLogger(): logger='" + logger + "'.");
    }

    public String getConfigProps() {
        return this._propFile;
    }

    public void setConfigProps(String propFile) {
        this.loadPropFile(propFile);
    }

    private void loadPropFile(String propFile) {
        this._propFile = propFile;
        try {
            FileInputStream in = new FileInputStream(propFile);
            this.info("Loading prop file '" + this._propFile + "'.");
            this._prop = new Properties();
            this._prop.load(in);
        }
        catch (IOException e) {
            this._prop = new Properties();
            this.error("Problems reading properties file '" + propFile + "'. Caught: " + e, e);
        }
    }
}

