/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class JmsConsumer
implements ExceptionListener {
    public static void main(String[] args) {
        new JmsConsumer(args);
    }

    public JmsConsumer(String[] args) {
        String queueName = "sampleQueue";
        Properties ctxProps = new Properties();
        ctxProps.put("java.naming.factory.initial", "com.sybase.jms.client.InitialContextFactory");
        ctxProps.put("java.naming.provider.url", "iiop://gorans-xp:2000");
        ctxProps.put("java.naming.security.principal", "admin@system");
        ctxProps.put("java.naming.security.credentials", "1niss2e");
        try {
            InitialContext ctx = new InitialContext(ctxProps);
            ConnectionFactory connFactory = (ConnectionFactory)ctx.lookup("default");
            Connection conn = connFactory.createConnection();
            conn.setExceptionListener((ExceptionListener)this);
            conn.start();
            Session session = conn.createSession(true, 1);
            Destination dest = (Destination)ctx.lookup(queueName);
            MessageConsumer consumer = session.createConsumer(dest);
            conn.start();
            System.out.println("Starting to listen on queue '" + queueName + "'.");
            while (true) {
                Message m;
                if ((m = consumer.receive(0L)) == null) {
                    continue;
                }
                if (!(m instanceof TextMessage)) break;
                TextMessage message = (TextMessage)m;
                System.out.println("Reading message: " + message.getText());
            }
            System.out.println("Stop to listen on queue '" + queueName + "'.");
        }
        catch (Throwable t) {
            System.out.println("Caught " + t.toString());
            System.out.println("\r\nStacktrace:");
            t.printStackTrace();
        }
    }

    public void onException(JMSException exception) {
        System.out.println("ExceptionListener triggered with JMSException.\r\nStacktrace:");
        exception.printStackTrace();
    }
}

