/*
 * Decompiled with CFR 0.152.
 */
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SimpleSynchConsumer {
    public static void main(String[] args) {
        String destName = null;
        InitialContext jndiContext = null;
        ConnectionFactory connectionFactory = null;
        Connection connection = null;
        Session session = null;
        Destination dest = null;
        MessageConsumer consumer = null;
        TextMessage message = null;
        if (args.length != 1) {
            System.out.println("Program takes one argument: <dest_name>");
            System.exit(1);
        }
        destName = new String(args[0]);
        System.out.println("Destination name is " + destName);
        try {
            jndiContext = new InitialContext();
        }
        catch (NamingException e) {
            System.out.println("Could not create JNDI API context: " + e.toString());
            System.exit(1);
        }
        try {
            connectionFactory = (ConnectionFactory)jndiContext.lookup("jms/ConnectionFactory");
            dest = (Destination)jndiContext.lookup(destName);
        }
        catch (Exception e) {
            System.out.println("JNDI API lookup failed: " + e.toString());
            System.exit(1);
        }
        try {
            try {
                connection = connectionFactory.createConnection();
                session = connection.createSession(false, 1);
                consumer = session.createConsumer(dest);
                connection.start();
                while (true) {
                    Message m;
                    if ((m = consumer.receive(1L)) == null) {
                        continue;
                    }
                    if (m instanceof TextMessage) {
                        message = (TextMessage)m;
                        System.out.println("Reading message: " + message.getText());
                        continue;
                    }
                    break;
                }
            }
            catch (JMSException e) {
                System.out.println("Exception occurred: " + e.toString());
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException jMSException) {}
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
    }
}

