/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;

public class ResetAllOperation
extends ClasspathModifierOperation {
    private IClasspathEntry[] fEntries;
    private IPath fOutputLocation;

    public ResetAllOperation(ClasspathModifier.IClasspathModifierListener listener, IClasspathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip, 6);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            this.fInformationProvider.getJavaProject().setRawClasspath(this.fEntries, this.fOutputLocation, monitor);
            this.fInformationProvider.deleteCreatedResources();
            this.fEntries = null;
            this.fOutputLocation = null;
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws JavaModelException {
        IJavaProject project = this.fInformationProvider.getJavaProject();
        if (project == null) {
            return false;
        }
        if (this.fEntries == null) {
            this.fEntries = project.getRawClasspath();
            this.fOutputLocation = project.getOutputLocation();
        }
        if (!project.getOutputLocation().equals((Object)this.fOutputLocation)) {
            return true;
        }
        IClasspathEntry[] currentEntries = project.getRawClasspath();
        if (currentEntries.length != this.fEntries.length) {
            return true;
        }
        int i = 0;
        while (i < this.fEntries.length) {
            if (!this.fEntries[i].equals(currentEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDescription(int type) {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_ResetAll;
    }
}

