/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public final class RenameTypeParameterProcessor
extends JavaRenameProcessor
implements INameUpdating,
IReferenceUpdating {
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameTypeParameterProcessor";
    private Change fChange = null;
    private final ITypeParameter fTypeParameter;
    private boolean fUpdateReferences = true;
    static /* synthetic */ Class class$0;

    public RenameTypeParameterProcessor(ITypeParameter parameter) {
        Assert.isNotNull(parameter);
        this.fTypeParameter = parameter;
        this.setNewElementName(this.fTypeParameter.getElementName());
    }

    public final boolean canEnableUpdateReferences() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status;
        block7: {
            RefactoringStatus refactoringStatus;
            block8: {
                Assert.isNotNull(monitor);
                Assert.isNotNull(context);
                status = new RefactoringStatus();
                try {
                    monitor.beginTask("", 5);
                    monitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_checking);
                    status.merge(Checks.checkIfCuBroken(this.fTypeParameter.getDeclaringMember()));
                    monitor.worked(1);
                    if (status.hasFatalError()) break block7;
                    status.merge(this.checkNewElementName(this.getNewElementName()));
                    monitor.worked(1);
                    monitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_searching);
                    status.merge(this.createRenameChanges((IProgressMonitor)new SubProgressMonitor(monitor, 2)));
                    monitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_checking);
                    if (status.hasFatalError()) {
                        refactoringStatus = status;
                        Object var5_5 = null;
                        break block8;
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    ValidateEditChecker checker = (ValidateEditChecker)context.getChecker((Class)clazz);
                    monitor.worked(1);
                    checker.addFile(ResourceUtil.getFile(this.fTypeParameter.getDeclaringMember().getCompilationUnit()));
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return refactoringStatus;
        }
        Object var5_7 = null;
        monitor.done();
        return status;
    }

    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull(monitor);
        if (!this.fTypeParameter.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_deleted, this.fTypeParameter.getDeclaringMember().getCompilationUnit().getElementName()));
        }
        return Checks.checkIfCuBroken(this.fTypeParameter.getDeclaringMember());
    }

    public final RefactoringStatus checkNewElementName(String name) throws CoreException {
        IMember member;
        Assert.isNotNull(name);
        RefactoringStatus result = Checks.checkTypeParameterName(name);
        if (Checks.startsWithLowerCase(name)) {
            result.addWarning(RefactoringCoreMessages.RenameTypeParameterRefactoring_should_start_lowercase);
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fTypeParameter, name)) {
            result.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_another_name);
        }
        if ((member = this.fTypeParameter.getDeclaringMember()) instanceof IType) {
            IType type = (IType)member;
            if (type.getTypeParameter(name).exists()) {
                result.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_class_type_parameter_already_defined);
            }
        } else if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.getTypeParameter(name).exists()) {
                result.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_method_type_parameter_already_defined);
            }
        } else {
            JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
            Assert.isTrue(false);
        }
        return result;
    }

    public final Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Change change;
        Assert.isNotNull(monitor);
        try {
            change = this.fChange;
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return change;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus createRenameChanges(IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringCoreMessages.RenameTypeParameterRefactoring_searching, 2);
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fTypeParameter.getDeclaringMember().getCompilationUnit());
            IMember member = this.fTypeParameter.getDeclaringMember();
            CompilationUnit root = rewrite.getRoot();
            MethodDeclaration declaration = null;
            if (member instanceof IMethod) {
                declaration = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, root);
            } else if (member instanceof IType) {
                declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)member, root);
            } else {
                JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
                Assert.isTrue(false);
            }
            monitor.worked(1);
            RenameTypeParameterVisitor visitor = new RenameTypeParameterVisitor(rewrite, this.fTypeParameter.getNameRange(), status);
            declaration.accept((ASTVisitor)visitor);
            this.fChange = visitor.getResult();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
        return status;
    }

    protected final String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fTypeParameter);
    }

    public final String getCurrentElementName() {
        return this.fTypeParameter.getElementName();
    }

    public final Object[] getElements() {
        return new Object[]{this.fTypeParameter};
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final Object getNewElement() throws CoreException {
        IMember member = this.fTypeParameter.getDeclaringMember();
        if (member instanceof IType) {
            IType type = (IType)member;
            return type.getTypeParameter(this.getNewElementName());
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            return method.getTypeParameter(this.getNewElementName());
        }
        JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
        Assert.isTrue(false);
        return null;
    }

    public final String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.RenameTypeParameterProcessor_name, new String[]{this.fTypeParameter.getElementName(), this.getNewElementName()});
    }

    public final boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public final boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fTypeParameter);
    }

    protected final void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
    }

    public boolean needsSavedEditors() {
        return false;
    }

    public final void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public final class RenameTypeParameterVisitor
    extends ASTVisitor {
        private final IBinding fBinding;
        private final SimpleName fName;
        private final CompilationUnitRewrite fRewrite;
        private final RefactoringStatus fStatus;

        public RenameTypeParameterVisitor(CompilationUnitRewrite rewrite, ISourceRange range, RefactoringStatus status) {
            super(true);
            Assert.isNotNull(rewrite);
            Assert.isNotNull(range);
            Assert.isNotNull(status);
            this.fRewrite = rewrite;
            this.fName = (SimpleName)NodeFinder.perform((ASTNode)rewrite.getRoot(), range);
            this.fBinding = this.fName.resolveBinding();
            this.fStatus = status;
        }

        public final Change getResult() throws CoreException {
            return this.fRewrite.createChange();
        }

        public final boolean visit(AnnotationTypeDeclaration node) {
            String name = node.getName().getIdentifier();
            if (name.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{name}), JavaStatusContext.create(RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), new SourceRange((ASTNode)node)));
                return false;
            }
            return true;
        }

        public final boolean visit(EnumDeclaration node) {
            String name = node.getName().getIdentifier();
            if (name.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{name}), JavaStatusContext.create(RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), new SourceRange((ASTNode)node)));
                return false;
            }
            return true;
        }

        public final boolean visit(SimpleName node) {
            ITypeBinding binding = node.resolveTypeBinding();
            if (binding != null && binding.isTypeVariable() && Bindings.equals((IBinding)binding, this.fBinding) && node.getIdentifier().equals(this.fName.getIdentifier())) {
                if (node != this.fName) {
                    if (RenameTypeParameterProcessor.this.fUpdateReferences) {
                        this.fRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)RenameTypeParameterProcessor.this.getNewElementName(), this.fRewrite.createGroupDescription(RefactoringCoreMessages.RenameTypeParameterRefactoring_update_type_parameter_reference));
                    }
                } else {
                    this.fRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)RenameTypeParameterProcessor.this.getNewElementName(), this.fRewrite.createGroupDescription(RefactoringCoreMessages.RenameTypeParameterRefactoring_update_type_parameter_declaration));
                }
            }
            return true;
        }

        public final boolean visit(TypeDeclaration node) {
            String name = node.getName().getIdentifier();
            if (name.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{name}), JavaStatusContext.create(RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), new SourceRange((ASTNode)node)));
                return false;
            }
            return true;
        }
    }
}

