/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class EnumeratedTypeSet
extends TypeSet {
    private static int sCount = 0;
    Set fMembers = new LinkedHashSet();
    private static final int sMaxElements = 10;

    public static int getCount() {
        return sCount;
    }

    public static void resetCount() {
        sCount = 0;
    }

    public EnumeratedTypeSet(Iterator types, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        while (types.hasNext()) {
            this.fMembers.add(types.next());
        }
        ++sCount;
    }

    public EnumeratedTypeSet(TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        ++sCount;
    }

    public EnumeratedTypeSet(TType t, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        Assert.isNotNull(t);
        this.fMembers.add(t);
        ++sCount;
    }

    public boolean isUniverse() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EnumeratedTypeSet) {
            EnumeratedTypeSet other = (EnumeratedTypeSet)o;
            return this.fMembers.equals(other.fMembers);
        }
        if (o instanceof SingletonTypeSet) {
            SingletonTypeSet other = (SingletonTypeSet)o;
            return this.fMembers.size() == 1 && this.fMembers.contains(other.anyMember());
        }
        if (o instanceof TypeSet) {
            TypeSet other = (TypeSet)o;
            Iterator otherIter = other.iterator();
            while (otherIter.hasNext()) {
                if (this.fMembers.contains(otherIter.next())) continue;
                return false;
            }
            Iterator myIter = this.fMembers.iterator();
            while (myIter.hasNext()) {
                if (other.contains((TType)myIter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 37 + this.fMembers.hashCode();
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet s2) {
        if (s2 instanceof EnumeratedTypeSet) {
            EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            result.addAll(this);
            result.retainAll(s2);
            if (result.size() > 0) {
                return result;
            }
            return this.getTypeSetEnvironment().getEmptyTypeSet();
        }
        return null;
    }

    public void intersectWith(TypeSet s2) {
        if (this.isUniverse()) {
            if (s2.isUniverse()) {
                return;
            }
            EnumeratedTypeSet ets2 = (EnumeratedTypeSet)s2;
            this.fMembers = new LinkedHashSet();
            this.fMembers.addAll(ets2.fMembers);
        } else {
            this.retainAll(s2);
        }
    }

    public TypeSet subTypes() {
        if (this.isUniverse()) {
            return this.makeClone();
        }
        if (this.fMembers.contains(this.getJavaLangObject())) {
            return this.getTypeSetEnvironment().getUniverseTypeSet();
        }
        return this.getTypeSetEnvironment().createSubTypesSet(this);
    }

    public static EnumeratedTypeSet makeArrayTypesForElements(Iterator elemTypes, TypeSetEnvironment typeSetEnvironment) {
        EnumeratedTypeSet result = new EnumeratedTypeSet(typeSetEnvironment);
        while (elemTypes.hasNext()) {
            TType t = (TType)elemTypes.next();
            result.add(TTypes.createArrayType(t, 1));
        }
        return result;
    }

    public TypeSet superTypes() {
        if (this.isUniverse()) {
            return this.makeClone();
        }
        return this.getTypeSetEnvironment().createSuperTypesSet(this);
    }

    public TypeSet makeClone() {
        EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        result.fMembers.addAll(this.fMembers);
        result.initComplete();
        return result;
    }

    public int size() {
        return this.fMembers.size();
    }

    public void clear() {
        if (this.isUniverse()) {
            this.fMembers = new LinkedHashSet();
        } else {
            this.fMembers.clear();
        }
    }

    public boolean isEmpty() {
        return this.fMembers.isEmpty();
    }

    public TType[] toArray() {
        return this.fMembers.toArray(new TType[this.fMembers.size()]);
    }

    public boolean add(TType t) {
        Assert.isTrue(!this.isUniverse(), "Someone's trying to expand the universe!");
        return this.fMembers.add(t);
    }

    public boolean contains(TType t) {
        if (this.isUniverse()) {
            return true;
        }
        return this.fMembers.contains(t);
    }

    public boolean remove(TType t) {
        if (this.isUniverse()) {
            this.fMembers = this.cloneSet(this.fMembers);
        }
        return this.fMembers.remove(t);
    }

    private Set cloneSet(Set members) {
        LinkedHashSet result = new LinkedHashSet();
        result.addAll(members);
        return result;
    }

    public boolean addAll(TypeSet s) {
        if (s instanceof EnumeratedTypeSet) {
            EnumeratedTypeSet ets = (EnumeratedTypeSet)s;
            return this.fMembers.addAll(ets.fMembers);
        }
        EnumeratedTypeSet ets = s.enumerate();
        return this.fMembers.addAll(ets.fMembers);
    }

    public TypeSet addedTo(TypeSet that) {
        EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        result.addAll(this);
        result.addAll(that);
        result.initComplete();
        return result;
    }

    public boolean containsAll(TypeSet s) {
        if (this.isUniverse()) {
            return true;
        }
        if (s.isUniverse()) {
            return false;
        }
        EnumeratedTypeSet ets = s.enumerate();
        return this.fMembers.containsAll(ets.fMembers);
    }

    public boolean removeAll(EnumeratedTypeSet s) {
        if (this.isUniverse()) {
            this.fMembers = this.cloneSet(this.fMembers);
        }
        return this.fMembers.removeAll(s.fMembers);
    }

    public boolean retainAll(TypeSet s) {
        if (s.isUniverse()) {
            return false;
        }
        EnumeratedTypeSet ets = (EnumeratedTypeSet)s;
        if (this.isUniverse()) {
            this.fMembers = this.cloneSet(ets.fMembers);
            return true;
        }
        return this.fMembers.retainAll(ets.fMembers);
    }

    public boolean isSingleton() {
        return this.fMembers.size() == 1;
    }

    public TType anyMember() {
        return (TType)this.fMembers.iterator().next();
    }

    public TypeSet upperBound() {
        if (this.fMembers.size() == 1) {
            return new SingletonTypeSet((TType)this.fMembers.iterator().next(), this.getTypeSetEnvironment());
        }
        if (this.fMembers.contains(this.getJavaLangObject())) {
            return new SingletonTypeSet(this.getJavaLangObject(), this.getTypeSetEnvironment());
        }
        EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        result.fMembers.addAll(this.fMembers);
        Iterator iter = this.fMembers.iterator();
        while (iter.hasNext()) {
            TType t = (TType)iter.next();
            if (t.isArrayType()) {
                ArrayType at = (ArrayType)t;
                int numDims = at.getDimensions();
                Iterator subIter = TTypes.getAllSubTypesIterator(at.getElementType());
                while (subIter.hasNext()) {
                    result.fMembers.remove(TTypes.createArrayType((TType)subIter.next(), numDims));
                }
                continue;
            }
            Iterator iterator = TTypes.getAllSubTypesIterator(t);
            while (iterator.hasNext()) {
                result.fMembers.remove(iterator.next());
            }
        }
        result.initComplete();
        return result;
    }

    public TypeSet lowerBound() {
        if (this.fMembers.size() == 1) {
            return new SingletonTypeSet((TType)this.fMembers.iterator().next(), this.getTypeSetEnvironment());
        }
        EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        result.fMembers.addAll(this.fMembers);
        Iterator iter = this.fMembers.iterator();
        while (iter.hasNext()) {
            TType t = (TType)iter.next();
            if (t.equals(this.getJavaLangObject())) {
                result.fMembers.remove(t);
                continue;
            }
            if (t instanceof ArrayType) {
                ArrayType at = (ArrayType)t;
                int numDims = at.getDimensions();
                Iterator superIter = TTypes.getAllSuperTypesIterator(at.getElementType());
                while (superIter.hasNext()) {
                    result.fMembers.remove(TTypes.createArrayType((TType)superIter.next(), numDims));
                }
                continue;
            }
            Iterator iterator = TTypes.getAllSuperTypesIterator(t);
            while (iterator.hasNext()) {
                result.fMembers.remove(iterator.next());
            }
        }
        if (result.size() > 0) {
            return result;
        }
        return this.getTypeSetEnvironment().getEmptyTypeSet();
    }

    public boolean hasUniqueLowerBound() {
        return this.fMembers.size() == 1;
    }

    public boolean hasUniqueUpperBound() {
        return this.fMembers.size() == 1;
    }

    public TType uniqueLowerBound() {
        if (this.fMembers.size() == 1) {
            return (TType)this.fMembers.iterator().next();
        }
        return null;
    }

    public TType uniqueUpperBound() {
        if (this.fMembers.size() == 1) {
            return (TType)this.fMembers.iterator().next();
        }
        return null;
    }

    public Iterator iterator() {
        return this.fMembers.iterator();
    }

    public TType[] toArray(TType[] a) {
        return this.fMembers.toArray(a);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{" + this.fID + ":");
        if (this.isUniverse()) {
            b.append(" <universe>");
        } else {
            int count = 0;
            Iterator iter = this.iterator();
            while (iter.hasNext() && count < 10) {
                TType type = (TType)iter.next();
                b.append(' ').append(type.getPrettySignature());
                if (iter.hasNext()) {
                    b.append(',');
                }
                ++count;
            }
            if (iter.hasNext()) {
                b.append(" ...");
            }
        }
        b.append(" }");
        return b.toString();
    }

    public EnumeratedTypeSet enumerate() {
        return this;
    }

    public void initComplete() {
        Assert.isTrue(!this.fMembers.isEmpty());
    }
}

