/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class QualifiedNameFinder {
    public static void process(QualifiedNameSearchResult result, String pattern, String newValue, String filePatterns, IProject root, IProgressMonitor monitor) {
        if (filePatterns == null || filePatterns.length() == 0) {
            monitor.beginTask("", 1);
            monitor.worked(1);
            return;
        }
        Assert.isNotNull(pattern);
        Assert.isNotNull(newValue);
        Assert.isNotNull(root);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ResultCollector collector = new ResultCollector(result, newValue, monitor);
        TextSearchEngine engine = new TextSearchEngine();
        engine.search(QualifiedNameFinder.createScope(filePatterns, root), false, (ITextSearchResultCollector)collector, new MatchLocator(pattern, true, false));
    }

    private static SearchScope createScope(String filePatterns, IProject root) {
        HashSet<IProject> res = new HashSet<IProject>();
        res.add(root);
        QualifiedNameFinder.addReferencingProjects(root, res);
        IResource[] resArr = res.toArray(new IResource[res.size()]);
        SearchScope result = SearchScope.newSearchScope((String)"", (IResource[])resArr);
        QualifiedNameFinder.addFilePatterns(filePatterns, result);
        return result;
    }

    private static void addFilePatterns(String filePatterns, SearchScope scope) {
        StringTokenizer tokenizer = new StringTokenizer(filePatterns, ",");
        while (tokenizer.hasMoreTokens()) {
            scope.addFileNamePattern(tokenizer.nextToken().trim());
        }
    }

    private static void addReferencingProjects(IProject root, Set res) {
        IProject[] projects = root.getReferencingProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (res.add(project)) {
                QualifiedNameFinder.addReferencingProjects(project, res);
            }
            ++i;
        }
    }

    private static class ResultCollector
    implements ITextSearchResultCollector {
        private String fNewValue;
        private IProgressMonitor fProgressMonitor;
        private QualifiedNameSearchResult fResult;

        public ResultCollector(QualifiedNameSearchResult result, String newValue, IProgressMonitor monitor) {
            this.fResult = result;
            this.fNewValue = newValue;
            this.fProgressMonitor = monitor;
        }

        public void aboutToStart() throws CoreException {
        }

        public void accept(IResourceProxy proxy, int start, int length) throws CoreException {
            if (proxy.getType() != 1) {
                return;
            }
            IFile file = (IFile)proxy.requestResource();
            IJavaElement element = JavaCore.create((IFile)file);
            if (element != null && element.exists()) {
                return;
            }
            TextChange change = this.fResult.getChange(file);
            TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.QualifiedNameFinder_update_name, (TextEdit)new ReplaceEdit(start, length, this.fNewValue));
        }

        public void done() throws CoreException {
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }
    }
}

