/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;

public class Strings {
    private Strings() {
    }

    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !Strings.isLineDelimiterChar(ch);
    }

    public static boolean isLowerCase(char ch) {
        return Character.toLowerCase(ch) == ch;
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public static String removeNewLine(String message) {
        StringBuffer result = new StringBuffer();
        int current = 0;
        int index = message.indexOf(10, 0);
        while (index != -1) {
            result.append(message.substring(current, index));
            if (current < index && index != 0) {
                result.append(' ');
            }
            current = index + 1;
            index = message.indexOf(10, current);
        }
        result.append(message.substring(current));
        return result.toString();
    }

    public static String[] convertIntoLines(String input) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(input);
            int size = tracker.getNumberOfLines();
            String[] result = new String[size];
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                result[i] = input.substring(offset, offset + region.getLength());
                ++i;
            }
            return result;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static boolean containsOnlyWhitespaces(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String trimLeadingTabsAndSpaces(String line) {
        int size;
        int start = size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (!Strings.isIndentChar(c)) {
                start = i;
                break;
            }
            ++i;
        }
        if (start == 0) {
            return line;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static String trimTrailingTabsAndSpaces(String line) {
        int size;
        int end = size = line.length();
        int i = size - 1;
        while (i >= 0) {
            char c = line.charAt(i);
            if (!Strings.isIndentChar(c)) break;
            end = i--;
        }
        if (end == size) {
            return line;
        }
        if (end == 0) {
            return "";
        }
        return line.substring(0, end);
    }

    public static int computeIndent(String line, int tabWidth) {
        return Strings.computeIndentUnits(line, tabWidth, tabWidth);
    }

    public static int computeIndentUnits(String line, IJavaProject project) {
        return Strings.computeIndentUnits(line, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project));
    }

    public static int computeIndentUnits(String line, int tabWidth, int indentWidth) {
        if (indentWidth == 0) {
            return -1;
        }
        int visualLength = Strings.measureIndentLength(line, tabWidth);
        return visualLength / indentWidth;
    }

    public static int measureIndentLength(CharSequence line, int tabSize) {
        int length = 0;
        int max = line.length();
        int i = 0;
        while (i < max) {
            char ch = line.charAt(i);
            if (ch == '\t') {
                int reminder = length % tabSize;
                length += tabSize - reminder;
            } else if (Strings.isIndentChar(ch)) {
                ++length;
            } else {
                return length;
            }
            ++i;
        }
        return length;
    }

    public static String trimIndent(String line, int indentsToRemove, int tabWidth) {
        return Strings.trimIndent(line, indentsToRemove, tabWidth, tabWidth);
    }

    public static String trimIndent(String line, int indentsToRemove, IJavaProject project) {
        return Strings.trimIndent(line, indentsToRemove, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project));
    }

    public static String trimIndent(String line, int indentsToRemove, int tabWidth, int indentWidth) {
        if (line == null || indentsToRemove <= 0) {
            return line;
        }
        int spaceEquivalentsToRemove = indentsToRemove * indentWidth;
        int start = 0;
        int spaceEquivalents = 0;
        int size = line.length();
        String prefix = null;
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                int remainder = spaceEquivalents % tabWidth;
                spaceEquivalents += tabWidth - remainder;
            } else if (Strings.isIndentChar(c)) {
                ++spaceEquivalents;
            } else {
                start = i;
                break;
            }
            if (spaceEquivalents == spaceEquivalentsToRemove) {
                start = i + 1;
                break;
            }
            if (spaceEquivalents > spaceEquivalentsToRemove) {
                start = i + 1;
                char[] missing = new char[spaceEquivalents - spaceEquivalentsToRemove];
                Arrays.fill(missing, ' ');
                prefix = new String(missing);
                break;
            }
            ++i;
        }
        String trimmed = start == size ? "" : line.substring(start);
        if (prefix == null) {
            return trimmed;
        }
        return String.valueOf(prefix) + trimmed;
    }

    public static void trimIndentation(String[] lines, int tabWidth) {
        Strings.trimIndentation(lines, tabWidth, tabWidth, true);
    }

    public static void trimIndentation(String[] lines, IJavaProject project) {
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project), true);
    }

    public static void trimIndentation(String[] lines, int tabWidth, int indentWidth) {
        Strings.trimIndentation(lines, tabWidth, indentWidth, true);
    }

    public static void trimIndentation(String[] lines, int tabWidth, boolean considerFirstLine) {
        Strings.trimIndentation(lines, tabWidth, tabWidth, considerFirstLine);
    }

    public static void trimIndentation(String[] lines, IJavaProject project, boolean considerFirstLine) {
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project), considerFirstLine);
    }

    public static void trimIndentation(String[] lines, int tabWidth, int indentWidth, boolean considerFirstLine) {
        String[] toDo = new String[lines.length];
        int minIndent = Integer.MAX_VALUE;
        int i = considerFirstLine ? 0 : 1;
        while (i < lines.length) {
            String line = lines[i];
            if (!Strings.containsOnlyWhitespaces(line)) {
                toDo[i] = line;
                int indent = Strings.computeIndentUnits(line, tabWidth, indentWidth);
                if (indent < minIndent) {
                    minIndent = indent;
                }
            }
            ++i;
        }
        if (minIndent > 0) {
            i = considerFirstLine ? 0 : 1;
            while (i < toDo.length) {
                String line;
                int indent;
                String s = toDo[i];
                lines[i] = s != null ? Strings.trimIndent(s, minIndent, tabWidth, indentWidth) : ((indent = Strings.computeIndentUnits(line = lines[i], tabWidth, indentWidth)) > minIndent ? Strings.trimIndent(line, minIndent, tabWidth, indentWidth) : Strings.trimLeadingTabsAndSpaces(line));
                ++i;
            }
        }
    }

    public static String getIndentString(String line, int tabWidth) {
        return Strings.getIndentString(line, tabWidth, tabWidth);
    }

    public static String getIndentString(String line, IJavaProject project) {
        return Strings.getIndentString(line, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project));
    }

    public static String getIndentString(String line, int tabWidth, int indentWidth) {
        int size = line.length();
        int end = 0;
        int spaceEquivs = 0;
        int characters = 0;
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                int remainder = spaceEquivs % tabWidth;
                spaceEquivs += tabWidth - remainder;
                ++characters;
            } else {
                if (!Strings.isIndentChar(c)) break;
                ++spaceEquivs;
                ++characters;
            }
            if (spaceEquivs >= indentWidth) {
                end += characters;
                characters = 0;
                spaceEquivs %= indentWidth;
            }
            ++i;
        }
        if (end == 0) {
            return "";
        }
        if (end == size) {
            return line;
        }
        return line.substring(0, end);
    }

    public static int computeIndentLength(String line, int numberOfIndents, int tabWidth) {
        return Strings.computeIndentLength(line, numberOfIndents, tabWidth, tabWidth);
    }

    public static int computeIndentLength(String line, int numberOfIndents, IJavaProject project) {
        return Strings.computeIndentLength(line, numberOfIndents, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project));
    }

    public static int computeIndentLength(String line, int numberOfIndents, int tabWidth, int indentWidth) {
        Assert.isTrue(numberOfIndents >= 0);
        Assert.isTrue(tabWidth >= 0);
        Assert.isTrue(indentWidth >= 0);
        int spaceEquivalents = numberOfIndents * indentWidth;
        int size = line.length();
        int result = -1;
        int blanks = 0;
        int i = 0;
        while (i < size && blanks < spaceEquivalents) {
            char c = line.charAt(i);
            if (c == '\t') {
                int remainder = blanks % tabWidth;
                blanks += tabWidth - remainder;
            } else {
                if (!Strings.isIndentChar(c)) break;
                ++blanks;
            }
            result = i++;
        }
        if (blanks < spaceEquivalents) {
            return -1;
        }
        return result + 1;
    }

    public static String[] removeTrailingEmptyLines(String[] sourceLines) {
        int lastNonEmpty = Strings.findLastNonEmptyLineIndex(sourceLines);
        String[] result = new String[lastNonEmpty + 1];
        int i = 0;
        while (i < result.length) {
            result[i] = sourceLines[i];
            ++i;
        }
        return result;
    }

    private static int findLastNonEmptyLineIndex(String[] sourceLines) {
        int i = sourceLines.length - 1;
        while (i >= 0) {
            if (!sourceLines[i].trim().equals("")) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static String changeIndent(String code, int codeIndentLevel, int tabWidth, String newIndent, String lineDelim) {
        return Strings.changeIndent(code, codeIndentLevel, tabWidth, tabWidth, newIndent, lineDelim);
    }

    public static String changeIndent(String code, int codeIndentLevel, IJavaProject project, String newIndent, String lineDelim) {
        return Strings.changeIndent(code, codeIndentLevel, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project), newIndent, lineDelim);
    }

    public static String changeIndent(String code, int codeIndentLevel, int tabWidth, int indentWidth, String newIndent, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < nLines) {
                IRegion region = tracker.getLineInformation(i);
                int start = region.getOffset();
                int end = start + region.getLength();
                String line = code.substring(start, end);
                if (i == 0) {
                    buf.append(line);
                } else {
                    buf.append(lineDelim);
                    buf.append(newIndent);
                    buf.append(Strings.trimIndent(line, codeIndentLevel, tabWidth, indentWidth));
                }
                ++i;
            }
            return buf.toString();
        }
        catch (BadLocationException badLocationException) {
            return code;
        }
    }

    public static String trimIndentation(String source, int tabWidth, boolean considerFirstLine) {
        return Strings.trimIndentation(source, tabWidth, tabWidth, considerFirstLine);
    }

    public static String trimIndentation(String source, IJavaProject project, boolean considerFirstLine) {
        return Strings.trimIndentation(source, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project), considerFirstLine);
    }

    public static String trimIndentation(String source, int tabWidth, int indentWidth, boolean considerFirstLine) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(source);
            int size = tracker.getNumberOfLines();
            if (size == 1) {
                return source;
            }
            String[] lines = new String[size];
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                lines[i] = source.substring(offset, offset + region.getLength());
                ++i;
            }
            Strings.trimIndentation(lines, tabWidth, indentWidth, considerFirstLine);
            StringBuffer result = new StringBuffer();
            int last = size - 1;
            int i2 = 0;
            while (i2 < size) {
                result.append(lines[i2]);
                if (i2 < last) {
                    result.append(tracker.getLineDelimiter(i2));
                }
                ++i2;
            }
            return result.toString();
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue(false, "Can not happend");
            return null;
        }
    }

    public static String concatenate(String[] lines, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(lines[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static boolean equals(String s, char[] c) {
        if (s.length() != c.length) {
            return false;
        }
        int i = c.length;
        while (--i >= 0) {
            if (s.charAt(i) == c[i]) continue;
            return false;
        }
        return true;
    }

    public static String[] splitByToken(String fullString, String splitToken) {
        StringTokenizer tokenizer = new StringTokenizer(fullString, splitToken);
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }
}

