/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.DeferredMethodWrapper;
import org.eclipse.jdt.internal.ui.callhierarchy.TreeRoot;
import org.eclipse.jdt.internal.ui.callhierarchy.TreeTermination;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public class CallHierarchyContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private DeferredTreeContentManager fManager;
    private CallHierarchyViewPart fPart;

    public CallHierarchyContentProvider(CallHierarchyViewPart part) {
        this.fPart = part;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeRoot) {
            TreeRoot dummyRoot = (TreeRoot)parentElement;
            return new Object[]{dummyRoot.getRoot()};
        }
        if (parentElement instanceof MethodWrapper) {
            Object[] children;
            MethodWrapper methodWrapper = (MethodWrapper)((Object)parentElement);
            if (this.shouldStopTraversion(methodWrapper)) {
                return EMPTY_ARRAY;
            }
            if (this.fManager != null && (children = this.fManager.getChildren((Object)new DeferredMethodWrapper(this, methodWrapper))) != null) {
                return children;
            }
            return this.fetchChildren(methodWrapper);
        }
        return EMPTY_ARRAY;
    }

    protected Object[] fetchChildren(MethodWrapper methodWrapper) {
        IWorkbenchWindow context = JavaPlugin.getActiveWorkbenchWindow();
        MethodWrapperRunnable runnable = new MethodWrapperRunnable(methodWrapper);
        try {
            context.run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, CallHierarchyMessages.CallHierarchyContentProvider_searchError_title, CallHierarchyMessages.CallHierarchyContentProvider_searchError_message);
            return EMPTY_ARRAY;
        }
        catch (InterruptedException interruptedException) {
            return new Object[]{TreeTermination.SEARCH_CANCELED};
        }
        return runnable.getCalls();
    }

    private boolean shouldStopTraversion(MethodWrapper methodWrapper) {
        return methodWrapper.getLevel() > CallHierarchyUI.getDefault().getMaxCallDepth() || methodWrapper.isRecursive();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof MethodWrapper) {
            return ((MethodWrapper)((Object)element)).getParent();
        }
        return null;
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        if (element == TreeRoot.EMPTY_ROOT || element == TreeTermination.SEARCH_CANCELED) {
            return false;
        }
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)element);
            if (methodWrapper.getMember().getElementType() != 9) {
                return false;
            }
            return !this.shouldStopTraversion(methodWrapper);
        }
        return element instanceof TreeRoot;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Object root;
        if (oldInput instanceof TreeRoot && (root = ((TreeRoot)oldInput).getRoot()) instanceof MethodWrapper) {
            this.cancelJobs((MethodWrapper)((Object)root));
        }
        if (viewer instanceof AbstractTreeViewer) {
            this.fManager = new DeferredTreeContentManager((ITreeContentProvider)this, (AbstractTreeViewer)viewer, this.fPart.getSite());
        }
    }

    void cancelJobs(MethodWrapper wrapper) {
        if (this.fManager != null && wrapper != null) {
            this.fManager.cancel((Object)wrapper);
            if (this.fPart != null) {
                this.fPart.setCancelEnabled(false);
            }
        }
    }

    public void doneFetching() {
        if (this.fPart != null) {
            this.fPart.setCancelEnabled(false);
        }
    }

    public void startFetching() {
        if (this.fPart != null) {
            this.fPart.setCancelEnabled(true);
        }
    }

    private class MethodWrapperRunnable
    implements IRunnableWithProgress {
        private MethodWrapper fMethodWrapper;
        private MethodWrapper[] fCalls = null;

        MethodWrapperRunnable(MethodWrapper methodWrapper) {
            this.fMethodWrapper = methodWrapper;
        }

        public void run(IProgressMonitor pm) {
            this.fCalls = this.fMethodWrapper.getCalls(pm);
        }

        MethodWrapper[] getCalls() {
            if (this.fCalls != null) {
                return this.fCalls;
            }
            return new MethodWrapper[0];
        }
    }
}

