/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;

public class JavaAnnotationImageProvider
implements IAnnotationImageProvider {
    private static final int NO_IMAGE = 0;
    private static final int GRAY_IMAGE = 1;
    private static final int OVERLAY_IMAGE = 2;
    private static final int QUICKFIX_IMAGE = 3;
    private static final int QUICKFIX_ERROR_IMAGE = 4;
    private static Image fgQuickFixImage;
    private static Image fgQuickFixErrorImage;
    private static ImageRegistry fgImageRegistry;
    private boolean fShowQuickFixIcon = PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.ShowTemporaryProblem");
    private int fCachedImageType;
    private Image fCachedImage;

    public Image getManagedImage(Annotation annotation) {
        if (annotation instanceof IJavaAnnotation) {
            IJavaAnnotation javaAnnotation = (IJavaAnnotation)annotation;
            int imageType = this.getImageType(javaAnnotation);
            return this.getImage(javaAnnotation, imageType, Display.getCurrent());
        }
        return null;
    }

    public String getImageDescriptorId(Annotation annotation) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(String symbolicName) {
        return null;
    }

    private boolean showQuickFix(IJavaAnnotation annotation) {
        return this.fShowQuickFixIcon && annotation.isProblem() && JavaCorrectionProcessor.hasCorrections((Annotation)annotation);
    }

    private Image getQuickFixImage() {
        if (fgQuickFixImage == null) {
            fgQuickFixImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_warning_obj.gif");
        }
        return fgQuickFixImage;
    }

    private Image getQuickFixErrorImage() {
        if (fgQuickFixErrorImage == null) {
            fgQuickFixErrorImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_error_obj.gif");
        }
        return fgQuickFixErrorImage;
    }

    private ImageRegistry getImageRegistry(Display display) {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry(display);
        }
        return fgImageRegistry;
    }

    private int getImageType(IJavaAnnotation annotation) {
        int imageType = 0;
        if (annotation.hasOverlay()) {
            imageType = 2;
        } else if (!annotation.isMarkedDeleted()) {
            if (this.showQuickFix(annotation)) {
                imageType = "org.eclipse.jdt.ui.error".equals(annotation.getType()) ? 4 : 3;
            }
        } else {
            imageType = 1;
        }
        return imageType;
    }

    private Image getImage(IJavaAnnotation annotation, int imageType, Display display) {
        if (this.fCachedImageType == imageType) {
            return this.fCachedImage;
        }
        Image image = null;
        switch (imageType) {
            case 2: {
                IJavaAnnotation overlay = annotation.getOverlay();
                image = this.getManagedImage((Annotation)overlay);
                break;
            }
            case 3: {
                image = this.getQuickFixImage();
                break;
            }
            case 4: {
                image = this.getQuickFixErrorImage();
                break;
            }
            case 1: {
                String key;
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                String annotationType = annotation.getType();
                if ("org.eclipse.jdt.ui.error".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                } else if ("org.eclipse.jdt.ui.warning".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_WARN_TSK");
                } else if ("org.eclipse.jdt.ui.info".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
                if (image == null) break;
                ImageRegistry registry = this.getImageRegistry(display);
                Image grayImage = registry.get(key = Integer.toString(image.hashCode()));
                if (grayImage == null) {
                    grayImage = new Image((Device)display, image, 2);
                    registry.put(key, grayImage);
                }
                image = grayImage;
            }
        }
        this.fCachedImageType = imageType;
        this.fCachedImage = image;
        return this.fCachedImage;
    }
}

