/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

class GotoPackageAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    GotoPackageAction(PackageExplorerPart part) {
        super(PackagesMessages.GotoPackage_action_label);
        this.setDescription(PackagesMessages.GotoPackage_action_description);
        this.fPackageExplorer = part;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.goto_package_action");
    }

    public void run() {
        try {
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            SelectionDialog dialog = this.createAllPackagesDialog(shell);
            dialog.setTitle(this.getDialogTitle());
            dialog.setMessage(PackagesMessages.GotoPackage_dialog_message);
            dialog.open();
            Object[] res = dialog.getResult();
            if (res != null && res.length == 1) {
                this.gotoPackage((IPackageFragment)res[0]);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private SelectionDialog createAllPackagesDialog(Shell shell) throws JavaModelException {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(2112));
        dialog.setIgnoreCase(false);
        dialog.setElements(this.collectPackages());
        return dialog;
    }

    private Object[] collectPackages() throws JavaModelException {
        IWorkspaceRoot wsroot = JavaPlugin.getWorkspace().getRoot();
        IJavaModel model = JavaCore.create((IWorkspaceRoot)wsroot);
        IJavaProject[] projects = model.getJavaProjects();
        HashSet<IPackageFragmentRoot> set = new HashSet<IPackageFragmentRoot>();
        ArrayList allPackages = new ArrayList();
        int i = 0;
        while (i < projects.length) {
            IPackageFragmentRoot[] roots = projects[i].getPackageFragmentRoots();
            int j = 0;
            while (j < roots.length) {
                IPackageFragmentRoot root = roots[j];
                if (!this.isFiltered(root) && !set.contains(root)) {
                    set.add(root);
                    IJavaElement[] packages = root.getChildren();
                    this.appendPackages(allPackages, packages);
                }
                ++j;
            }
            ++i;
        }
        return allPackages.toArray();
    }

    private void appendPackages(List all, IJavaElement[] packages) {
        int i = 0;
        while (i < packages.length) {
            IJavaElement element = packages[i];
            if (!this.isFiltered(element)) {
                all.add(element);
            }
            ++i;
        }
    }

    private void gotoPackage(IPackageFragment p) {
        this.fPackageExplorer.selectReveal((ISelection)new StructuredSelection((Object)p));
        if (!p.equals(this.getSelectedElement())) {
            MessageDialog.openInformation((Shell)this.fPackageExplorer.getSite().getShell(), (String)this.getDialogTitle(), (String)Messages.format(PackagesMessages.PackageExplorer_element_not_present, p.getElementName()));
        }
    }

    private Object getSelectedElement() {
        return ((IStructuredSelection)this.fPackageExplorer.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private String getDialogTitle() {
        return PackagesMessages.GotoPackage_dialog_title;
    }

    private boolean isFiltered(Object element) {
        TreeViewer viewer = this.fPackageExplorer.getViewer();
        ViewerFilter[] filters = viewer.getFilters();
        if (filters != null) {
            int i = 0;
            while (i < filters.length) {
                if (!filters[i].select((Viewer)viewer, viewer.getInput(), element)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

