/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.StringTokenizer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;

public class JavaPreferencesSettings {
    public static CodeGenerationSettings getCodeGenerationSettings(IJavaProject project) {
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.createComments = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.jdt.ui.javadoc", project));
        res.useKeywordThis = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.jdt.ui.keywordthis", project));
        res.overrideAnnotation = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.jdt.ui.overrideannotation", project));
        res.importOrder = JavaPreferencesSettings.getImportOrderPreference(project);
        res.importThreshold = JavaPreferencesSettings.getImportNumberThreshold(project);
        res.importIgnoreLowercase = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.jdt.ui.ignorelowercasenames", project));
        res.tabWidth = CodeFormatterUtil.getTabWidth(project);
        res.indentWidth = CodeFormatterUtil.getIndentWidth(project);
        return res;
    }

    public static CodeGenerationSettings getCodeGenerationSettings() {
        return JavaPreferencesSettings.getCodeGenerationSettings(null);
    }

    public static int getImportNumberThreshold(IJavaProject project) {
        String thresholdStr = PreferenceConstants.getPreference("org.eclipse.jdt.ui.ondemandthreshold", project);
        try {
            int threshold = Integer.parseInt(thresholdStr);
            if (threshold < 0) {
                threshold = Integer.MAX_VALUE;
            }
            return threshold;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public static String[] getImportOrderPreference(IJavaProject project) {
        String str = PreferenceConstants.getPreference("org.eclipse.jdt.ui.importorder", project);
        if (str != null) {
            return JavaPreferencesSettings.unpackList(str, ";");
        }
        return new String[0];
    }

    public static int getImportNumberThreshold(IPreferenceStore prefs) {
        int threshold = prefs.getInt("org.eclipse.jdt.ui.ondemandthreshold");
        if (threshold < 0) {
            threshold = Integer.MAX_VALUE;
        }
        return threshold;
    }

    public static String[] getImportOrderPreference(IPreferenceStore prefs) {
        String str = prefs.getString("org.eclipse.jdt.ui.importorder");
        if (str != null) {
            return JavaPreferencesSettings.unpackList(str, ";");
        }
        return new String[0];
    }

    private static String[] unpackList(String str, String separator) {
        StringTokenizer tok = new StringTokenizer(str, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < nTokens) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }
}

