/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.preferences.SpellingConfigurationBlock;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.spelling.IPreferenceStatusMonitor;
import org.eclipse.ui.texteditor.spelling.ISpellingPreferenceBlock;

public class SpellingPreferenceBlock
implements ISpellingPreferenceBlock {
    private SpellingConfigurationBlock fBlock = new SpellingConfigurationBlock(new NullStatusChangeListener(), null, null);
    private StatusChangeListenerAdapter fStatusMonitor;

    public Control createControl(Composite parent) {
        return this.fBlock.createContents(parent);
    }

    public void initialize(IPreferenceStatusMonitor statusMonitor) {
        this.fStatusMonitor = new StatusChangeListenerAdapter(statusMonitor);
        this.fBlock.fContext = this.fStatusMonitor;
    }

    public boolean canPerformOk() {
        return this.fStatusMonitor == null || this.fStatusMonitor.getStatus() == null || !this.fStatusMonitor.getStatus().matches(4);
    }

    public void performOk() {
        this.fBlock.performOk();
    }

    public void performDefaults() {
        this.fBlock.performDefaults();
    }

    public void performRevert() {
        this.fBlock.performRevert();
    }

    public void dispose() {
        this.fBlock.dispose();
    }

    public void setEnabled(boolean enabled) {
        this.fBlock.setEnabled(enabled);
    }

    private class NullStatusChangeListener
    implements IStatusChangeListener {
        NullStatusChangeListener() {
        }

        public void statusChanged(IStatus status) {
        }
    }

    private class StatusChangeListenerAdapter
    implements IStatusChangeListener {
        private IPreferenceStatusMonitor fMonitor;
        private IStatus fStatus;

        public StatusChangeListenerAdapter(IPreferenceStatusMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void statusChanged(IStatus status) {
            this.fStatus = status;
            this.fMonitor.statusChanged(status);
        }

        public IStatus getStatus() {
            return this.fStatus;
        }
    }
}

