/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class ProfileManager
extends Observable {
    private static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private static final String PROFILE_KEY = "formatter_profile";
    private static final String FORMATTER_SETTINGS_VERSION = "formatter_settings_version";
    public static final String ECLIPSE21_PROFILE = "org.eclipse.jdt.ui.default_profile";
    public static final String ECLIPSE_PROFILE = "org.eclipse.jdt.ui.default.eclipse_profile";
    public static final String JAVA_PROFILE = "org.eclipse.jdt.ui.default.sun_profile";
    public static final String SHARED_PROFILE = "org.eclipse.jdt.ui.default.shared";
    public static final String DEFAULT_PROFILE = "org.eclipse.jdt.ui.default.eclipse_profile";
    private final Map fProfiles = new HashMap();
    private final List fProfilesByName = new ArrayList();
    private Profile fSelected;
    private static final List fUIKeys = Collections.EMPTY_LIST;
    private static final List fCoreKeys = new ArrayList(DefaultCodeFormatterConstants.getJavaConventionsSettings().keySet());
    private static final List fKeys = new ArrayList();

    static {
        fKeys.addAll(fUIKeys);
        fKeys.addAll(fCoreKeys);
        Collections.sort(fKeys);
    }

    public ProfileManager(List profiles, IScopeContext context) {
        Map map;
        Profile profile;
        this.addBuiltinProfiles(this.fProfiles, this.fProfilesByName);
        Iterator iter = profiles.iterator();
        while (iter.hasNext()) {
            CustomProfile profile2 = (CustomProfile)iter.next();
            profile2.setManager(this);
            this.fProfiles.put(profile2.getID(), profile2);
            this.fProfilesByName.add(profile2);
        }
        Collections.sort(this.fProfilesByName);
        InstanceScope instanceScope = new InstanceScope();
        String profileId = instanceScope.getNode("org.eclipse.jdt.ui").get(PROFILE_KEY, null);
        if (profileId == null) {
            String tabSetting;
            profileId = "org.eclipse.jdt.ui.default.eclipse_profile";
            IEclipsePreferences node = instanceScope.getNode("org.eclipse.jdt.core");
            if (node != null && "space".equals(tabSetting = node.get("org.eclipse.jdt.core.formatter.tabulation.char", null))) {
                profileId = JAVA_PROFILE;
            }
        }
        if ((profile = (Profile)this.fProfiles.get(profileId)) == null) {
            profile = (Profile)this.fProfiles.get("org.eclipse.jdt.ui.default.eclipse_profile");
        }
        this.fSelected = profile;
        if (context.getName() == "project" && (map = this.readFromPreferenceStore(context, profile)) != null) {
            Profile matching = null;
            int i = 0;
            while (matching == null && i < this.fProfilesByName.size()) {
                Profile curr = (Profile)this.fProfilesByName.get(i);
                if (curr.hasEqualSettings(map, ProfileManager.getKeys())) {
                    matching = curr;
                }
                ++i;
            }
            if (matching == null) {
                SharedProfile shared = new SharedProfile(map);
                shared.setManager(this);
                this.fProfiles.put(shared.getID(), shared);
                this.fProfilesByName.add(shared);
                matching = shared;
            }
            this.fSelected = matching;
        }
    }

    protected void notifyObservers(int message) {
        this.setChanged();
        this.notifyObservers(new Integer(message));
    }

    public static boolean hasProjectSpecificSettings(IScopeContext context) {
        IEclipsePreferences corePrefs = context.getNode("org.eclipse.jdt.core");
        Iterator keyIter = fCoreKeys.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String val = corePrefs.get(key, null);
            if (val == null) continue;
            return true;
        }
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        Iterator keyIter2 = fUIKeys.iterator();
        while (keyIter2.hasNext()) {
            String key = (String)keyIter2.next();
            String val = uiPrefs.get(key, null);
            if (val == null) continue;
            return true;
        }
        return false;
    }

    public Map readFromPreferenceStore(IScopeContext context, Profile workspaceProfile) {
        String val;
        String key;
        HashMap<String, String> profileOptions = new HashMap<String, String>();
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        IEclipsePreferences corePrefs = context.getNode("org.eclipse.jdt.core");
        int version = uiPrefs.getInt(FORMATTER_SETTINGS_VERSION, 1);
        if (version != 8) {
            HashMap allOptions = new HashMap();
            this.addAll(uiPrefs, allOptions);
            this.addAll(corePrefs, allOptions);
            return ProfileVersioner.updateAndComplete(allOptions, version);
        }
        boolean hasValues = false;
        Iterator keyIter = fCoreKeys.iterator();
        while (keyIter.hasNext()) {
            key = (String)keyIter.next();
            val = corePrefs.get(key, null);
            if (val != null) {
                hasValues = true;
            } else {
                val = workspaceProfile.getSettings().get(key);
            }
            profileOptions.put(key, val);
        }
        keyIter = fUIKeys.iterator();
        while (keyIter.hasNext()) {
            key = (String)keyIter.next();
            val = uiPrefs.get(key, null);
            if (val != null) {
                hasValues = true;
            } else {
                val = workspaceProfile.getSettings().get(key);
            }
            profileOptions.put(key, val);
        }
        if (!hasValues) {
            return null;
        }
        ProfileVersioner.setLatestCompliance(profileOptions);
        return profileOptions;
    }

    private void addAll(IEclipsePreferences uiPrefs, Map allOptions) {
        try {
            String[] keys = uiPrefs.keys();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String val = uiPrefs.get(key, null);
                if (val != null) {
                    allOptions.put(key, val);
                }
                ++i;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private boolean updatePreferences(IEclipsePreferences prefs, List keys, Map profileOptions) {
        boolean hasChanges = false;
        Iterator keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String oldVal = prefs.get(key, null);
            String val = (String)profileOptions.get(key);
            if (val == null) {
                if (oldVal == null) continue;
                prefs.remove(key);
                hasChanges = true;
                continue;
            }
            if (val.equals(oldVal)) continue;
            prefs.put(key, val);
            hasChanges = true;
        }
        return hasChanges;
    }

    private void writeToPreferenceStore(Profile profile, IScopeContext context) {
        Map profileOptions = profile.getSettings();
        IEclipsePreferences corePrefs = context.getNode("org.eclipse.jdt.core");
        boolean hasCoreChanges = this.updatePreferences(corePrefs, fCoreKeys, profileOptions);
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        boolean hasUIChanges = this.updatePreferences(uiPrefs, fUIKeys, profileOptions);
        if (uiPrefs.getInt(FORMATTER_SETTINGS_VERSION, 0) != 8) {
            uiPrefs.putInt(FORMATTER_SETTINGS_VERSION, 8);
            hasUIChanges = true;
        }
        if (context.getName() == "instance") {
            String oldProfile = uiPrefs.get(PROFILE_KEY, null);
            if (!profile.getID().equals(oldProfile)) {
                uiPrefs.put(PROFILE_KEY, profile.getID());
                hasUIChanges = true;
            }
        } else if (context.getName() == "project" && !profile.isSharedProfile()) {
            this.setProjectProfileNameProperty(context, profile.getID());
        }
        if (hasUIChanges) {
            this.flushPreferences(uiPrefs);
        }
        if (hasCoreChanges) {
            this.flushPreferences(corePrefs);
        }
    }

    private void flushPreferences(final IEclipsePreferences prefs) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            JavaPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void addBuiltinProfiles(Map profiles, List profilesByName) {
        BuiltInProfile javaProfile = new BuiltInProfile(JAVA_PROFILE, FormatterMessages.ProfileManager_java_conventions_profile_name, ProfileManager.getJavaSettings(), 1);
        profiles.put(((Profile)javaProfile).getID(), javaProfile);
        profilesByName.add(javaProfile);
        BuiltInProfile eclipseProfile = new BuiltInProfile("org.eclipse.jdt.ui.default.eclipse_profile", FormatterMessages.ProfileManager_eclipse_profile_name, ProfileManager.getEclipseSettings(), 2);
        profiles.put(((Profile)eclipseProfile).getID(), eclipseProfile);
        profilesByName.add(eclipseProfile);
        BuiltInProfile eclipse21Profile = new BuiltInProfile(ECLIPSE21_PROFILE, FormatterMessages.ProfileManager_default_profile_name, ProfileManager.getEclipse21Settings(), 3);
        profiles.put(((Profile)eclipse21Profile).getID(), eclipse21Profile);
        profilesByName.add(eclipse21Profile);
    }

    public static Map getEclipse21Settings() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getEclipseSettings() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getJavaSettings() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getDefaultSettings() {
        return ProfileManager.getEclipseSettings();
    }

    public static List getKeys() {
        return fKeys;
    }

    public List getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        Iterator iter = this.fProfilesByName.iterator();
        while (iter.hasNext()) {
            sortedNames[i++] = ((Profile)iter.next()).getName();
        }
        return sortedNames;
    }

    public Profile getProfile(String ID) {
        return (Profile)this.fProfiles.get(ID);
    }

    public void commitChanges(IScopeContext scopeContext) {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected, scopeContext);
        }
    }

    public void clearAllSettings(IScopeContext context) {
        IEclipsePreferences corePrefs = context.getNode("org.eclipse.jdt.core");
        boolean hasCoreChanges = this.updatePreferences(corePrefs, fCoreKeys, Collections.EMPTY_MAP);
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        boolean hasUIChanges = this.updatePreferences(uiPrefs, fUIKeys, Collections.EMPTY_MAP);
        if (hasUIChanges) {
            this.flushPreferences(uiPrefs);
        }
        if (hasCoreChanges) {
            this.flushPreferences(corePrefs);
        }
        if (context.getName() == "project") {
            this.setProjectProfileNameProperty(context, null);
        }
    }

    private void setProjectProfileNameProperty(IScopeContext context, String id) {
        String projectName = context.getNode("org.eclipse.jdt.ui").parent().name();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            QualifiedName key = new QualifiedName("org.eclipse.jdt.ui", PROFILE_KEY);
            project.setPersistentProperty(key, id);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    public Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(Profile profile) {
        Profile newSelected = (Profile)this.fProfiles.get(profile.getID());
        if (newSelected != null && !newSelected.equals(this.fSelected)) {
            this.fSelected = newSelected;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String name) {
        return this.fProfiles.containsKey(ID_PREFIX + name);
    }

    public void addProfile(CustomProfile profile) {
        profile.setManager(this);
        CustomProfile oldProfile = (CustomProfile)this.fProfiles.get(profile.getID());
        if (oldProfile != null) {
            this.fProfiles.remove(oldProfile.getID());
            this.fProfilesByName.remove(oldProfile);
            oldProfile.setManager(null);
        }
        this.fProfiles.put(profile.getID(), profile);
        this.fProfilesByName.add(profile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = profile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof CustomProfile)) {
            return false;
        }
        Profile removedProfile = this.fSelected;
        int index = this.fProfilesByName.indexOf(removedProfile);
        this.fProfiles.remove(removedProfile.getID());
        this.fProfilesByName.remove(removedProfile);
        ((CustomProfile)removedProfile).setManager(null);
        if (index >= this.fProfilesByName.size()) {
            --index;
        }
        this.fSelected = (Profile)this.fProfilesByName.get(index);
        if (!removedProfile.isSharedProfile()) {
            this.updateProfilesWithName(removedProfile.getID(), null);
        }
        this.notifyObservers(2);
        return true;
    }

    public void profileRenamed(CustomProfile profile, String oldID) {
        this.fProfiles.remove(oldID);
        this.fProfiles.put(profile.getID(), profile);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(oldID, profile);
        }
        Collections.sort(this.fProfilesByName);
        this.notifyObservers(3);
    }

    public void profileReplaced(CustomProfile oldProfile, CustomProfile newProfile) {
        this.fProfiles.remove(oldProfile.getID());
        this.fProfiles.put(newProfile.getID(), newProfile);
        this.fProfilesByName.remove(oldProfile);
        this.fProfilesByName.add(newProfile);
        Collections.sort(this.fProfilesByName);
        if (!oldProfile.isSharedProfile()) {
            this.updateProfilesWithName(oldProfile.getID(), null);
        }
        this.setSelected(newProfile);
        this.notifyObservers(4);
        this.notifyObservers(1);
    }

    public void profileChanged(CustomProfile profile) {
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), profile);
        }
        this.notifyObservers(5);
    }

    private void updateProfilesWithName(String oldName, Profile newProfile) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        QualifiedName key = new QualifiedName("org.eclipse.jdt.ui", PROFILE_KEY);
        int i = 0;
        while (i < projects.length) {
            IProject curr = projects[i];
            if (curr.isAccessible()) {
                try {
                    String profileId = curr.getPersistentProperty(key);
                    if (oldName.equals(profileId)) {
                        if (newProfile == null) {
                            curr.setPersistentProperty(key, null);
                        } else {
                            this.writeToPreferenceStore(newProfile, (IScopeContext)new ProjectScope(curr));
                        }
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        IEclipsePreferences uiPrefs = new InstanceScope().getNode("org.eclipse.jdt.ui");
        if (newProfile != null && oldName.equals(uiPrefs.get(PROFILE_KEY, null))) {
            this.writeToPreferenceStore(newProfile, (IScopeContext)new InstanceScope());
        }
    }

    public static abstract class Profile
    implements Comparable {
        public abstract String getName();

        public abstract Profile rename(String var1);

        public abstract Map getSettings();

        public abstract void setSettings(Map var1);

        public int getVersion() {
            return 8;
        }

        public boolean hasEqualSettings(Map otherMap, List allKeys) {
            Map settings = this.getSettings();
            Iterator iter = allKeys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object other = otherMap.get(key);
                Object curr = settings.get(key);
                if (!(other == null ? curr != null : !other.equals(curr))) continue;
                return false;
            }
            return true;
        }

        public abstract boolean isProfileToSave();

        public abstract String getID();

        public boolean isSharedProfile() {
            return false;
        }
    }

    public static final class BuiltInProfile
    extends Profile {
        private final String fName;
        private final String fID;
        private final Map fSettings;
        private final int fOrder;

        protected BuiltInProfile(String ID, String name, Map settings, int order) {
            this.fName = name;
            this.fID = ID;
            this.fSettings = settings;
            this.fOrder = order;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String name) {
            return this;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map settings) {
        }

        public String getID() {
            return this.fID;
        }

        public final int compareTo(Object o) {
            if (o instanceof BuiltInProfile) {
                return this.fOrder - ((BuiltInProfile)o).fOrder;
            }
            return -1;
        }

        public boolean isProfileToSave() {
            return false;
        }
    }

    public static class CustomProfile
    extends Profile {
        private String fName;
        private Map fSettings;
        protected ProfileManager fManager;
        private int fVersion;

        public CustomProfile(String name, Map settings, int version) {
            this.fName = name;
            this.fSettings = settings;
            this.fVersion = version;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String name) {
            String trimmed = name.trim();
            if (trimmed.equals(this.getName())) {
                return this;
            }
            String oldID = this.getID();
            this.fName = trimmed;
            if (this.fManager != null) {
                this.fManager.profileRenamed(this, oldID);
            }
            return this;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map settings) {
            if (settings == null) {
                throw new IllegalArgumentException();
            }
            this.fSettings = settings;
            if (this.fManager != null) {
                this.fManager.profileChanged(this);
            }
        }

        public String getID() {
            return ProfileManager.ID_PREFIX + this.fName;
        }

        public void setManager(ProfileManager profileManager) {
            this.fManager = profileManager;
        }

        public ProfileManager getManager() {
            return this.fManager;
        }

        public int getVersion() {
            return this.fVersion;
        }

        public void setVersion(int version) {
            this.fVersion = version;
        }

        public int compareTo(Object o) {
            if (o instanceof SharedProfile) {
                return -1;
            }
            if (o instanceof CustomProfile) {
                return this.getName().compareToIgnoreCase(((Profile)o).getName());
            }
            return 1;
        }

        public boolean isProfileToSave() {
            return true;
        }
    }

    public static final class SharedProfile
    extends CustomProfile {
        public SharedProfile(Map options) {
            super(FormatterMessages.ProfileManager_unnamed_profile_name0, options, 8);
        }

        public Profile rename(String name) {
            CustomProfile profile = new CustomProfile(name.trim(), this.getSettings(), this.getVersion());
            if (this.fManager != null) {
                this.fManager.profileReplaced(this, profile);
            }
            return this;
        }

        public String getID() {
            return ProfileManager.SHARED_PROFILE;
        }

        public final int compareTo(Object o) {
            return 1;
        }

        public boolean isProfileToSave() {
            return false;
        }

        public boolean isSharedProfile() {
            return true;
        }
    }
}

