/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIException;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.jdt.ui.formatterprofiles";
    private static final String PREF_FORMATTER_PROFILES_VERSION = "org.eclipse.jdt.ui.formatterprofiles.version";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_VALUE = "value";

    private ProfileStore() {
    }

    public static List readProfiles() throws CoreException {
        List res = ProfileStore.readProfilesFromPreferences(PREF_FORMATTER_PROFILES);
        if (res == null) {
            return ProfileStore.readOldForCompatibility();
        }
        return res;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeProfiles(Collection profiles) throws CoreException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
        try {
            String val;
            ProfileStore.writeProfilesToStream(profiles, stream);
            try {
                val = stream.toString("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                val = stream.toString();
            }
            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
            preferenceStore.setValue(PREF_FORMATTER_PROFILES, val);
            preferenceStore.setValue(PREF_FORMATTER_PROFILES_VERSION, 8);
            JavaPlugin.getDefault().savePluginPreferences();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        stream.close();
    }

    private static List readProfilesFromPreferences(String key) throws CoreException {
        String string = PreferenceConstants.getPreferenceStore().getString(key);
        if (string != null && string.length() > 0) {
            List list;
            byte[] bytes;
            try {
                bytes = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = string.getBytes();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                List res = ProfileStore.readProfilesFromStream(new InputSource(is));
                if (res != null) {
                    int i = 0;
                    while (i < res.size()) {
                        ProfileVersioner.updateAndComplete((ProfileManager.CustomProfile)res.get(i));
                        ++i;
                    }
                }
                list = res;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
            return list;
        }
        return null;
    }

    private static List readOldForCompatibility() {
        File file = JavaPlugin.getDefault().getStateLocation().append("code_formatter_profiles.xml").toFile();
        if (!file.exists()) {
            return null;
        }
        try {
            List list;
            FileReader reader = new FileReader(file);
            try {
                List res = ProfileStore.readProfilesFromStream(new InputSource(reader));
                if (res != null) {
                    int i = 0;
                    while (i < res.size()) {
                        ProfileVersioner.updateAndComplete((ProfileManager.CustomProfile)res.get(i));
                        ++i;
                    }
                    ProfileStore.writeProfiles(res);
                }
                file.delete();
                list = res;
                Object var4_7 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            return list;
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    public static List readProfilesFromFile(File file) throws CoreException {
        try {
            List list;
            FileInputStream reader = new FileInputStream(file);
            try {
                list = ProfileStore.readProfilesFromStream(new InputSource(reader));
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            return list;
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
    }

    private static List readProfilesFromStream(InputSource inputSource) throws CoreException {
        ProfileDefaultHandler handler = new ProfileDefaultHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        return handler.getProfiles();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeProfilesToFile(Collection profiles, File file) throws CoreException {
        try {
            FileOutputStream writer = new FileOutputStream(file);
            try {
                ProfileStore.writeProfilesToStream(profiles, writer);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                try {
                    ((OutputStream)writer).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var3_5 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                ((OutputStream)writer).close();
                return;
            }
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    private static void writeProfilesToStream(Collection profiles, OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(XML_NODE_ROOT);
            rootElement.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(8));
            document.appendChild(rootElement);
            Iterator iter = profiles.iterator();
            while (iter.hasNext()) {
                ProfileManager.Profile profile = (ProfileManager.Profile)iter.next();
                if (!profile.isProfileToSave()) continue;
                Element profileElement = ProfileStore.createProfileElement(profile, document);
                rootElement.appendChild(profileElement);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(stream));
        }
        catch (TransformerException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    private static Element createProfileElement(ProfileManager.Profile profile, Document document) {
        Element element = document.createElement(XML_NODE_PROFILE);
        element.setAttribute(XML_ATTRIBUTE_NAME, profile.getName());
        element.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(profile.getVersion()));
        Iterator keyIter = ProfileManager.getKeys().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String value = (String)profile.getSettings().get(key);
            if (value != null) {
                Element setting = document.createElement(XML_NODE_SETTING);
                setting.setAttribute(XML_ATTRIBUTE_ID, key);
                setting.setAttribute(XML_ATTRIBUTE_VALUE, value);
                element.appendChild(setting);
                continue;
            }
            JavaPlugin.logErrorMessage("ProfileStore: Profile does not contain value for key " + key);
        }
        return element;
    }

    public static void checkCurrentOptionsVersion() {
        InstanceScope instanceofScope = new InstanceScope();
        IEclipsePreferences uiPreferences = instanceofScope.getNode("org.eclipse.jdt.ui");
        int version = uiPreferences.getInt(PREF_FORMATTER_PROFILES_VERSION, 0);
        if (version >= 8) {
            return;
        }
        try {
            ProfileManager manager;
            List profiles = ProfileStore.readProfiles();
            if (profiles == null) {
                profiles = Collections.EMPTY_LIST;
            }
            if ((manager = new ProfileManager(profiles, (IScopeContext)instanceofScope)).getSelected() instanceof ProfileManager.CustomProfile) {
                manager.commitChanges((IScopeContext)instanceofScope);
            }
            uiPreferences.putInt(PREF_FORMATTER_PROFILES_VERSION, 8);
            try {
                IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                int i = 0;
                while (i < javaProjects.length) {
                    ProjectScope scope = new ProjectScope(javaProjects[i].getProject());
                    if (ProfileManager.hasProjectSpecificSettings((IScopeContext)scope)) {
                        manager = new ProfileManager(profiles, (IScopeContext)scope);
                        manager.commitChanges((IScopeContext)scope);
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError(4, message, t));
    }

    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private List fProfiles;
        private int fVersion;
        private String fName;
        private Map fSettings;

        ProfileDefaultHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(ProfileStore.XML_NODE_SETTING)) {
                String key = attributes.getValue(ProfileStore.XML_ATTRIBUTE_ID);
                String value = attributes.getValue(ProfileStore.XML_ATTRIBUTE_VALUE);
                this.fSettings.put(key, value);
            } else if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(ProfileStore.XML_ATTRIBUTE_NAME);
                this.fSettings = new HashMap(200);
            } else if (qName.equals(ProfileStore.XML_NODE_ROOT)) {
                this.fProfiles = new ArrayList();
                try {
                    this.fVersion = Integer.parseInt(attributes.getValue(ProfileStore.XML_ATTRIBUTE_VERSION));
                }
                catch (NumberFormatException ex) {
                    throw new SAXException(ex);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fProfiles.add(new ProfileManager.CustomProfile(this.fName, this.fSettings, this.fVersion));
                this.fName = null;
                this.fSettings = null;
            }
        }

        public List getProfiles() {
            return this.fProfiles;
        }
    }
}

