/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class InlineMethodAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public InlineMethodAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public InlineMethodAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.InlineMethodAction_inline_Method);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.inline_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isInlineMethodAvailable(selection));
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaPlugin.log(e);
            }
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue(RefactoringAvailabilityTester.isInlineMethodAvailable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue(first instanceof IMethod);
            IMethod method = (IMethod)first;
            this.run(method.getNameRange().getOffset(), method.getNameRange().getLength(), method.getCompilationUnit());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.InlineMethodAction_dialog_title, RefactoringMessages.InlineMethodAction_unexpected_exception);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isInlineMethodAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        ICompilationUnit cu = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        if (cu == null) {
            return;
        }
        this.run(selection.getOffset(), selection.getLength(), cu);
    }

    private void run(int offset, int length, ICompilationUnit unit) {
        if (!ActionUtil.isProcessable(this.getShell(), unit)) {
            return;
        }
        try {
            RefactoringExecutionStarter.startInlineMethodRefactoring(unit, new RefactoringASTParser(3).parse(unit, true), offset, length, this.getShell(), true);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.InlineMethodAction_dialog_title, RefactoringMessages.InlineMethodAction_unexpected_exception);
        }
    }

    public boolean tryInlineMethod(ICompilationUnit unit, CompilationUnit node, ITextSelection selection, Shell shell) {
        try {
            if (RefactoringExecutionStarter.startInlineMethodRefactoring(unit, node, selection.getOffset(), selection.getLength(), shell, false)) {
                this.run(selection);
                return true;
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        return false;
    }
}

