/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class JavaSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private JavaSearchQuery fQuery;
    private Map fElementsToParticipants;
    private static final Match[] NO_MATCHES = new Match[0];
    private ISearchResultListener fFilterListener;

    public JavaSearchResult(JavaSearchQuery query) {
        this.fQuery = query;
        this.fElementsToParticipants = new HashMap();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public void setFilterListner(ISearchResultListener listener) {
        this.fFilterListener = listener;
    }

    protected void fireChange(SearchResultEvent e) {
        if (this.fFilterListener != null) {
            this.fFilterListener.searchResultChanged(e);
        }
        super.fireChange(e);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        if (editorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)editorInput;
            HashSet matches = new HashSet();
            this.collectMatches(matches, (IJavaElement)classFileEditorInput.getClassFile());
            return matches.toArray(new Match[matches.size()]);
        }
        return null;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        IJavaElement javaElement = JavaCore.create((IFile)file);
        if (!(javaElement instanceof ICompilationUnit) && !(javaElement instanceof IClassFile)) {
            return NO_MATCHES;
        }
        HashSet matches = new HashSet();
        this.collectMatches(matches, javaElement);
        return matches.toArray(new Match[matches.size()]);
    }

    private void collectMatches(Set matches, IJavaElement element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                IJavaElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.collectMatches(matches, children[i]);
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)element;
            IFile matchFile = null;
            ICompilationUnit cu = (ICompilationUnit)javaElement.getAncestor(5);
            if (cu != null) {
                matchFile = (IFile)cu.getResource();
            } else {
                IClassFile cf = (IClassFile)javaElement.getAncestor(6);
                if (cf != null) {
                    matchFile = (IFile)cf.getResource();
                }
            }
            return matchFile;
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (match.getElement() instanceof IJavaElement) {
            IJavaElement je = (IJavaElement)match.getElement();
            if (editorInput instanceof IFileEditorInput) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)je.getAncestor(3);
                if (root.isArchive()) {
                    return false;
                }
                IFile inputFile = ((IFileEditorInput)editorInput).getFile();
                IResource matchFile = null;
                ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
                if (cu != null) {
                    matchFile = cu.getResource();
                } else {
                    IClassFile cf = (IClassFile)je.getAncestor(6);
                    if (cf != null) {
                        matchFile = cf.getResource();
                    }
                }
                if (matchFile != null) {
                    return inputFile.equals((Object)matchFile);
                }
                return false;
            }
            if (editorInput instanceof IClassFileEditorInput) {
                return ((IClassFileEditorInput)editorInput).getClassFile().equals(je.getAncestor(6));
            }
        } else if (match.getElement() instanceof IFile && editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile().equals(match.getElement());
        }
        return false;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    synchronized IMatchPresentation getSearchParticpant(Object element) {
        return (IMatchPresentation)this.fElementsToParticipants.get(element);
    }

    boolean addMatch(Match match, IMatchPresentation participant) {
        Object element = match.getElement();
        if (this.fElementsToParticipants.get(element) != null) {
            JavaPlugin.log((IStatus)new Status(2, JavaPlugin.getPluginId(), 0, "A second search participant was found for an element", null));
            return false;
        }
        this.fElementsToParticipants.put(element, participant);
        this.addMatch(match);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        JavaSearchResult javaSearchResult = this;
        synchronized (javaSearchResult) {
            this.fElementsToParticipants.clear();
        }
        super.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(Match match) {
        JavaSearchResult javaSearchResult = this;
        synchronized (javaSearchResult) {
            if (this.getMatchCount(match.getElement()) == 1) {
                this.fElementsToParticipants.remove(match.getElement());
            }
        }
        super.removeMatch(match);
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

