/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.contentassist.ISubjectControlContextInformationValidator;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class CompoundContentAssistProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private final Set fProcessors = new LinkedHashSet();

    public CompoundContentAssistProcessor() {
    }

    public CompoundContentAssistProcessor(IContentAssistProcessor processor) {
        this.add(processor);
    }

    public void add(IContentAssistProcessor processor) {
        Assert.isNotNull((Object)processor);
        this.fProcessors.add(processor);
    }

    public void remove(IContentAssistProcessor processor) {
        this.fProcessors.remove(processor);
    }

    public CompoundContentAssistProcessor(IContentAssistProcessor[] processors) {
        int i = 0;
        while (i < processors.length) {
            this.add(processors[i]);
            ++i;
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        LinkedList<ICompletionProposal> ret = new LinkedList<ICompletionProposal>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            ICompletionProposal[] proposals = p.computeCompletionProposals(viewer, documentOffset);
            if (proposals == null) continue;
            ret.addAll(Arrays.asList(proposals));
        }
        return ret.toArray(new ICompletionProposal[ret.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        LinkedList<WrappedContextInformation> ret = new LinkedList<WrappedContextInformation>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            IContextInformation[] informations = p.computeContextInformation(viewer, documentOffset);
            if (informations == null) continue;
            int i = 0;
            while (i < informations.length) {
                ret.add(new WrappedContextInformation(informations[i], p));
                ++i;
            }
        }
        return ret.toArray(new IContextInformation[ret.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        LinkedHashSet<Character> ret = new LinkedHashSet<Character>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            char[] chars = p.getCompletionProposalAutoActivationCharacters();
            if (chars == null) continue;
            int i = 0;
            while (i < chars.length) {
                ret.add(new Character(chars[i]));
                ++i;
            }
        }
        char[] chars = new char[ret.size()];
        int i = 0;
        Iterator it2 = ret.iterator();
        while (it2.hasNext()) {
            Character ch = (Character)it2.next();
            chars[i] = ch.charValue();
            ++i;
        }
        return chars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        LinkedHashSet<Character> ret = new LinkedHashSet<Character>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            char[] chars = p.getContextInformationAutoActivationCharacters();
            if (chars == null) continue;
            int i = 0;
            while (i < chars.length) {
                ret.add(new Character(chars[i]));
                ++i;
            }
        }
        char[] chars = new char[ret.size()];
        int i = 0;
        Iterator it2 = ret.iterator();
        while (it2.hasNext()) {
            Character ch = (Character)it2.next();
            chars[i] = ch.charValue();
            ++i;
        }
        return chars;
    }

    public String getErrorMessage() {
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            String err = p.getErrorMessage();
            if (err == null) continue;
            return err;
        }
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        boolean hasValidator = false;
        boolean hasExtension = false;
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            IContentAssistProcessor p = (IContentAssistProcessor)it.next();
            IContextInformationValidator v = p.getContextInformationValidator();
            if (v instanceof ISubjectControlContextInformationValidator) {
                hasExtension = true;
                break;
            }
            if (v == null) continue;
            hasValidator = true;
        }
        CompoundContentAssistValidator validator = null;
        if (hasExtension) {
            validator = new CompoundContentAssistValidatorEx();
        } else if (hasValidator) {
            validator = new CompoundContentAssistValidator();
        }
        if (validator != null) {
            Iterator it2 = this.fProcessors.iterator();
            while (it2.hasNext()) {
                IContentAssistProcessor p = (IContentAssistProcessor)it2.next();
                IContextInformationValidator v = p.getContextInformationValidator();
                if (v == null) continue;
                validator.add(v);
            }
        }
        return validator;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        LinkedList<ICompletionProposal> ret = new LinkedList<ICompletionProposal>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            ISubjectControlContentAssistProcessor p;
            ICompletionProposal[] proposals;
            Object o = it.next();
            if (!(o instanceof ISubjectControlContentAssistProcessor) || (proposals = (p = (ISubjectControlContentAssistProcessor)o).computeCompletionProposals(contentAssistSubjectControl, documentOffset)) == null) continue;
            ret.addAll(Arrays.asList(proposals));
        }
        return ret.toArray(new ICompletionProposal[ret.size()]);
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        LinkedList<WrappedContextInformation> ret = new LinkedList<WrappedContextInformation>();
        Iterator it = this.fProcessors.iterator();
        while (it.hasNext()) {
            ISubjectControlContentAssistProcessor p;
            IContextInformation[] informations;
            Object o = it.next();
            if (!(o instanceof ISubjectControlContentAssistProcessor) || (informations = (p = (ISubjectControlContentAssistProcessor)o).computeContextInformation(contentAssistSubjectControl, documentOffset)) == null) continue;
            int i = 0;
            while (i < informations.length) {
                ret.add(new WrappedContextInformation(informations[i], (IContentAssistProcessor)p));
                ++i;
            }
        }
        return ret.toArray(new IContextInformation[ret.size()]);
    }

    private static class WrappedContextInformation
    implements IContextInformation {
        private IContextInformation fInfo;
        private IContentAssistProcessor fProcessor;

        WrappedContextInformation(IContextInformation info, IContentAssistProcessor processor) {
            this.fInfo = info;
            this.fProcessor = processor;
        }

        public boolean equals(Object obj) {
            return this.fInfo.equals(obj);
        }

        public String getContextDisplayString() {
            return this.fInfo.getContextDisplayString();
        }

        public Image getImage() {
            return this.fInfo.getImage();
        }

        public String getInformationDisplayString() {
            return this.fInfo.getInformationDisplayString();
        }

        public int hashCode() {
            return this.fInfo.hashCode();
        }

        public String toString() {
            return this.fInfo.toString();
        }

        IContentAssistProcessor getProcessor() {
            return this.fProcessor;
        }
    }

    private static class CompoundContentAssistValidator
    implements IContextInformationValidator {
        private List fValidators = new ArrayList();

        CompoundContentAssistValidator() {
        }

        void add(IContextInformationValidator validator) {
            this.fValidators.add(validator);
        }

        public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
            IContextInformationValidator validator = this.getValidator(info);
            if (validator != null) {
                validator.install(info, viewer, documentPosition);
            }
        }

        IContextInformationValidator getValidator(IContextInformation info) {
            if (info instanceof WrappedContextInformation) {
                WrappedContextInformation wrap = (WrappedContextInformation)info;
                return wrap.getProcessor().getContextInformationValidator();
            }
            return null;
        }

        public boolean isContextInformationValid(int documentPosition) {
            boolean isValid = false;
            Iterator it = this.fValidators.iterator();
            while (it.hasNext()) {
                IContextInformationValidator v = (IContextInformationValidator)it.next();
                isValid |= v.isContextInformationValid(documentPosition);
            }
            return isValid;
        }
    }

    private static class CompoundContentAssistValidatorEx
    extends CompoundContentAssistValidator
    implements ISubjectControlContextInformationValidator {
        CompoundContentAssistValidatorEx() {
        }

        public void install(IContextInformation info, IContentAssistSubjectControl contentAssistSubjectControl, int documentPosition) {
            IContextInformationValidator validator = this.getValidator(info);
            if (validator instanceof ISubjectControlContextInformationValidator) {
                ((ISubjectControlContextInformationValidator)validator).install(info, contentAssistSubjectControl, documentPosition);
            }
        }
    }
}

