/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;

public class AssistContext
implements IInvocationContext {
    private ICompilationUnit fCompilationUnit;
    private int fOffset;
    private int fLength;
    private CompilationUnit fASTRoot;

    public AssistContext(ICompilationUnit cu, int offset, int length) {
        this.fCompilationUnit = cu;
        this.fOffset = offset;
        this.fLength = length;
        this.fASTRoot = null;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public int getSelectionLength() {
        return this.fLength;
    }

    public int getSelectionOffset() {
        return this.fOffset;
    }

    public CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCompilationUnit, ASTProvider.WAIT_YES, null);
            if (this.fASTRoot == null) {
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(this.fCompilationUnit);
                parser.setResolveBindings(true);
                this.fASTRoot = (CompilationUnit)parser.createAST(null);
            }
        }
        return this.fASTRoot;
    }

    public void setASTRoot(CompilationUnit root) {
        this.fASTRoot = root;
    }

    public ASTNode getCoveringNode() {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        this.getASTRoot().accept((ASTVisitor)finder);
        return finder.getCoveringNode();
    }

    public ASTNode getCoveredNode() {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        this.getASTRoot().accept((ASTVisitor)finder);
        return finder.getCoveredNode();
    }
}

