/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.JavaTokenComparator;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class CUCorrectionProposal
extends ChangeCorrectionProposal {
    private ICompilationUnit fCompilationUnit;
    private ImportRewrite fImportRewrite;
    private boolean fIsInitialized;
    private final int surroundLines = 1;

    public CUCorrectionProposal(String name, ICompilationUnit cu, int relevance, Image image) {
        this(name, cu, CUCorrectionProposal.createTextChange(name, cu), relevance, image);
    }

    public CUCorrectionProposal(String name, ICompilationUnit cu, TextChange change, int relevance, Image image) {
        super(name, (Change)change, relevance, image);
        this.fCompilationUnit = cu;
        this.fImportRewrite = null;
        this.fIsInitialized = false;
    }

    private static TextChange createTextChange(String name, ICompilationUnit cu) {
        if (!cu.getResource().exists()) {
            DocumentChange change = null;
            String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
            try {
                Document document = new Document(cu.getSource());
                document.setInitialLineDelimiter(lineDelimiter);
                change = new DocumentChange(name, (IDocument)document);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                Document document = new Document("");
                document.setInitialLineDelimiter(lineDelimiter);
                change = new DocumentChange(name, (IDocument)document);
            }
            change.setEdit((TextEdit)new MultiTextEdit());
            return change;
        }
        CompilationUnitChange change = new CompilationUnitChange(name, cu);
        change.setEdit((TextEdit)new MultiTextEdit());
        change.setSaveMode(4);
        return change;
    }

    protected void initializeTextChange() throws CoreException {
        if (this.fIsInitialized) {
            return;
        }
        this.fIsInitialized = true;
        TextChange textChange = this.getTextChange();
        TextEdit rootEdit = textChange.getEdit();
        if (rootEdit != null) {
            IDocument document = textChange.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
            this.addEdits(document, rootEdit);
            if (this.fImportRewrite != null && !this.fImportRewrite.isEmpty()) {
                rootEdit.addChild(this.fImportRewrite.createEdit(document, (IProgressMonitor)new NullProgressMonitor()));
            }
        }
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
    }

    public ImportRewrite getImportRewrite() throws CoreException {
        if (this.fImportRewrite == null) {
            this.fImportRewrite = new ImportRewrite(this.getCompilationUnit());
        }
        return this.fImportRewrite;
    }

    public void setImportRewrite(ImportRewrite rewrite) {
        this.fImportRewrite = rewrite;
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        try {
            this.initializeTextChange();
            TextChange change = this.getTextChange();
            IDocument previewContent = change.getPreviewDocument((IProgressMonitor)new NullProgressMonitor());
            String currentConentString = change.getCurrentContent((IProgressMonitor)new NullProgressMonitor());
            JavaTokenComparator leftSide = new JavaTokenComparator(previewContent.get(), true);
            JavaTokenComparator rightSide = new JavaTokenComparator(currentConentString, true);
            RangeDifference[] differences = RangeDifferencer.findRanges((IRangeComparator)((IRangeComparator)leftSide), (IRangeComparator)((IRangeComparator)rightSide));
            int i = 0;
            while (i < differences.length) {
                RangeDifference curr = differences[i];
                int start = leftSide.getTokenStart(curr.leftStart());
                int end = leftSide.getTokenStart(curr.leftEnd());
                if (curr.kind() == 2 && curr.leftLength() > 0) {
                    buf.append("<b>");
                    this.appendContent(previewContent, start, end, buf, false);
                    buf.append("</b>");
                } else if (curr.kind() == 0) {
                    this.appendContent(previewContent, start, end, buf, true);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        return buf.toString();
    }

    private void appendContent(IDocument text, int startOffset, int endOffset, StringBuffer buf, boolean surroundLinesOnly) throws BadLocationException {
        int startLine = text.getLineOfOffset(startOffset);
        int endLine = text.getLineOfOffset(endOffset);
        boolean dotsAdded = false;
        if (surroundLinesOnly && startOffset == 0) {
            startLine = Math.max(endLine - 1, 0);
            buf.append("...<br>");
            dotsAdded = true;
        }
        int i = startLine;
        while (i <= endLine) {
            if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                if (!dotsAdded) {
                    buf.append("...<br>");
                    dotsAdded = true;
                } else if (endOffset == text.getLength()) {
                    return;
                }
            } else {
                IRegion lineInfo = text.getLineInformation(i);
                int start = lineInfo.getOffset();
                int end = start + lineInfo.getLength();
                int from = Math.max(start, startOffset);
                int to = Math.min(end, endOffset);
                String content = text.get(from, to - from);
                if (!surroundLinesOnly || from != start || !Strings.containsOnlyWhitespaces(content)) {
                    int k = 0;
                    while (k < content.length()) {
                        char ch = content.charAt(k);
                        if (ch == '<') {
                            buf.append("&lt;");
                        } else if (ch == '>') {
                            buf.append("&gt;");
                        } else {
                            buf.append(ch);
                        }
                        ++k;
                    }
                    if (to == end && to != endOffset) {
                        buf.append("<br>");
                    }
                }
            }
            ++i;
        }
    }

    protected void performChange(IEditorPart activeEditor, IDocument document) throws CoreException {
        this.initializeTextChange();
        super.performChange(activeEditor, document);
    }

    public void apply(IDocument document) {
        try {
            ICompilationUnit unit = this.getCompilationUnit();
            IEditorPart part = null;
            if (unit.getResource().exists()) {
                IWorkbenchPage page;
                boolean canEdit = this.performValidateEdit(unit);
                if (!canEdit) {
                    return;
                }
                part = EditorUtility.isOpenInEditor(unit);
                if (part == null && (part = EditorUtility.openInEditor(unit, true)) != null) {
                    document = JavaUI.getDocumentProvider().getDocument((Object)part.getEditorInput());
                }
                if ((page = JavaPlugin.getActivePage()) != null && part != null) {
                    page.bringToTop((IWorkbenchPart)part);
                }
                if (part != null) {
                    part.setFocus();
                }
            }
            this.performChange(part, document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, CorrectionMessages.CUCorrectionProposal_error_title, CorrectionMessages.CUCorrectionProposal_error_message);
        }
    }

    private boolean performValidateEdit(ICompilationUnit unit) {
        IStatus status = Resources.makeCommittable(unit.getResource(), (Object)JavaPlugin.getActiveWorkbenchShell());
        if (!status.isOK()) {
            String label = CorrectionMessages.CUCorrectionProposal_error_title;
            String message = CorrectionMessages.CUCorrectionProposal_error_message;
            ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)label, (String)message, (IStatus)status);
            return false;
        }
        return true;
    }

    public TextChange getTextChange() {
        return (TextChange)this.getChange();
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getPreviewContent() throws CoreException {
        this.initializeTextChange();
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }
}

