/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class ConvertForLoopProposal
extends LinkedCorrectionProposal {
    private ForStatement fOldForStatement;
    private EnhancedForStatement fEnhancedForStatement;
    private AST fAst;
    private Name fCollectionName;
    private SingleVariableDeclaration fParameterDeclaration;
    private ITypeBinding fOldCollectionTypeBinding;
    private IBinding fOldCollectionBinding;
    private IBinding fIndexBinding;
    private boolean fCollectionIsMethodCall = false;
    private MethodInvocation fMethodInvocation;
    private static final String ELEMENT_KEY_REFERENCE = "element";
    static /* synthetic */ Class class$0;

    public ConvertForLoopProposal(String name, ICompilationUnit cu, ForStatement forStatement, int relevance, Image image) {
        super(name, cu, (ASTRewrite)null, relevance, image);
        this.fOldForStatement = forStatement;
        this.fAst = this.fOldForStatement.getAST();
    }

    public boolean satisfiesPreconditions() {
        return JavaModelUtil.is50OrHigher(this.getCompilationUnit().getJavaProject()) && this.arrayCanBeInferred() && this.typeBindingsAreNotNull() && this.bodySatifiesPreconditions() && this.initializersSatisfyPreconditions() && this.updatersSatifyPreconditions();
    }

    private boolean typeBindingsAreNotNull() {
        this.fIndexBinding = this.getIndexBinding();
        return this.fOldCollectionBinding != null && this.fOldCollectionTypeBinding != null && this.fIndexBinding != null;
    }

    private boolean bodySatifiesPreconditions() {
        final ArrayList writeAccesses = new ArrayList();
        final boolean[] isIndexReferenced = new boolean[1];
        this.fOldForStatement.getBody().accept(new ASTVisitor(){

            public boolean visit(Assignment assignment) {
                this.classifyWriteAccess(assignment.getLeftHandSide());
                return true;
            }

            public boolean visit(PostfixExpression node) {
                this.classifyWriteAccess(node.getOperand());
                return true;
            }

            public boolean visit(PrefixExpression node) {
                this.classifyWriteAccess(node.getOperand());
                return true;
            }

            public boolean visit(SimpleName name) {
                IBinding binding = name.resolveBinding();
                if (Bindings.equals(ConvertForLoopProposal.this.fIndexBinding, binding)) {
                    ASTNode parent = name.getParent();
                    isIndexReferenced[0] = parent instanceof ArrayAccess ? isIndexReferenced[0] || ConvertForLoopProposal.this.isAccessToADifferentArray((ArrayAccess)parent) : true;
                }
                return false;
            }

            private void classifyWriteAccess(Expression expression) {
                if (expression instanceof ArrayAccess) {
                    ConvertForLoopProposal.this.checkThatArrayIsNotAssigned(writeAccesses, expression);
                } else if (expression instanceof Name) {
                    ConvertForLoopProposal.this.checkThatIndexIsNotAssigned(writeAccesses, expression);
                }
            }
        });
        return writeAccesses.isEmpty() && !isIndexReferenced[0];
    }

    private void checkThatIndexIsNotAssigned(List writeAccesses, Expression expression) {
        Name name = (Name)expression;
        IBinding binding = name.resolveBinding();
        if (binding == this.fIndexBinding) {
            writeAccesses.add(name);
        }
    }

    private void checkThatArrayIsNotAssigned(List writeAccesses, Expression expression) {
        Name arrayName;
        IBinding binding;
        ArrayAccess arrayAccess = (ArrayAccess)expression;
        if (arrayAccess.getArray() instanceof Name && (binding = (arrayName = (Name)arrayAccess.getArray()).resolveBinding()) == this.fOldCollectionBinding) {
            writeAccesses.add(arrayAccess);
        }
    }

    private boolean isAccessToADifferentArray(ArrayAccess arrayAccess) {
        Expression expression = arrayAccess.getArray();
        if (expression instanceof Name) {
            return this.isNameDifferentThanInferredArray((Name)expression);
        }
        if (expression instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)expression;
            return this.isNameDifferentThanInferredArray((Name)fieldAccess.getName());
        }
        if (expression instanceof MethodInvocation) {
            MethodInvocation methodCall = (MethodInvocation)expression;
            return this.isNameDifferentThanInferredArray((Name)methodCall.getName());
        }
        return true;
    }

    private boolean isNameDifferentThanInferredArray(Name name) {
        IBinding arrayBinding = name.resolveBinding();
        return !Bindings.equals(this.fOldCollectionBinding, arrayBinding);
    }

    private boolean updatersSatifyPreconditions() {
        return this.indexNotDecremented() && this.onlyOneIndexUsed();
    }

    private boolean indexNotDecremented() {
        ASTNode updater = (ASTNode)this.fOldForStatement.updaters().get(0);
        if (updater instanceof PostfixExpression && "++".equals(((PostfixExpression)updater).getOperator().toString())) {
            return true;
        }
        return updater instanceof PrefixExpression && "++".equals(((PrefixExpression)updater).getOperator().toString());
    }

    private boolean initializersSatisfyPreconditions() {
        final ArrayList tempVarsInInitializers = new ArrayList();
        final boolean[] startsFromZero = new boolean[1];
        List initializers = this.fOldForStatement.initializers();
        Iterator iter = initializers.iterator();
        while (iter.hasNext()) {
            Expression element = (Expression)iter.next();
            element.accept(new ASTVisitor(){

                public boolean visit(VariableDeclarationFragment declarationFragment) {
                    SimpleName indexName = declarationFragment.getName();
                    tempVarsInInitializers.add(indexName);
                    startsFromZero[0] = ConvertForLoopProposal.this.doesIndexStartFromZero((Name)indexName, (ASTNode)declarationFragment);
                    return false;
                }

                public boolean visit(Assignment assignment) {
                    if (assignment.getLeftHandSide() instanceof Name) {
                        Name indexName = (Name)assignment.getLeftHandSide();
                        tempVarsInInitializers.add(indexName);
                        startsFromZero[0] = ConvertForLoopProposal.this.doesIndexStartFromZero(indexName, (ASTNode)assignment);
                    }
                    return false;
                }
            });
        }
        this.removeInferredIndexFrom(tempVarsInInitializers);
        return startsFromZero[0] && this.additionalTempsNotReferenced(tempVarsInInitializers);
    }

    private boolean doesIndexStartFromZero(Name indexName, ASTNode declaringNode) {
        IBinding binding = indexName.resolveBinding();
        if (Bindings.equals(this.fIndexBinding, binding)) {
            NumberLiteral number;
            Expression initializer = null;
            if (declaringNode instanceof VariableDeclarationFragment) {
                initializer = ((VariableDeclarationFragment)declaringNode).getInitializer();
            } else if (declaringNode instanceof Assignment) {
                initializer = ((Assignment)declaringNode).getRightHandSide();
            }
            if (initializer instanceof NumberLiteral && !"0".equals((number = (NumberLiteral)initializer).getToken())) {
                return false;
            }
        }
        return true;
    }

    private void removeInferredIndexFrom(List localTemps) {
        Name indexName = null;
        Iterator iter = localTemps.iterator();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            IBinding binding = name.resolveBinding();
            if (!Bindings.equals(this.fIndexBinding, binding)) continue;
            indexName = name;
            break;
        }
        localTemps.remove(indexName);
    }

    private boolean additionalTempsNotReferenced(List localTemps) {
        Iterator iter = localTemps.iterator();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            LocalOccurencesFinder finder = new LocalOccurencesFinder(name, (ASTNode)this.fOldForStatement.getBody());
            finder.perform();
            if (finder.getOccurences().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean onlyOneIndexUsed() {
        return this.fOldForStatement.updaters().size() == 1;
    }

    private boolean arrayCanBeInferred() {
        this.doInferCollection();
        return this.fCollectionName != null && this.fOldCollectionTypeBinding != null && this.fOldCollectionTypeBinding.isArray();
    }

    private IBinding inferIndexBinding() {
        Assignment assignment;
        Expression lhs;
        List initializers = this.fOldForStatement.initializers();
        Expression expression = (Expression)initializers.get(0);
        if (expression instanceof VariableDeclarationExpression) {
            VariableDeclarationFragment declaration = (VariableDeclarationFragment)((VariableDeclarationExpression)expression).fragments().get(0);
            SimpleName indexName = declaration.getName();
            this.fIndexBinding = indexName.resolveBinding();
        } else if (expression instanceof Assignment && (lhs = (assignment = (Assignment)expression).getLeftHandSide()) instanceof Name) {
            Name indexName = (Name)lhs;
            this.fIndexBinding = indexName.resolveBinding();
        }
        return this.fIndexBinding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTRewrite rewrite = ASTRewrite.create((AST)this.fAst);
        this.doConvert(rewrite);
        return rewrite;
    }

    private void doConvert(ASTRewrite rewrite) throws CoreException {
        this.doInferCollection();
        this.doInferElement();
        this.doFindAndReplaceInBody(rewrite);
        AST ast = this.fOldForStatement.getAST();
        this.fEnhancedForStatement = ast.newEnhancedForStatement();
        ASTNode theBody = rewrite.createMoveTarget((ASTNode)this.fOldForStatement.getBody());
        this.fEnhancedForStatement.setBody((Statement)theBody);
        this.fEnhancedForStatement.setExpression(this.createExpression(rewrite));
        this.fEnhancedForStatement.setParameter(this.fParameterDeclaration);
        this.addLinkedPosition(rewrite.track((ASTNode)this.fParameterDeclaration.getName()), true, ELEMENT_KEY_REFERENCE);
        String name = this.fParameterDeclaration.getName().getIdentifier();
        List proposals = this.getProposalsForElement();
        if (!proposals.contains(name)) {
            proposals.add(0, name);
        }
        Iterator iterator = proposals.iterator();
        while (iterator.hasNext()) {
            this.addLinkedPositionProposal(ELEMENT_KEY_REFERENCE, (String)iterator.next(), null);
        }
        rewrite.replace((ASTNode)this.fOldForStatement, (ASTNode)this.fEnhancedForStatement, null);
    }

    private Expression createExpression(ASTRewrite rewrite) {
        if (this.fCollectionIsMethodCall) {
            MethodInvocation methodCall = (MethodInvocation)rewrite.createMoveTarget((ASTNode)this.fMethodInvocation);
            return methodCall;
        }
        return this.fCollectionName;
    }

    private List getProposalsForElement() {
        ArrayList<String> list = new ArrayList<String>();
        ICompilationUnit icu = this.getCompilationUnit();
        IJavaProject javaProject = icu.getJavaProject();
        int dimensions = this.fOldCollectionTypeBinding.getDimensions() - 1;
        List used = this.getUsedVariableNames();
        String type = this.fOldCollectionTypeBinding.getName();
        if (this.fOldCollectionTypeBinding.isArray()) {
            type = this.fOldCollectionTypeBinding.getElementType().getName();
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(javaProject, type, dimensions, used.toArray(new String[used.size()]));
        int i = 0;
        while (i < proposals.length) {
            list.add(proposals[i]);
            ++i;
        }
        return list;
    }

    private List getUsedVariableNames() {
        CompilationUnit root = (CompilationUnit)this.fOldForStatement.getRoot();
        IBinding[] varsBefore = new ScopeAnalyzer(root).getDeclarationsInScope(this.fOldForStatement.getStartPosition(), 2);
        IBinding[] varsAfter = new ScopeAnalyzer(root).getDeclarationsAfter(this.fOldForStatement.getStartPosition() + this.fOldForStatement.getLength(), 2);
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < varsBefore.length) {
            names.add(varsBefore[i].getName());
            ++i;
        }
        i = 0;
        while (i < varsAfter.length) {
            names.add(varsAfter[i].getName());
            ++i;
        }
        return names;
    }

    private void doFindAndReplaceInBody(ASTRewrite rewrite) {
        LocalOccurencesFinder finder = new LocalOccurencesFinder(this.fCollectionName, this.fOldCollectionBinding, this.fOldCollectionTypeBinding, (ASTNode)this.fOldForStatement.getBody());
        finder.perform();
        List occurences = finder.getOccurences();
        if (occurences.size() == 1) {
            ArrayAccess arrayAccess;
            ArrayAccess arrayAccess2;
            ASTNode soleOccurence = (ASTNode)occurences.get(0);
            if (soleOccurence instanceof ArrayAccess) {
                arrayAccess2 = (ArrayAccess)soleOccurence;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.ArrayAccess");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                arrayAccess2 = arrayAccess = (ArrayAccess)ASTNodes.getParent(soleOccurence, clazz);
            }
            if (arrayAccess != null && arrayAccess.getParent() instanceof VariableDeclarationFragment) {
                this.replaceSingleVariableDeclaration(rewrite, arrayAccess);
                return;
            }
        }
        this.replaceMultipleOccurences(rewrite, occurences);
    }

    private void replaceSingleVariableDeclaration(ASTRewrite rewrite, ArrayAccess arrayAccess) {
        VariableDeclarationFragment declarationFragment = (VariableDeclarationFragment)arrayAccess.getParent();
        VariableDeclarationStatement declarationStatement = (VariableDeclarationStatement)declarationFragment.getParent();
        if (this.fParameterDeclaration == null) {
            this.fParameterDeclaration = this.fAst.newSingleVariableDeclaration();
        }
        SimpleName theTempVariable = declarationFragment.getName();
        SimpleName name = this.fAst.newSimpleName(theTempVariable.getIdentifier());
        Type type = ASTNodeFactory.newType(this.getAst(), (VariableDeclaration)declarationFragment);
        this.fParameterDeclaration.setName(name);
        this.fParameterDeclaration.setType(type);
        LocalOccurencesFinder finder2 = new LocalOccurencesFinder(theTempVariable.resolveBinding(), (ASTNode)this.fOldForStatement.getBody());
        finder2.perform();
        List occurences2 = finder2.getOccurences();
        this.linkAllReferences(rewrite, occurences2);
        rewrite.replace((ASTNode)declarationStatement, null, null);
    }

    private void linkAllReferences(ASTRewrite rewrite, List occurences) {
        Iterator iter = occurences.iterator();
        while (iter.hasNext()) {
            ASTNode variableRef = (ASTNode)iter.next();
            this.addLinkedPosition(rewrite.track(variableRef), false, ELEMENT_KEY_REFERENCE);
        }
    }

    private void replaceMultipleOccurences(ASTRewrite rewrite, List occurences) {
        Iterator iter = occurences.iterator();
        while (iter.hasNext()) {
            ArrayAccess arrayAccess;
            ArrayAccess arrayAccess2;
            ASTNode element = (ASTNode)iter.next();
            if (element instanceof ArrayAccess) {
                arrayAccess2 = (ArrayAccess)element;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.dom.ArrayAccess");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                arrayAccess2 = arrayAccess = (ArrayAccess)ASTNodes.getParent(element, clazz);
            }
            if (arrayAccess == null) continue;
            SimpleName elementReference = this.fAst.newSimpleName(this.fParameterDeclaration.getName().getIdentifier());
            rewrite.replace((ASTNode)arrayAccess, (ASTNode)elementReference, null);
            this.addLinkedPosition(rewrite.track((ASTNode)elementReference), false, ELEMENT_KEY_REFERENCE);
        }
    }

    private void doInferElement() throws CoreException {
        if (this.fCollectionName == null) {
            this.createDefaultParameter();
        } else if (this.fOldCollectionTypeBinding.isArray()) {
            ITypeBinding elementType = this.fOldCollectionTypeBinding.getElementType();
            this.fParameterDeclaration = this.fAst.newSingleVariableDeclaration();
            SimpleName name = this.fAst.newSimpleName(ELEMENT_KEY_REFERENCE);
            this.fParameterDeclaration.setName(name);
            Type theType = this.getImportRewrite().addImport(elementType, this.fAst);
            if (this.fOldCollectionTypeBinding.getDimensions() != 1) {
                theType = this.fAst.newArrayType(theType, this.fOldCollectionTypeBinding.getDimensions() - 1);
            }
            this.fParameterDeclaration.setType(theType);
        }
    }

    private void createDefaultParameter() {
        this.fParameterDeclaration = this.fAst.newSingleVariableDeclaration();
        SimpleName name = this.fAst.newSimpleName(ELEMENT_KEY_REFERENCE);
        PrimitiveType type = this.fAst.newPrimitiveType(PrimitiveType.INT);
        this.fParameterDeclaration.setName(name);
        this.fParameterDeclaration.setType((Type)type);
    }

    private void doInferCollection() {
        if (this.fCollectionName != null) {
            return;
        }
        this.doInferCollectionFromExpression();
        if (this.fCollectionName == null) {
            this.doInferCollectionFromInitializers();
        }
    }

    private void doInferCollectionFromExpression() {
        Expression stopCondition = this.fOldForStatement.getExpression();
        if (stopCondition.getNodeType() == 27) {
            FieldAccess fieldAccess;
            Expression rightOperand = ((InfixExpression)stopCondition).getRightOperand();
            if (rightOperand.getNodeType() == 40) {
                Name qualifier = ((QualifiedName)rightOperand).getQualifier();
                this.fCollectionName = ASTNodeFactory.newName(this.fAst, qualifier.getFullyQualifiedName());
                this.fOldCollectionBinding = qualifier.resolveBinding();
                this.fOldCollectionTypeBinding = qualifier.resolveTypeBinding();
            } else if (rightOperand.getNodeType() == 32) {
                MethodInvocation methodCall = (MethodInvocation)rightOperand;
                Expression exp = methodCall.getExpression();
                if (exp instanceof Name) {
                    Name collectionName = (Name)exp;
                    this.fOldCollectionBinding = collectionName.resolveBinding();
                    this.fOldCollectionTypeBinding = collectionName.resolveTypeBinding();
                    this.fCollectionName = ASTNodeFactory.newName(this.fAst, collectionName.getFullyQualifiedName());
                }
            } else if (rightOperand instanceof FieldAccess && "length".equals((fieldAccess = (FieldAccess)rightOperand).getName().getIdentifier())) {
                this.fCollectionIsMethodCall = true;
                if (fieldAccess.getExpression() instanceof MethodInvocation) {
                    MethodInvocation methodCall;
                    this.fMethodInvocation = methodCall = (MethodInvocation)fieldAccess.getExpression();
                    this.fOldCollectionBinding = methodCall.resolveMethodBinding();
                    this.fOldCollectionTypeBinding = methodCall.resolveTypeBinding();
                    this.fCollectionName = ASTNodeFactory.newName(this.fAst, methodCall.getName().getFullyQualifiedName());
                }
            }
        }
    }

    private void doInferCollectionFromInitializers() {
        List initializers = this.fOldForStatement.initializers();
        Iterator iter = initializers.iterator();
        while (iter.hasNext()) {
            VariableDeclarationExpression element = (VariableDeclarationExpression)iter.next();
            List declarationFragments = element.fragments();
            Iterator iterator = declarationFragments.iterator();
            while (iterator.hasNext()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)iterator.next();
                this.doInferCollectionFromFragment(fragment);
            }
        }
    }

    private void doInferCollectionFromFragment(VariableDeclarationFragment fragment) {
        Expression initializer = fragment.getInitializer();
        initializer.accept(new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                this.initializeBindings(qualifiedName.getQualifier());
                return false;
            }

            public boolean visit(SimpleName simpleName) {
                this.initializeBindings((Name)simpleName);
                return false;
            }

            public boolean visit(MethodInvocation methodCall) {
                ITypeBinding typeBinding = methodCall.resolveTypeBinding();
                if (typeBinding.isArray()) {
                    ConvertForLoopProposal.this.fCollectionIsMethodCall = true;
                    ConvertForLoopProposal.this.fMethodInvocation = methodCall;
                    ConvertForLoopProposal.this.fOldCollectionTypeBinding = typeBinding;
                    ConvertForLoopProposal.this.fOldCollectionBinding = (IBinding)methodCall.resolveMethodBinding();
                    ConvertForLoopProposal.this.fCollectionName = ASTNodeFactory.newName(ConvertForLoopProposal.this.fAst, methodCall.getName().getFullyQualifiedName());
                }
                return false;
            }

            private void initializeBindings(Name name) {
                ITypeBinding typeBinding = name.resolveTypeBinding();
                if (typeBinding != null && typeBinding.isArray()) {
                    ConvertForLoopProposal.this.fOldCollectionTypeBinding = typeBinding;
                    ConvertForLoopProposal.this.fOldCollectionBinding = name.resolveBinding();
                    ConvertForLoopProposal.this.fCollectionName = ASTNodeFactory.newName(ConvertForLoopProposal.this.fAst, name.getFullyQualifiedName());
                }
            }
        });
    }

    private AST getAst() {
        return this.fAst;
    }

    private IBinding getIndexBinding() {
        if (this.fIndexBinding != null) {
            return this.fIndexBinding;
        }
        return this.inferIndexBinding();
    }

    private class LocalOccurencesFinder
    extends ASTVisitor {
        private List fOccurences;
        private ASTNode fScope;
        private IBinding fTempBinding;
        private ITypeBinding fTempTypeBinding;
        static /* synthetic */ Class class$0;

        public LocalOccurencesFinder(Name collectionName, IBinding oldCollectionBinding, ITypeBinding oldCollectionTypeBinding, ASTNode scope) {
            this.fScope = scope;
            this.fOccurences = new ArrayList();
            this.fTempBinding = oldCollectionBinding;
            this.fTempTypeBinding = oldCollectionTypeBinding;
        }

        public LocalOccurencesFinder(Name name, ASTNode scope) {
            this.fScope = scope;
            this.fOccurences = new ArrayList();
            this.fTempBinding = name.resolveBinding();
        }

        public LocalOccurencesFinder(IBinding binding, ASTNode scope) {
            this.fScope = scope;
            this.fOccurences = new ArrayList();
            this.fTempBinding = binding;
        }

        public void perform() {
            this.fScope.accept((ASTVisitor)this);
        }

        public boolean visit(SimpleName node) {
            if (node.getParent() instanceof VariableDeclaration && ((VariableDeclaration)node.getParent()).getName() == node) {
                return true;
            }
            if (this.fTempBinding != null && Bindings.equals(this.fTempBinding, node.resolveBinding())) {
                this.fOccurences.add(node);
            }
            return true;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            ArrayAccess arrayAccess;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.ArrayAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((arrayAccess = (ArrayAccess)ASTNodes.getParent((ASTNode)methodInvocation, clazz)) != null && this.fTempTypeBinding != null && Bindings.equals(this.fTempBinding, (IBinding)methodInvocation.resolveMethodBinding())) {
                this.fOccurences.add(arrayAccess);
                return false;
            }
            return true;
        }

        public List getOccurences() {
            return this.fOccurences;
        }
    }
}

