/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.SmartSemicolonAutoEditStrategy;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class LazyJavaCompletionProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private boolean fDisplayStringComputed;
    private String fDisplayString;
    private boolean fReplacementStringComputed;
    private String fReplacementString;
    private boolean fReplacementOffsetComputed;
    private int fReplacementOffset;
    private boolean fReplacementLengthComputed;
    private int fReplacementLength;
    private boolean fCursorPositionComputed;
    private int fCursorPosition;
    private boolean fImageComputed;
    private Image fImage;
    private boolean fContextInformationComputed;
    private IContextInformation fContextInformation;
    private boolean fProposalInfoComputed;
    private ProposalInfo fProposalInfo;
    private boolean fTriggerCharactersComputed;
    private char[] fTriggerCharacters;
    private boolean fSortStringComputed;
    private String fSortString;
    private boolean fRelevanceComputed;
    private int fRelevance;
    protected final CompletionProposal fProposal;
    private StyleRange fRememberedStyleRange;
    private boolean fToggleEating;
    private ITextViewer fTextViewer;

    public LazyJavaCompletionProposal(CompletionProposal proposal) {
        Assert.isNotNull((Object)proposal);
        this.fProposal = proposal;
    }

    public final char[] getTriggerCharacters() {
        if (!this.fTriggerCharactersComputed) {
            this.setTriggerCharacters(this.computeTriggerCharacters());
        }
        return this.fTriggerCharacters;
    }

    protected char[] computeTriggerCharacters() {
        return new char[0];
    }

    public final void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharactersComputed = true;
        this.fTriggerCharacters = triggerCharacters;
    }

    public final void setProposalInfo(ProposalInfo proposalInfo) {
        this.fProposalInfoComputed = true;
        this.fProposalInfo = proposalInfo;
    }

    public final ProposalInfo getProposalInfo() {
        if (!this.fProposalInfoComputed) {
            this.setProposalInfo(this.computeProposalInfo());
        }
        return this.fProposalInfo;
    }

    protected ProposalInfo computeProposalInfo() {
        return null;
    }

    public final void setCursorPosition(int cursorPosition) {
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fCursorPositionComputed = true;
        this.fCursorPosition = cursorPosition;
    }

    protected final int getCursorPosition() {
        if (!this.fCursorPositionComputed) {
            this.setCursorPosition(this.computeCursorPosition());
        }
        return this.fCursorPosition;
    }

    protected int computeCursorPosition() {
        return this.getReplacementString().length();
    }

    public final void apply(IDocument document) {
        this.apply(document, '\u0000', this.getReplacementOffset() + this.getReplacementLength());
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            String replacement;
            boolean isSmartTrigger;
            int delta = offset - (this.getReplacementOffset() + this.getReplacementLength());
            if (delta > 0) {
                this.setReplacementLength(this.getReplacementLength() + delta);
            }
            if ((isSmartTrigger = this.isSmartTrigger(trigger)) || trigger == '\u0000') {
                replacement = this.getReplacementString();
            } else {
                StringBuffer buffer = new StringBuffer(this.getReplacementString());
                if (this.getCursorPosition() > 0 && this.getCursorPosition() <= buffer.length() && buffer.charAt(this.getCursorPosition() - 1) != trigger) {
                    buffer.insert(this.getCursorPosition(), trigger);
                    this.setCursorPosition(this.getCursorPosition() + 1);
                }
                replacement = buffer.toString();
                this.setReplacementString(replacement);
            }
            int referenceOffset = this.getReplacementOffset() + this.getReplacementLength();
            ReferenceTracker referenceTracker = new ReferenceTracker();
            referenceTracker.preReplace(document, referenceOffset);
            this.replace(document, this.getReplacementOffset(), this.getReplacementLength(), replacement);
            referenceOffset = referenceTracker.postReplace(document);
            this.setReplacementOffset(referenceOffset - (replacement == null ? 0 : replacement.length()));
            if (isSmartTrigger) {
                this.handleSmartTrigger(document, trigger, referenceOffset);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isSmartTrigger(char trigger) {
        return trigger == ';' && JavaPlugin.getDefault().getCombinedPreferenceStore().getBoolean("smart_semicolon") || trigger == '{' && JavaPlugin.getDefault().getCombinedPreferenceStore().getBoolean("smart_opening_brace");
    }

    private void handleSmartTrigger(IDocument document, char trigger, int referenceOffset) throws BadLocationException {
        DocumentCommand cmd = new DocumentCommand(){};
        cmd.offset = referenceOffset;
        cmd.length = 0;
        cmd.text = Character.toString(trigger);
        cmd.doit = true;
        cmd.shiftsCaret = true;
        cmd.caretOffset = this.getReplacementOffset() + this.getCursorPosition();
        SmartSemicolonAutoEditStrategy strategy = new SmartSemicolonAutoEditStrategy("___java_partitioning");
        strategy.customizeDocumentCommand(document, cmd);
        this.replace(document, cmd.offset, cmd.length, cmd.text);
        this.setCursorPosition(cmd.caretOffset - this.getReplacementOffset() + cmd.text.length());
    }

    protected final void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (!document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (this.fTextViewer == null) {
            this.fTextViewer = viewer;
        }
        if (!this.validate(document, offset, null)) {
            this.setCursorPosition(offset - this.getReplacementOffset());
            if (trigger != '\u0000') {
                try {
                    document.replace(offset, 0, String.valueOf(trigger));
                    this.setCursorPosition(this.getCursorPosition() + 1);
                }
                catch (BadLocationException badLocationException) {}
            }
            return;
        }
        Point selection = viewer.getSelectedRange();
        this.fToggleEating = (stateMask & SWT.MOD1) != 0;
        int newLength = selection.x + selection.y - this.getReplacementOffset();
        if (LazyJavaCompletionProposal.insertCompletion() ^ this.fToggleEating && newLength >= 0) {
            this.setReplacementLength(newLength);
        }
        this.apply(document, trigger, offset);
        this.fToggleEating = false;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.getReplacementOffset() + this.getCursorPosition(), 0);
    }

    public final IContextInformation getContextInformation() {
        if (!this.fContextInformationComputed) {
            this.setContextInformation(this.computeContextInformation());
        }
        return this.fContextInformation;
    }

    protected IContextInformation computeContextInformation() {
        return null;
    }

    public final void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformationComputed = true;
        this.fContextInformation = contextInformation;
    }

    public final String getDisplayString() {
        if (!this.fDisplayStringComputed) {
            this.fDisplayStringComputed = true;
            this.fDisplayString = this.computeDisplayString();
        }
        return this.fDisplayString;
    }

    protected String computeDisplayString() {
        return new CompletionProposalLabelProvider().createLabel(this.fProposal);
    }

    public final String getAdditionalProposalInfo() {
        if (this.getProposalInfo() != null) {
            return this.getProposalInfo().getInfo();
        }
        return null;
    }

    public final int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public final int getReplacementOffset() {
        if (!this.fReplacementOffsetComputed) {
            this.setReplacementOffset(this.fProposal.getReplaceStart());
        }
        return this.fReplacementOffset;
    }

    public final void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.fReplacementOffsetComputed = true;
        this.fReplacementOffset = replacementOffset;
    }

    public final int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    public final int getReplacementLength() {
        if (!this.fReplacementLengthComputed) {
            this.setReplacementLength(this.fProposal.getReplaceEnd() - this.fProposal.getReplaceStart());
        }
        return this.fReplacementLength;
    }

    public final void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementLengthComputed = true;
        this.fReplacementLength = replacementLength;
    }

    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return this.fReplacementString;
    }

    protected String computeReplacementString() {
        return String.valueOf(this.fProposal.getCompletion());
    }

    public final void setReplacementString(String replacementString) {
        Assert.isNotNull((Object)replacementString);
        this.fReplacementStringComputed = true;
        this.fReplacementString = replacementString;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getReplacementString();
    }

    public final Image getImage() {
        if (!this.fImageComputed) {
            this.setImage(this.computeImage());
        }
        return this.fImage;
    }

    protected Image computeImage() {
        return JavaPlugin.getImageDescriptorRegistry().get(new CompletionProposalLabelProvider().createImageDescriptor(this.fProposal));
    }

    public final void setImage(Image image) {
        this.fImageComputed = true;
        this.fImage = image;
    }

    public final boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        boolean validated;
        if (offset < this.getReplacementOffset()) {
            return false;
        }
        String expected = this.getDisplayString();
        if (this.fProposal.getKind() == 12) {
            StringBuffer buf = new StringBuffer();
            buf.append(Signature.toCharArray((char[])this.fProposal.getDeclarationSignature()));
            buf.append('.');
            buf.append(expected);
            expected = buf.toString();
        }
        if ((validated = this.startsWith(document, offset, expected)) && event != null) {
            int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
            int newLength = Math.max(this.getReplacementLength() + delta, 0);
            this.setReplacementLength(newLength);
        }
        return validated;
    }

    public final int getRelevance() {
        if (!this.fRelevanceComputed) {
            this.setRelevance(this.computeRelevance());
        }
        return this.fRelevance;
    }

    public final void setRelevance(int relevance) {
        this.fRelevanceComputed = true;
        this.fRelevance = relevance;
    }

    protected final boolean startsWith(IDocument document, int offset, String word) {
        int wordLength;
        int n = wordLength = word == null ? 0 : word.length();
        if (offset > this.getReplacementOffset() + wordLength) {
            return false;
        }
        try {
            int length = offset - this.getReplacementOffset();
            String start = document.get(this.getReplacementOffset(), length);
            return word.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean insertCompletion() {
        IPreferenceStore preference = JavaPlugin.getDefault().getPreferenceStore();
        return preference.getBoolean("content_assist_insert_completion");
    }

    private static Color getForegroundColor(StyledText text) {
        IPreferenceStore preference = JavaPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"content_assist_completion_replacement_foreground");
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private static Color getBackgroundColor(StyledText text) {
        IPreferenceStore preference = JavaPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"content_assist_completion_replacement_background");
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private void repairPresentation(ITextViewer viewer) {
        if (this.fRememberedStyleRange != null) {
            if (viewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 viewer2 = (ITextViewerExtension2)viewer;
                if (viewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                    IRegion modelRange = extension.widgetRange2ModelRange((IRegion)new Region(this.fRememberedStyleRange.start, this.fRememberedStyleRange.length));
                    if (modelRange != null) {
                        viewer2.invalidateTextPresentation(modelRange.getOffset(), modelRange.getLength());
                    }
                } else {
                    viewer2.invalidateTextPresentation(this.fRememberedStyleRange.start + viewer.getVisibleRegion().getOffset(), this.fRememberedStyleRange.length);
                }
            } else {
                viewer.invalidateTextPresentation();
            }
        }
    }

    private void updateStyle(ITextViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int widgetCaret = text.getCaretOffset();
        int modelCaret = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            modelCaret = extension.widgetOffset2ModelOffset(widgetCaret);
        } else {
            IRegion visibleRegion = viewer.getVisibleRegion();
            modelCaret = widgetCaret + visibleRegion.getOffset();
        }
        if (modelCaret >= this.getReplacementOffset() + this.getReplacementLength()) {
            this.repairPresentation(viewer);
            return;
        }
        int offset = widgetCaret;
        int length = this.getReplacementOffset() + this.getReplacementLength() - modelCaret;
        Color foreground = LazyJavaCompletionProposal.getForegroundColor(text);
        Color background = LazyJavaCompletionProposal.getBackgroundColor(text);
        StyleRange range = text.getStyleRangeAtOffset(offset);
        int fontStyle = range != null ? range.fontStyle : 0;
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = new StyleRange(offset, length, foreground, background, fontStyle);
        if (range != null) {
            this.fRememberedStyleRange.strikeout = range.strikeout;
            this.fRememberedStyleRange.underline = range.underline;
        }
        try {
            text.setStyleRange(this.fRememberedStyleRange);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fRememberedStyleRange = null;
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        if (!LazyJavaCompletionProposal.insertCompletion() ^ smartToggle) {
            this.updateStyle(viewer);
        } else {
            this.repairPresentation(viewer);
            this.fRememberedStyleRange = null;
        }
    }

    public void unselected(ITextViewer viewer) {
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = null;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    protected int computeRelevance() {
        int baseRelevance = this.fProposal.getRelevance() * 16;
        switch (this.fProposal.getKind()) {
            case 8: {
                return baseRelevance + 0;
            }
            case 4: {
                return baseRelevance + 1;
            }
            case 3: {
                return baseRelevance + 2;
            }
            case 1: 
            case 9: {
                return baseRelevance + 3;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                return baseRelevance + 4;
            }
            case 11: {
                return baseRelevance + 4;
            }
            case 2: {
                return baseRelevance + 5;
            }
            case 5: 
            case 10: {
                return baseRelevance + 6;
            }
        }
        return baseRelevance;
    }

    public final String getSortString() {
        if (!this.fSortStringComputed) {
            this.setSortString(this.computeSortString());
        }
        return this.fSortString;
    }

    protected final void setSortString(String string) {
        this.fSortStringComputed = true;
        this.fSortString = string;
    }

    protected String computeSortString() {
        return this.getDisplayString();
    }

    protected final ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    protected final boolean isToggleEating() {
        return this.fToggleEating;
    }

    static final class ReferenceTracker {
        private static final String CATEGORY = "reference_position";
        private final IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("reference_position");
        private final Position fPosition = new Position(0);

        ReferenceTracker() {
        }

        public void preReplace(IDocument document, int offset) throws BadLocationException {
            this.fPosition.setOffset(offset);
            try {
                document.addPositionCategory(CATEGORY);
                document.addPositionUpdater(this.fPositionUpdater);
                document.addPosition(CATEGORY, this.fPosition);
            }
            catch (BadPositionCategoryException e) {
                JavaPlugin.log(e);
            }
        }

        public int postReplace(IDocument document) {
            try {
                document.removePosition(CATEGORY, this.fPosition);
                document.removePositionUpdater(this.fPositionUpdater);
                document.removePositionCategory(CATEGORY);
            }
            catch (BadPositionCategoryException e) {
                JavaPlugin.log(e);
            }
            return this.fPosition.getOffset();
        }
    }
}

