/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public abstract class AbstractAnnotationHover
extends AbstractJavaEditorTextHover {
    private IPreferenceStore fStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
    private DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
    private boolean fAllAnnotations;

    public AbstractAnnotationHover(boolean allAnnotations) {
        this.fAllAnnotations = allAnnotations;
    }

    private String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block12: {
            if (textViewer instanceof ISourceViewer) {
                path = null;
                model = ((ISourceViewer)textViewer).getAnnotationModel();
            } else {
                path = this.getEditorInputPath();
                model = this.getAnnotationModel(path);
            }
            if (model == null) {
                return null;
            }
            try {
                e = new JavaAnnotationIterator(model, true, this.fAllAnnotations);
                layer = -1;
                message = null;
                while (true) {
                    if (!e.hasNext()) {
                        if (layer <= -1) break block12;
                        var15_13 = this.formatMessage(message);
                        var13_14 = null;
                        break;
                    }
                    a = (Annotation)e.next();
                    preference = this.getAnnotationPreference(a);
                    if (preference == null || (preference.getTextPreferenceKey() == null || !this.fStore.getBoolean(preference.getTextPreferenceKey())) && (preference.getHighlightPreferenceKey() == null || !this.fStore.getBoolean(preference.getHighlightPreferenceKey()))) continue;
                    p = model.getPosition(a);
                    l = this.fAnnotationAccess.getLayer(a);
                    if (l <= layer || p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
                    message = msg;
                    layer = l;
                }
            }
            catch (Throwable var14_23) {
                var13_15 = null;
                try {
                    if (path == null) throw var14_23;
                    manager = FileBuffers.getTextFileBufferManager();
                    manager.disconnect(path, null);
                    throw var14_23;
                }
                catch (CoreException ex) {
                    JavaPlugin.log(ex.getStatus());
                }
                throw var14_23;
            }
            ** try [egrp 1[TRYBLOCK] [3 : 273->294)] { 
lbl42:
            // 1 sources

            if (path == null) return var15_13;
            manager = FileBuffers.getTextFileBufferManager();
            manager.disconnect(path, null);
            return var15_13;
lbl46:
            // 1 sources

            catch (CoreException ex) {
                JavaPlugin.log(ex.getStatus());
            }
            return var15_13;
        }
        var13_16 = null;
        try {}
        catch (CoreException ex) {
            JavaPlugin.log(ex.getStatus());
            return null;
        }
        if (path == null) return null;
        manager = FileBuffers.getTextFileBufferManager();
        manager.disconnect(path, null);
        return null;
    }

    private IPath getEditorInputPath() {
        if (this.getEditor() == null) {
            return null;
        }
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof IStorageEditorInput) {
            try {
                return ((IStorageEditorInput)input).getStorage().getFullPath();
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex.getStatus());
            }
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel(IPath path) {
        IAnnotationModel iAnnotationModel;
        block8: {
            if (path == null) {
                return null;
            }
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            try {
                manager.connect(path, null);
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex.getStatus());
                return null;
            }
            IAnnotationModel model = null;
            try {
                iAnnotationModel = model = manager.getTextFileBuffer(path).getAnnotationModel();
                Object var4_6 = null;
                if (model != null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var4_7 = null;
                    if (model != null) break block9;
                    try {
                        manager.disconnect(path, null);
                    }
                    catch (CoreException ex) {
                        JavaPlugin.log(ex.getStatus());
                    }
                }
                throw throwable;
            }
            try {
                manager.disconnect(path, null);
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex.getStatus());
            }
        }
        return iAnnotationModel;
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }
}

