/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.Properties;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;

public class NLSStringHover
extends AbstractJavaEditorTextHover {
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (!(this.getEditor() instanceof JavaEditor)) {
            return null;
        }
        IJavaElement je = this.getEditorInputJavaElement();
        if (je == null) {
            return null;
        }
        CompilationUnit ast = JavaPlugin.getDefault().getASTProvider().getAST(je, ASTProvider.WAIT_NO, null);
        if (ast == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, offset, 1);
        if (!(node instanceof StringLiteral)) {
            return null;
        }
        StringLiteral stringLiteral = (StringLiteral)node;
        return new Region(stringLiteral.getStartPosition(), stringLiteral.getLength());
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IStorage propertiesFile;
        if (!(this.getEditor() instanceof JavaEditor)) {
            return null;
        }
        IJavaElement je = this.getEditorInputJavaElement();
        if (je == null) {
            return null;
        }
        CompilationUnit ast = JavaPlugin.getDefault().getASTProvider().getAST(je, ASTProvider.WAIT_ACTIVE_ONLY, null);
        if (ast == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, hoverRegion.getOffset(), hoverRegion.getLength());
        if (!(node instanceof StringLiteral)) {
            return null;
        }
        StringLiteral stringLiteral = (StringLiteral)node;
        AccessorClassReference ref = NLSHintHelper.getAccessorClassReference(ast, hoverRegion);
        if (ref == null) {
            return null;
        }
        try {
            propertiesFile = NLSHintHelper.getResourceBundle(je.getJavaProject(), ref);
            if (propertiesFile == null) {
                return null;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        Properties properties = NLSHintHelper.getProperties(propertiesFile);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        String value = properties.getProperty(stringLiteral.getLiteralValue(), null);
        value = value != null ? HTMLPrinter.convertToHTMLContent(value) : JavaHoverMessages.NLSStringHover_NLSStringHover_missingKeyWarning;
        return this.toHtml(propertiesFile.getName(), value);
    }

    private String toHtml(String header, String string) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addSmallHeader(buffer, header);
        HTMLPrinter.addParagraph(buffer, string);
        HTMLPrinter.insertPageProlog(buffer, 0);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private IJavaElement getEditorInputJavaElement() {
        IEditorInput editorInput;
        if (this.getEditor() instanceof CompilationUnitEditor) {
            return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditor().getEditorInput());
        }
        if (this.getEditor() instanceof ClassFileEditor && (editorInput = this.getEditor().getEditorInput()) instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)editorInput).getClassFile();
        }
        return null;
    }
}

