/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavadocCompletionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.part.FileEditorInput;

public class WordCompletionProcessor
implements IContentAssistProcessor,
IJavadocCompletionProcessor {
    protected static final int PREFIX_RANK_SHIFT = 4096;
    private String fError = null;

    public final IJavaCompletionProposal[] computeCompletionProposals(ICompilationUnit cu, int offset, int length, int flags) {
        if (this.contributes()) {
            FileEditorInput editorInput = new FileEditorInput((IFile)cu.getResource());
            IDocument document = JavaUI.getDocumentProvider().getDocument((Object)editorInput);
            return this.computeCompletionProposals(document, offset);
        }
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (this.contributes()) {
            return this.computeCompletionProposals(viewer.getDocument(), offset);
        }
        return null;
    }

    private boolean contributes() {
        return PreferenceConstants.getPreferenceStore().getBoolean("spelling_enable_contentassist");
    }

    private IJavaCompletionProposal[] computeCompletionProposals(IDocument document, int offset) {
        IJavaCompletionProposal[] result = null;
        try {
            ISpellCheckEngine engine;
            ISpellChecker checker;
            IRegion region = document.getLineInformationOfOffset(offset);
            String content = document.get(region.getOffset(), region.getLength());
            int index = offset - region.getOffset() - 1;
            while (index >= 0 && Character.isLetter(content.charAt(index))) {
                --index;
            }
            int start = region.getOffset() + index + 1;
            String candidate = content.substring(index + 1, offset - region.getOffset());
            if (candidate.length() > 0 && (checker = (engine = SpellCheckEngine.getInstance()).createSpellChecker(engine.getLocale(), PreferenceConstants.getPreferenceStore())) != null) {
                ArrayList proposals = new ArrayList(checker.getProposals(candidate, Character.isUpperCase(candidate.charAt(0))));
                result = new IJavaCompletionProposal[proposals.size()];
                RankedWordProposal word = null;
                int proposal = 0;
                while (proposal < result.length) {
                    word = (RankedWordProposal)proposals.get(proposal);
                    if (word.getText().startsWith(candidate)) {
                        word.setRank(word.getRank() + 4096);
                    }
                    ++proposal;
                }
                String text = null;
                int proposal2 = 0;
                while (proposal2 < result.length) {
                    word = (RankedWordProposal)proposals.get(proposal2);
                    text = word.getText();
                    result[proposal2] = new JavaCompletionProposal(text, start, candidate.length(), JavaPluginImages.get("org.eclipse.jdt.ui.correction_rename.gif"), text, word.getRank());
                    ++proposal2;
                }
            }
        }
        catch (BadLocationException exception) {
            this.fError = result == null ? exception.getLocalizedMessage() : null;
        }
        return result;
    }

    public final IContextInformation[] computeContextInformation(ICompilationUnit cu, int offset) {
        return null;
    }

    public final IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public final char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public final char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public final IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public final String getErrorMessage() {
        return this.fError;
    }
}

