/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.internal.ui.wizards.JavaProjectWizardFirstPage;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class JavaProjectWizardSecondPage
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_CLASSPATH = ".classpath";
    private final JavaProjectWizardFirstPage fFirstPage;
    private IPath fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotClasspathBackup;
    private Boolean fIsAutobuild;

    public JavaProjectWizardSecondPage(JavaProjectWizardFirstPage mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        this.fIsAutobuild = null;
    }

    protected boolean useNewSourcePage() {
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.changeToNewProject();
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
    }

    private void changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (JavaProjectWizardSecondPage.this.fIsAutobuild == null) {
                            JavaProjectWizardSecondPage.this.fIsAutobuild = CoreUtility.enableAutoBuild(false);
                        }
                        JavaProjectWizardSecondPage.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.JavaProjectWizardSecondPage_error_title;
            String message = NewWizardMessages.JavaProjectWizardSecondPage_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.fFirstPage.getLocationPath();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_initialize, 7);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IPath realLocation = this.fCurrProjectLocation;
            if (Platform.getLocation().equals((Object)this.fCurrProjectLocation)) {
                realLocation = this.fCurrProjectLocation.append(this.fCurrProject.getName());
            }
            this.rememberExistingFiles(realLocation);
            JavaProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            IClasspathEntry[] entries = null;
            IPath outputLocation = null;
            if (this.fFirstPage.getDetect()) {
                if (!this.fCurrProject.getFile(FILENAME_CLASSPATH).exists()) {
                    ClassPathDetector detector = new ClassPathDetector(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    entries = detector.getClasspath();
                    outputLocation = detector.getOutputLocation();
                } else {
                    monitor.worked(2);
                }
            } else if (this.fFirstPage.isSrcBin()) {
                IFolder folder;
                IPreferenceStore store = PreferenceConstants.getPreferenceStore();
                Path srcPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
                Path binPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
                if (srcPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                if (binPath.segmentCount() > 0 && !binPath.equals((Object)srcPath)) {
                    folder = this.fCurrProject.getFolder((IPath)binPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                cpEntries.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                outputLocation = projectPath.append((IPath)binPath);
            } else {
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath));
                cpEntries.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                outputLocation = projectPath;
                monitor.worked(2);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(JavaCore.create((IProject)this.fCurrProject), outputLocation, entries, false);
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_15 = null;
        }
        monitor.done();
    }

    private IClasspathEntry[] getDefaultClasspathEntry() {
        IClasspathEntry[] defaultJRELibrary = PreferenceConstants.getDefaultJRELibrary();
        String compliance = this.fFirstPage.getJRECompliance();
        Path jreContainerPath = new Path(JavaRuntime.JRE_CONTAINER);
        if (compliance == null || defaultJRELibrary.length > 1 || !jreContainerPath.isPrefixOf(defaultJRELibrary[0].getPath())) {
            return defaultJRELibrary;
        }
        IVMInstall inst = BuildPathSupport.findMatchingJREInstall(compliance);
        if (inst != null) {
            IPath newPath = jreContainerPath.append(inst.getVMInstallType().getId()).append(inst.getName());
            return new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)newPath)};
        }
        return defaultJRELibrary;
    }

    private void rememberExistingFiles(IPath currProjectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        File file = currProjectLocation.toFile();
        if (file.exists()) {
            File classpathFile;
            File projectFile = new File(file, FILENAME_PROJECT);
            if (projectFile.exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((classpathFile = new File(file, FILENAME_CLASSPATH)).exists()) {
                this.fDotClasspathBackup = this.createBackup(classpathFile, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(File projectLocation) throws CoreException {
        try {
            File projectFile;
            if (this.fDotProjectBackup != null && (projectFile = new File(projectLocation, FILENAME_PROJECT)).delete()) {
                this.copyFile(this.fDotProjectBackup, projectFile);
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewWizardMessages.JavaProjectWizardSecondPage_problem_restore_project, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            File classpathFile;
            if (this.fDotClasspathBackup != null && (classpathFile = new File(projectLocation, FILENAME_CLASSPATH)).delete()) {
                this.copyFile(this.fDotClasspathBackup, classpathFile);
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewWizardMessages.JavaProjectWizardSecondPage_problem_restore_classpath, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(File file, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, "bak");
            this.copyFile(file, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, Messages.format(NewWizardMessages.JavaProjectWizardSecondPage_problem_backup, name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(File file, File target) throws IOException {
        FileInputStream is = new FileInputStream(file);
        FileOutputStream os = new FileOutputStream(target);
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                is.close();
                Object var9_13 = null;
            }
            catch (Throwable throwable2) {
                Object var9_12 = null;
                os.close();
                throw throwable2;
            }
            os.close();
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var9_14 = null;
            os.close();
            throw throwable;
        }
        is.close();
        Object var9_15 = null;
        os.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            String compliance = this.fFirstPage.getJRECompliance();
            if (compliance != null) {
                IJavaProject project = JavaCore.create((IProject)this.fCurrProject);
                Map options = project.getOptions(false);
                JavaModelUtil.setCompilanceOptions(options, compliance);
                project.setOptions(options);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild == null) throw throwable;
            CoreUtility.enableAutoBuild(this.fIsAutobuild);
            this.fIsAutobuild = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
        this.fCurrProject = null;
        if (this.fIsAutobuild == null) return;
        CoreUtility.enableAutoBuild(this.fIsAutobuild);
        this.fIsAutobuild = null;
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                JavaProjectWizardSecondPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.JavaProjectWizardSecondPage_error_remove_title;
            String message = NewWizardMessages.JavaProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor = Platform.getLocation().equals((Object)this.fCurrProjectLocation);
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                try {
                    File projLoc = this.fCurrProject.getLocation().toFile();
                    boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(removeContent, false, monitor);
                    this.restoreExistingFiles(projLoc);
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        monitor.done();
        this.fCurrProject = null;
        this.fKeepContent = false;
    }

    public void performCancel() {
        this.removeProject();
    }
}

