/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.AddSelectedSourceFolderOperation;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.CreateFolderOperation;
import org.eclipse.jdt.internal.corext.buildpath.EditFiltersOperation;
import org.eclipse.jdt.internal.corext.buildpath.EditOutputFolderOperation;
import org.eclipse.jdt.internal.corext.buildpath.ExcludeOperation;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.corext.buildpath.IPackageExplorerActionListener;
import org.eclipse.jdt.internal.corext.buildpath.LinkedSourceFolderOperation;
import org.eclipse.jdt.internal.corext.buildpath.PackageExplorerActionEvent;
import org.eclipse.jdt.internal.corext.buildpath.RemoveFromClasspathOperation;
import org.eclipse.jdt.internal.corext.buildpath.ResetAllOperation;
import org.eclipse.jdt.internal.corext.buildpath.UnexcludeOperation;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.util.ViewerPane;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierDropDownAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.HelpAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionContext;

public class DialogPackageExplorerActionGroup
extends CompositeActionGroup {
    public static final int JAVA_PROJECT = 1;
    public static final int PACKAGE_FRAGMENT_ROOT = 2;
    public static final int PACKAGE_FRAGMENT = 3;
    public static final int COMPILATION_UNIT = 4;
    public static final int FILE = 5;
    public static final int FOLDER = 6;
    public static final int EXCLUDED_FOLDER = 7;
    public static final int EXCLUDED_FILE = 8;
    public static final int DEFAULT_OUTPUT = 9;
    public static final int INCLUDED_FILE = 10;
    public static final int INCLUDED_FOLDER = 11;
    public static final int OUTPUT = 12;
    public static final int ARCHIVE = 13;
    public static final int MODIFIED_FRAGMENT_ROOT = 14;
    public static final int DEFAULT_FRAGMENT = 15;
    public static final int UNDEFINED = 16;
    public static final int MULTI = 17;
    public static final int NULL_SELECTION = 18;
    public static final int ARCHIVE_RESOURCE = 19;
    public static final int CONTAINER = 20;
    private ClasspathModifierAction[] fActions;
    private int fLastType = 16;
    private List fListeners = new ArrayList();
    private static final int fContextSensitiveActions = 5;

    public DialogPackageExplorerActionGroup(IClasspathInformationProvider provider, ClasspathModifier.IClasspathModifierListener listener) {
        this.fActions = new ClasspathModifierAction[7];
        ClasspathModifierOperation op = new CreateFolderOperation(listener, provider);
        op = new AddSelectedSourceFolderOperation(listener, provider);
        this.addAction(new ClasspathModifierAction(op, JavaPluginImages.DESC_ELCL_ADD_AS_SOURCE_FOLDER, null, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip, 1), 0);
        op = new RemoveFromClasspathOperation(listener, provider);
        this.addAction(new ClasspathModifierAction(op, JavaPluginImages.DESC_ELCL_REMOVE_AS_SOURCE_FOLDER, JavaPluginImages.DESC_DLCL_REMOVE_AS_SOURCE_FOLDER, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip, 1), 1);
        op = new ExcludeOperation(listener, provider);
        this.addAction(new ClasspathModifierAction(op, JavaPluginImages.DESC_ELCL_EXCLUDE_FROM_BUILDPATH, JavaPluginImages.DESC_DLCL_EXCLUDE_FROM_BUILDPATH, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_tooltip, 1), 2);
        op = new UnexcludeOperation(listener, provider);
        this.addAction(new ClasspathModifierAction(op, JavaPluginImages.DESC_ELCL_INCLUDE_ON_BUILDPATH, JavaPluginImages.DESC_DLCL_INCLUDE_ON_BUILDPATH, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_tooltip, 1), 3);
        op = new EditFiltersOperation(listener, provider);
        ClasspathModifierAction action = new ClasspathModifierAction(op, JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS, JavaPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip, 1);
        ClasspathModifierDropDownAction dropDown = new ClasspathModifierDropDownAction(action, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Configure_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Configure_tooltip);
        this.addAction(dropDown, 4);
        op = new EditOutputFolderOperation(listener, provider);
        action = new ClasspathModifierAction(op, JavaPluginImages.DESC_ELCL_CONFIGURE_OUTPUT_FOLDER, JavaPluginImages.DESC_DLCL_CONFIGURE_OUTPUT_FOLDER, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_tooltip, 1);
        dropDown.addAction(action);
        op = new LinkedSourceFolderOperation(listener, provider);
        this.addAction(new ClasspathModifierAction(op, JavaPluginImages.DESC_ELCL_ADD_LINKED_SOURCE_TO_BUILDPATH, JavaPluginImages.DESC_DLCL_ADD_LINKED_SOURCE_TO_BUILDPATH, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip, 1), 5);
        op = new ResetAllOperation(listener, provider);
        this.addAction(new ClasspathModifierAction(op, JavaPluginImages.DESC_ELCL_CLEAR, JavaPluginImages.DESC_DLCL_CLEAR, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip, 1), 6);
    }

    private void addAction(ClasspathModifierAction action, int index) {
        this.fActions[index] = action;
    }

    public ClasspathModifierAction getAction(int type) {
        return this.fActions[type];
    }

    public void showOutputFolders(boolean showOutputFolders) {
        ClasspathModifierDropDownAction action = (ClasspathModifierDropDownAction)this.getAction(4);
        EditOutputFolderOperation operation = (EditOutputFolderOperation)action.getActions()[1].getOperation();
        operation.showOutputFolders(showOutputFolders);
    }

    public ToolBarManager createLeftToolBarManager(ViewerPane pane) {
        ToolBarManager tbm = pane.getToolBarManager();
        int i = 0;
        while (i < 5) {
            tbm.add((IAction)this.fActions[i]);
            if (i == 1 || i == 3) {
                tbm.add((IContributionItem)new Separator());
            }
            ++i;
        }
        tbm.update(true);
        return tbm;
    }

    public ToolBarManager createLeftToolBar(ViewerPane pane) {
        ToolBar tb = new ToolBar((Composite)pane, 0x800000);
        pane.setTopRight((Control)tb);
        ToolBarManager tbm = new ToolBarManager(tb);
        int i = 5;
        while (i < this.fActions.length) {
            if (i != 7) {
                tbm.add((IAction)this.fActions[i]);
            }
            ++i;
        }
        tbm.add((IAction)new HelpAction());
        tbm.update(true);
        return tbm;
    }

    public void refresh(DialogExplorerActionContext context) throws JavaModelException {
        super.setContext(context);
        if (context == null) {
            return;
        }
        List selectedElements = context.getSelectedElements();
        IJavaProject project = context.getJavaProject();
        int type = 17;
        if (selectedElements.size() == 0) {
            type = 18;
            if (type == this.fLastType) {
                return;
            }
        } else if (selectedElements.size() == 1 || this.identicalTypes(selectedElements, project)) {
            type = DialogPackageExplorerActionGroup.getType(selectedElements.get(0), project);
        }
        this.internalSetContext(selectedElements, project, type);
    }

    public void setContext(ActionContext context) {
        try {
            this.setContext((DialogExplorerActionContext)context);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    public void setContext(DialogExplorerActionContext context) throws JavaModelException {
        super.setContext(context);
        if (context == null) {
            return;
        }
        List selectedElements = context.getSelectedElements();
        IJavaProject project = context.getJavaProject();
        int type = 17;
        if (selectedElements.size() == 0) {
            type = 18;
            if (type == this.fLastType) {
                return;
            }
        } else if (selectedElements.size() == 1 || this.identicalTypes(selectedElements, project)) {
            type = DialogPackageExplorerActionGroup.getType(selectedElements.get(0), project);
            if (selectedElements.size() > 1) {
                type |= 0x11;
            }
            if (type == this.fLastType) {
                return;
            }
        }
        this.internalSetContext(selectedElements, project, type);
    }

    public String getNoActionDescription() {
        String[] description = this.noAction(this.fLastType);
        return description[0];
    }

    private void internalSetContext(List selectedElements, IJavaProject project, int type) throws JavaModelException {
        this.fLastType = type;
        List availableActions = this.getAvailableActions(selectedElements, project);
        ClasspathModifierAction[] actions = new ClasspathModifierAction[availableActions.size()];
        String[] descriptions = new String[availableActions.size()];
        if (availableActions.size() > 0) {
            int i = 0;
            while (i < availableActions.size()) {
                ClasspathModifierAction action;
                actions[i] = action = (ClasspathModifierAction)((Object)availableActions.get(i));
                descriptions[i] = action.getDescription(type);
                ++i;
            }
        } else {
            descriptions = this.noAction(type);
        }
        this.informListeners(descriptions, actions);
    }

    private boolean identicalTypes(List elements, IJavaProject project) throws JavaModelException {
        if (elements.size() == 0) {
            return false;
        }
        Object firstElement = elements.get(0);
        int firstType = DialogPackageExplorerActionGroup.getType(firstElement, project);
        int i = 1;
        while (i < elements.size()) {
            if (firstType != DialogPackageExplorerActionGroup.getType(elements.get(i), project)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void informListeners(String[] descriptions, ClasspathModifierAction[] actions) {
        Iterator iterator = this.fListeners.iterator();
        PackageExplorerActionEvent event = new PackageExplorerActionEvent(descriptions, actions);
        while (iterator.hasNext()) {
            IPackageExplorerActionListener listener = (IPackageExplorerActionListener)iterator.next();
            listener.handlePackageExplorerActionEvent(event);
        }
    }

    private String[] noAction(int type) {
        String reason;
        switch (type) {
            case 5: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_File;
                break;
            }
            case 21: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_File;
                break;
            }
            case 15: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_DefaultPackage;
                break;
            }
            case 31: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_DefaultPackage;
                break;
            }
            case 18: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_NullSelection;
                break;
            }
            case 17: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_MultiSelection;
                break;
            }
            case 19: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_ArchiveResource;
                break;
            }
            default: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_NoReason;
            }
        }
        return new String[]{reason};
    }

    public static int getType(Object obj, IJavaProject project) throws JavaModelException {
        if (obj instanceof IJavaProject) {
            return 1;
        }
        if (obj instanceof ClassPathContainer) {
            return 20;
        }
        if (obj instanceof IPackageFragmentRoot) {
            return ClasspathModifier.filtersSet((IPackageFragmentRoot)obj) ? 14 : 2;
        }
        if (obj instanceof IPackageFragment) {
            if (ClasspathModifier.isDefaultFragment((IPackageFragment)obj)) {
                if (((IPackageFragmentRoot)((IJavaElement)obj).getAncestor(3)).isArchive()) {
                    return 19;
                }
                return 15;
            }
            if (ClasspathModifier.isIncluded((IJavaElement)obj, project, null)) {
                return 11;
            }
            if (((IPackageFragmentRoot)((IJavaElement)obj).getAncestor(3)).isArchive()) {
                return 19;
            }
            return 3;
        }
        if (obj instanceof ICompilationUnit) {
            if (((IPackageFragmentRoot)((IJavaElement)obj).getAncestor(3)).isArchive()) {
                return 19;
            }
            return ClasspathModifier.isIncluded((IJavaElement)obj, project, null) ? 10 : 4;
        }
        if (obj instanceof IFolder) {
            return DialogPackageExplorerActionGroup.getFolderType((IFolder)obj, project);
        }
        if (obj instanceof IFile) {
            return DialogPackageExplorerActionGroup.getFileType((IFile)obj, project);
        }
        if (obj instanceof IClassFile) {
            return 5;
        }
        if (obj instanceof CPListElementAttribute) {
            return ClasspathModifier.isDefaultOutputFolder((CPListElementAttribute)obj) ? 9 : 12;
        }
        return 16;
    }

    private static int getFolderType(IFolder folder, IJavaProject project) throws JavaModelException {
        IContainer folderParent = folder.getParent();
        if (folderParent.getFullPath().equals((Object)project.getPath())) {
            return 6;
        }
        if (ClasspathModifier.getFragment((IResource)folderParent) != null) {
            return 7;
        }
        IPackageFragmentRoot fragmentRoot = ClasspathModifier.getFragmentRoot((IResource)folder, project, null);
        if (fragmentRoot == null) {
            return 6;
        }
        if (fragmentRoot.equals(JavaCore.create((IResource)folderParent))) {
            return 7;
        }
        return 6;
    }

    private static int getFileType(IFile file, IJavaProject project) throws JavaModelException {
        if (ClasspathModifier.isArchive(file, project)) {
            return 13;
        }
        if (!file.getName().endsWith(".java")) {
            return 5;
        }
        IContainer fileParent = file.getParent();
        if (fileParent.getFullPath().equals((Object)project.getPath())) {
            if (project.isOnClasspath((IJavaElement)project)) {
                return 8;
            }
            return 5;
        }
        IPackageFragmentRoot fragmentRoot = ClasspathModifier.getFragmentRoot((IResource)file, project, null);
        if (fragmentRoot == null) {
            return 5;
        }
        if (fragmentRoot.isArchive()) {
            return 19;
        }
        if (fragmentRoot.equals(JavaCore.create((IResource)fileParent))) {
            return 8;
        }
        if (ClasspathModifier.getFragment((IResource)fileParent) == null) {
            if (ClasspathModifier.parentExcluded((IResource)fileParent, project)) {
                return 5;
            }
            return 8;
        }
        return 8;
    }

    private List getAvailableActions(List selectedElements, IJavaProject project) throws JavaModelException {
        if (project == null || !project.exists()) {
            return new ArrayList();
        }
        ArrayList<ClasspathModifierAction> actions = new ArrayList<ClasspathModifierAction>();
        int[] types = new int[selectedElements.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = DialogPackageExplorerActionGroup.getType(selectedElements.get(i), project);
            ++i;
        }
        i = 0;
        while (i < this.fActions.length) {
            if (this.fActions[i] instanceof ClasspathModifierDropDownAction) {
                if (this.changeEnableState(this.fActions[i], selectedElements, types)) {
                    ClasspathModifierAction[] dropDownActions = ((ClasspathModifierDropDownAction)this.fActions[i]).getActions();
                    int j = 0;
                    while (j < dropDownActions.length) {
                        if (this.changeEnableState(dropDownActions[j], selectedElements, types)) {
                            actions.add(dropDownActions[j]);
                        }
                        ++j;
                    }
                }
            } else if (this.changeEnableState(this.fActions[i], selectedElements, types)) {
                actions.add(this.fActions[i]);
            }
            ++i;
        }
        return actions;
    }

    private boolean changeEnableState(ClasspathModifierAction action, List selectedElements, int[] types) throws JavaModelException {
        if (action.isValid(selectedElements, types)) {
            if (!action.isEnabled()) {
                action.setEnabled(true);
            }
            return true;
        }
        if (action.isEnabled()) {
            action.setEnabled(false);
        }
        return false;
    }

    public void fillContextMenu(IMenuManager menu) {
        int i = 0;
        while (i < 5) {
            ClasspathModifierAction action = this.getAction(i);
            if (action instanceof ClasspathModifierDropDownAction) {
                if (action.isEnabled()) {
                    ClasspathModifierAction[] actions = ((ClasspathModifierDropDownAction)action).getActions();
                    int j = 0;
                    while (j < actions.length) {
                        if (actions[j].isEnabled()) {
                            menu.add((IAction)actions[j]);
                        }
                        ++j;
                    }
                }
            } else if (action.isEnabled()) {
                menu.add((IAction)action);
            }
            ++i;
        }
        super.fillContextMenu(menu);
    }

    public void addListener(IPackageExplorerActionListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(IPackageExplorerActionListener listener) {
        this.fListeners.remove(listener);
    }

    public void dispose() {
        this.fListeners.clear();
        super.dispose();
    }

    public static class DialogExplorerActionContext
    extends ActionContext {
        private IJavaProject fJavaProject;
        private List fSelectedElements;

        public DialogExplorerActionContext(ISelection selection, IJavaProject jProject) {
            super(null);
            this.fJavaProject = jProject;
            this.fSelectedElements = ((IStructuredSelection)selection).toList();
            StructuredSelection structuredSelection = new StructuredSelection(new Object[]{this.fSelectedElements, jProject});
            super.setSelection((ISelection)structuredSelection);
        }

        public DialogExplorerActionContext(List selectedElements, IJavaProject jProject) {
            super(null);
            this.fJavaProject = jProject;
            this.fSelectedElements = selectedElements;
            StructuredSelection structuredSelection = new StructuredSelection(new Object[]{this.fSelectedElements, jProject});
            super.setSelection((ISelection)structuredSelection);
        }

        public IJavaProject getJavaProject() {
            return this.fJavaProject;
        }

        public List getSelectedElements() {
            return this.fSelectedElements;
        }
    }
}

