/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDEActionFactory;

public abstract class OpenCloseWorkingSetAction
extends SelectionDispatchAction
implements IResourceChangeListener {
    private OpenCloseWorkingSetAction(IWorkbenchSite site, String label) {
        super(site);
        this.setText(label);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public static OpenCloseWorkingSetAction createCloseAction(IWorkbenchSite site) {
        return new CloseWorkingSetAction(site, WorkingSetMessages.OpenCloseWorkingSetAction_close_label);
    }

    public static OpenCloseWorkingSetAction createOpenAction(IWorkbenchSite site) {
        return new OpenWorkingSetAction(site, WorkingSetMessages.OpenCloseWorkingSetAction_open_label);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void selectionChanged(IStructuredSelection selection) {
        List projects = this.getProjects(selection);
        IActionBars actionBars = this.getActionBars();
        if (projects != null && projects.size() > 0) {
            this.setEnabled(true);
            if (actionBars != null) {
                this.connectToActionBar(actionBars);
            }
        } else {
            this.setEnabled(false);
            if (actionBars != null) {
                this.disconnectFromActionBar(actionBars);
            }
        }
    }

    public void run(IStructuredSelection selection) {
        final List projects = this.getProjects(selection);
        if (projects != null && projects.size() > 0) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        monitor.beginTask("", projects.size());
                        Iterator iter = projects.iterator();
                        while (iter.hasNext()) {
                            IProject project = (IProject)iter.next();
                            OpenCloseWorkingSetAction.this.performOperation(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        monitor.done();
                    }
                }));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), this.getErrorTitle(), this.getErrorMessage());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected abstract boolean validate(IProject var1);

    protected abstract void performOperation(IProject var1, IProgressMonitor var2) throws CoreException;

    protected abstract void connectToActionBar(IActionBars var1);

    protected abstract void disconnectFromActionBar(IActionBars var1);

    protected abstract String getErrorTitle();

    protected abstract String getErrorMessage();

    private List getProjects(IStructuredSelection selection) {
        ArrayList result = new ArrayList();
        List elements = selection.toList();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IWorkingSet)) {
                return null;
            }
            List projects = this.getProjects((IWorkingSet)element);
            if (projects == null) {
                return null;
            }
            result.addAll(projects);
        }
        return result;
    }

    private List getProjects(IWorkingSet set) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            IAdaptable element = elements[i];
            IProject project = null;
            if (element instanceof IProject) {
                project = (IProject)element;
            } else if (element instanceof IJavaProject) {
                project = ((IJavaProject)element).getProject();
            }
            if (project == null || !this.validate(project)) {
                return null;
            }
            result.add(project);
            ++i;
        }
        return result;
    }

    protected IActionBars getActionBars() {
        if (this.getSite() instanceof IViewSite) {
            return ((IViewSite)this.getSite()).getActionBars();
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) != 0) {
                    Shell shell = this.getShell();
                    if (!shell.isDisposed()) {
                        shell.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                OpenCloseWorkingSetAction.this.update(OpenCloseWorkingSetAction.this.getSelection());
                            }
                        });
                    }
                    return;
                }
                ++i;
            }
        }
    }

    /* synthetic */ OpenCloseWorkingSetAction(IWorkbenchSite iWorkbenchSite, String string, OpenCloseWorkingSetAction openCloseWorkingSetAction) {
        this(iWorkbenchSite, string);
    }

    private static final class CloseWorkingSetAction
    extends OpenCloseWorkingSetAction {
        private IAction fProjectAction;

        CloseWorkingSetAction(IWorkbenchSite site, String label) {
            super(site, label, null);
            IActionBars actionBars = this.getActionBars();
            if (actionBars != null) {
                this.fProjectAction = actionBars.getGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId());
            }
        }

        protected boolean validate(IProject project) {
            return project.isOpen();
        }

        protected void performOperation(IProject project, IProgressMonitor monitor) throws CoreException {
            project.close(monitor);
        }

        protected void connectToActionBar(IActionBars actionBars) {
            actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this);
            actionBars.updateActionBars();
        }

        protected void disconnectFromActionBar(IActionBars actionBars) {
            actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), this.fProjectAction);
            actionBars.updateActionBars();
        }

        protected String getErrorTitle() {
            return WorkingSetMessages.OpenCloseWorkingSetAction_close_error_title;
        }

        protected String getErrorMessage() {
            return WorkingSetMessages.OpenCloseWorkingSetAction_close_error_message;
        }
    }

    private static final class OpenWorkingSetAction
    extends OpenCloseWorkingSetAction {
        private IAction fProjectAction;

        OpenWorkingSetAction(IWorkbenchSite site, String label) {
            super(site, label, null);
            IActionBars actionBars = this.getActionBars();
            if (actionBars != null) {
                this.fProjectAction = actionBars.getGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId());
            }
        }

        protected boolean validate(IProject project) {
            return !project.isOpen();
        }

        protected void performOperation(IProject project, IProgressMonitor monitor) throws CoreException {
            project.open(monitor);
        }

        protected void connectToActionBar(IActionBars actionBars) {
            actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this);
            actionBars.updateActionBars();
        }

        protected void disconnectFromActionBar(IActionBars actionBars) {
            actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), this.fProjectAction);
            actionBars.updateActionBars();
        }

        protected String getErrorTitle() {
            return WorkingSetMessages.OpenCloseWorkingSetAction_open_error_title;
        }

        protected String getErrorMessage() {
            return WorkingSetMessages.OpenCloseWorkingSetAction_open_error_message;
        }
    }
}

