/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import java.io.Reader;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;

public class JavadocContentAccess {
    private JavadocContentAccess() {
    }

    public static Reader getContentReader(IMember member, boolean allowInherited) throws JavaModelException {
        IBuffer buf;
        IBuffer iBuffer = buf = member.isBinary() ? member.getClassFile().getBuffer() : member.getCompilationUnit().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange range = member.getSourceRange();
        int start = range.getOffset();
        int length = range.getLength();
        if (length > 0 && buf.getChar(start) == '/') {
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(buf.getCharacters());
            scanner.resetTo(start, start + length - 1);
            try {
                int docOffset = -1;
                int docEnd = -1;
                int terminal = scanner.getNextToken();
                while (TokenScanner.isComment(terminal)) {
                    if (terminal == 1003) {
                        docOffset = scanner.getCurrentTokenStartPosition();
                        docEnd = scanner.getCurrentTokenEndPosition() + 1;
                    }
                    terminal = scanner.getNextToken();
                }
                if (docOffset != -1) {
                    return new JavaDocCommentReader(buf, docOffset, docEnd);
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        if (allowInherited && member.getElementType() == 9) {
            IMethod method = (IMethod)member;
            return JavadocContentAccess.findDocInHierarchy(method.getDeclaringType(), method.getElementName(), method.getParameterTypes(), method.isConstructor());
        }
        return null;
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited) throws JavaModelException {
        Reader contentReader = JavadocContentAccess.getContentReader(member, allowInherited);
        if (contentReader != null) {
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        return null;
    }

    private static Reader findDocInHierarchy(IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            Reader reader;
            IMethod method = JavaModelUtil.findMethod(name, paramTypes, isConstructor, superTypes[i]);
            if (method != null && (reader = JavadocContentAccess.getContentReader((IMember)method, false)) != null) {
                return reader;
            }
            ++i;
        }
        return null;
    }
}

