/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.nls.ExternalizeWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class ExternalizeStringsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public ExternalizeStringsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.ExternalizeStringsAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.externalize_strings_action");
    }

    public ExternalizeStringsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(RefactoringAvailabilityTester.isExternalizeStringsAvailable(selection));
    }

    public void run(ITextSelection selection) {
        IJavaElement element = SelectionConverter.getInput(this.fEditor);
        if (!(element instanceof ICompilationUnit)) {
            return;
        }
        this.run((ICompilationUnit)element);
    }

    public void run(IStructuredSelection selection) {
        if (RefactoringAvailabilityTester.isExternalizeStringsAvailable(selection)) {
            this.run(ExternalizeStringsAction.getCompilationUnit(selection));
        }
    }

    public void run(final ICompilationUnit unit) {
        if (!ActionUtil.isProcessable(this.getShell(), unit)) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    NLSRefactoring refactoring;
                    if (unit != null && unit.exists() && (refactoring = NLSRefactoring.create(unit)) != null) {
                        new RefactoringStarter().activate(refactoring, new ExternalizeWizard(refactoring), ExternalizeStringsAction.this.getShell(), ActionMessages.ExternalizeStringsAction_dialog_title, true);
                    }
                }
                catch (JavaModelException e) {
                    ExceptionHandler.handle((CoreException)((Object)e), ExternalizeStringsAction.this.getShell(), ActionMessages.ExternalizeStringsAction_dialog_title, ActionMessages.ExternalizeStringsAction_dialog_message);
                }
            }
        });
    }

    private static ICompilationUnit getCompilationUnit(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof ICompilationUnit) {
            return (ICompilationUnit)first;
        }
        if (first instanceof IType) {
            return ((IType)first).getCompilationUnit();
        }
        return null;
    }
}

