/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindDeclarationsAction;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class FindDeclarationsInWorkingSetAction
extends FindDeclarationsAction {
    private IWorkingSet[] fWorkingSet;

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site) {
        this(site, null);
    }

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        super(site);
        this.fWorkingSet = workingSets;
    }

    public FindDeclarationsInWorkingSetAction(JavaEditor editor) {
        this(editor, null);
    }

    public FindDeclarationsInWorkingSetAction(JavaEditor editor, IWorkingSet[] workingSets) {
        super(editor);
        this.fWorkingSet = workingSets;
    }

    void init() {
        this.setText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.find_declarations_in_working_set_action");
    }

    protected JavaSearchQuery createJob(IJavaElement element) throws JavaModelException {
        IWorkingSet[] workingSets = this.fWorkingSet;
        if (this.fWorkingSet == null && (workingSets = JavaSearchScopeFactory.getInstance().queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        return new JavaSearchQuery(new ElementQuerySpecification(element, this.getLimitTo(), this.getScope(workingSets), this.getScopeDescription(workingSets)));
    }

    private IJavaSearchScope getScope(IWorkingSet[] workingSets) {
        return JavaSearchScopeFactory.getInstance().createJavaSearchScope(workingSets, true);
    }

    private String getScopeDescription(IWorkingSet[] workingSets) {
        return Messages.format(SearchMessages.WorkingSetScope, new String[]{SearchUtil.toString(workingSets)});
    }
}

