/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.MinimalState;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEStateHelper;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PDEState
extends MinimalState {
    private URL[] fWorkspaceURLs;
    private URL[] fTargetURLs;
    private IProgressMonitor fMonitor;
    private Map fPluginInfos;
    private Map fExtensions;
    private Dictionary fPlatformProperties;
    private TreeMap fTargetModels = new TreeMap();
    private ArrayList fWorkspaceModels = new ArrayList();
    private boolean fCombined;
    private long fTargetTimestamp;
    private boolean fResolve = true;
    private boolean fNewState;

    public PDEState(URL[] urls, boolean resolve, IProgressMonitor monitor) {
        this(new URL[0], urls, resolve, TargetPlatform.getTargetEnvironment(), monitor);
    }

    public PDEState(URL[] workspace, URL[] target, boolean resolve, Dictionary properties, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        this.fResolve = resolve;
        this.fWorkspaceURLs = workspace;
        this.fTargetURLs = target;
        this.fMonitor = monitor;
        this.fPlatformProperties = properties;
        this.setTargetMode(target);
        if (this.fResolve) {
            this.readTargetState();
        } else {
            this.createNewTargetState();
            this.createExtensionDocument();
        }
        this.fState.setResolver(Platform.getPlatformAdmin().getResolver());
        this.fState.setPlatformProperties(this.fPlatformProperties);
        this.resolveState(false);
        if (this.fResolve) {
            this.logResolutionErrors();
        }
        this.createTargetModels();
        if (this.fResolve && workspace.length > 0 && !this.fNewState && !"true".equals(System.getProperty("pde.nocache"))) {
            this.readWorkspaceState();
        }
        if (DEBUG) {
            System.out.println("Time to create state: " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private void readTargetState() {
        this.fTargetTimestamp = this.computeTimestamp(this.fTargetURLs);
        File dir = new File(DIR, String.valueOf(Long.toString(this.fTargetTimestamp)) + ".target");
        this.fState = this.readStateCache(dir);
        if (this.fState == null || (this.fPluginInfos = this.readPluginInfoCache(dir)) == null) {
            this.createNewTargetState();
            this.saveState(dir);
            this.savePluginInfo(dir);
            this.fNewState = true;
        } else {
            this.fId = this.fState.getBundles().length;
        }
        this.fExtensions = this.readExtensionsCache(dir);
        if (this.fExtensions == null) {
            this.saveExtensions(dir);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createNewTargetState() {
        this.fState = stateObjectFactory.createState();
        this.fPluginInfos = new HashMap();
        this.fMonitor.beginTask(PDECoreMessages.PDEState_readingPlugins, this.fTargetURLs.length);
        int i = 0;
        while (i < this.fTargetURLs.length) {
            Object var3_3;
            try {
                try {
                    File file = new File(this.fTargetURLs[i].getFile());
                    this.fMonitor.subTask(file.getName());
                    this.addBundle(file, true, -1L);
                }
                catch (PluginConversionException pluginConversionException) {
                }
                catch (CoreException coreException) {}
            }
            catch (Throwable throwable) {
                var3_3 = null;
                this.fMonitor.worked(1);
                throw throwable;
            }
            {
                var3_3 = null;
            }
            this.fMonitor.worked(1);
            ++i;
        }
        return;
    }

    private void createTargetModels() {
        BundleDescription[] bundleDescriptions = this.fResolve ? this.fState.getResolvedBundles() : this.fState.getBundles();
        int i = 0;
        while (i < bundleDescriptions.length) {
            BundleDescription desc = bundleDescriptions[i];
            this.fMonitor.subTask(bundleDescriptions[i].getSymbolicName());
            this.fTargetModels.put(desc.getSymbolicName(), this.createExternalModel(desc));
            this.fExtensions.remove(Long.toString(desc.getBundleId()));
            this.fPluginInfos.remove(Long.toString(desc.getBundleId()));
            ++i;
        }
    }

    private void readWorkspaceState() {
        long workspace = this.computeTimestamp(this.fWorkspaceURLs);
        File dir = new File(DIR, String.valueOf(Long.toString(workspace)) + ".workspace");
        State localState = this.readStateCache(dir);
        Map localPluginInfos = this.readPluginInfoCache(dir);
        Map localExtensions = this.readExtensionsCache(dir);
        boolean bl = this.fCombined = localState != null && localPluginInfos != null && localExtensions != null;
        if (this.fCombined) {
            String key;
            Iterator iter = localPluginInfos.keySet().iterator();
            while (iter.hasNext()) {
                key = iter.next().toString();
                this.fPluginInfos.put(key, localPluginInfos.get(key));
            }
            iter = localExtensions.keySet().iterator();
            while (iter.hasNext()) {
                key = iter.next().toString();
                this.fExtensions.put(key, localExtensions.get(key));
            }
            BundleDescription[] bundles = localState.getBundles();
            int i = 0;
            while (i < bundles.length) {
                BundleDescription desc = bundles[i];
                String id = desc.getSymbolicName();
                BundleDescription[] conflicts = this.fState.getBundles(id);
                int j = 0;
                while (j < conflicts.length) {
                    this.fState.removeBundle(conflicts[j]);
                    ++j;
                }
                BundleDescription newbundle = stateObjectFactory.createBundleDescription(desc);
                IPluginModelBase model = this.createWorkspaceModel(newbundle);
                if (model != null && this.fState.addBundle(newbundle)) {
                    this.fId = Math.max(this.fId, newbundle.getBundleId());
                    this.fWorkspaceModels.add(model);
                }
                this.fExtensions.remove(Long.toString(newbundle.getBundleId()));
                this.fPluginInfos.remove(Long.toString(newbundle.getBundleId()));
                ++i;
            }
            this.fId = Math.max(this.fId, (long)this.fState.getBundles().length);
            this.fState.resolve(true);
        }
    }

    public boolean isCombined() {
        return this.fCombined;
    }

    public BundleDescription addBundle(Dictionary manifest, File bundleLocation, boolean keepLibraries, long bundleId) {
        BundleDescription desc = super.addBundle(manifest, bundleLocation, keepLibraries, bundleId);
        if (desc != null && keepLibraries) {
            this.createPluginInfo(desc, manifest);
        }
        return desc;
    }

    private void createPluginInfo(BundleDescription desc, Dictionary manifest) {
        PluginInfo info = new PluginInfo();
        info.name = (String)manifest.get("Bundle-Name");
        info.providerName = (String)manifest.get("Bundle-Vendor");
        String className = (String)manifest.get("Plugin-Class");
        info.className = className != null ? className : (String)manifest.get("Bundle-Activator");
        info.libraries = PDEStateHelper.getClasspath(manifest);
        info.hasExtensibleAPI = "true".equals(manifest.get("Eclipse-ExtensibleAPI"));
        this.fPluginInfos.put(Long.toString(desc.getBundleId()), info);
    }

    private void createPluginInfo(Map map, Element element) {
        PluginInfo info = new PluginInfo();
        info.name = element.getAttribute("name");
        info.providerName = element.getAttribute("provider");
        info.className = element.getAttribute("class");
        info.hasExtensibleAPI = "true".equals(element.getAttribute("hasExtensibleAPI"));
        info.project = element.getAttribute("project");
        info.legacy = "true".equals(element.getAttribute("legacy"));
        NodeList libs = element.getChildNodes();
        ArrayList<String> list = new ArrayList<String>(libs.getLength());
        int i = 0;
        while (i < libs.getLength()) {
            if (libs.item(i).getNodeType() == 1) {
                Element lib = (Element)libs.item(i);
                list.add(lib.getAttribute("name"));
            }
            ++i;
        }
        info.libraries = list.toArray(new String[list.size()]);
        map.put(element.getAttribute("bundleID"), info);
    }

    private Document createExtensionDocument() {
        this.fExtensions = new HashMap();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        Element root = doc.createElement("extensions");
        BundleDescription[] bundles = this.fState.getBundles();
        int i = 0;
        while (i < bundles.length) {
            BundleDescription desc = bundles[i];
            Element element = doc.createElement("bundle");
            element.setAttribute("bundleID", Long.toString(desc.getBundleId()));
            PDEStateHelper.parseExtensions(desc, element);
            if (element.hasChildNodes()) {
                root.appendChild(element);
                this.fExtensions.put(Long.toString(desc.getBundleId()), element);
            }
            ++i;
        }
        doc.appendChild(root);
        return doc;
    }

    private void savePluginInfo(File dir) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            Element root = doc.createElement("map");
            Iterator iter = this.fPluginInfos.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                Element element = doc.createElement("bundle");
                element.setAttribute("bundleID", key);
                PluginInfo info = (PluginInfo)this.fPluginInfos.get(key);
                if (info.className != null) {
                    element.setAttribute("class", info.className);
                }
                if (info.providerName != null) {
                    element.setAttribute("provider", info.providerName);
                }
                if (info.name != null) {
                    element.setAttribute("name", info.name);
                }
                if (info.hasExtensibleAPI) {
                    element.setAttribute("hasExtensibleAPI", "true");
                }
                if (info.libraries != null) {
                    int i = 0;
                    while (i < info.libraries.length) {
                        Element lib = doc.createElement("library");
                        lib.setAttribute("name", info.libraries[i]);
                        element.appendChild(lib);
                        ++i;
                    }
                }
                root.appendChild(element);
            }
            doc.appendChild(root);
            XMLPrintHandler.writeFile(doc, new File(dir, ".pluginInfo"));
        }
        catch (Exception e) {
            PDECore.log(e);
        }
    }

    private void saveExtensions(File dir) {
        try {
            File file = new File(dir, ".extensions");
            XMLPrintHandler.writeFile(this.createExtensionDocument(), file);
        }
        catch (IOException iOException) {}
    }

    private Map readExtensionsCache(File dir) {
        long start = System.currentTimeMillis();
        File file = new File(dir, ".extensions");
        if (file.exists() && file.isFile()) {
            try {
                HashMap<String, NodeList> map = new HashMap<String, NodeList>();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().parse(file);
                Element root = doc.getDocumentElement();
                if (root != null) {
                    NodeList bundles = root.getChildNodes();
                    int i = 0;
                    while (i < bundles.getLength()) {
                        if (bundles.item(i).getNodeType() == 1) {
                            Element bundle = (Element)bundles.item(i);
                            String id = bundle.getAttribute("bundleID");
                            map.put(id, bundle.getChildNodes());
                        }
                        ++i;
                    }
                }
                if (DEBUG) {
                    System.out.println("Time to read extensions: " + (System.currentTimeMillis() - start) + " ms");
                }
                return map;
            }
            catch (SAXException e) {
                PDECore.log(e);
            }
            catch (IOException e) {
                PDECore.log(e);
            }
            catch (ParserConfigurationException e) {
                PDECore.log(e);
            }
        }
        return null;
    }

    private Map readPluginInfoCache(File dir) {
        File file = new File(dir, ".pluginInfo");
        if (file.exists() && file.isFile()) {
            try {
                HashMap map = new HashMap();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().parse(file);
                Element root = doc.getDocumentElement();
                if (root != null) {
                    NodeList list = root.getChildNodes();
                    int i = 0;
                    while (i < list.getLength()) {
                        if (list.item(i).getNodeType() == 1) {
                            this.createPluginInfo(map, (Element)list.item(i));
                        }
                        ++i;
                    }
                }
                return map;
            }
            catch (SAXException e) {
                PDECore.log(e);
            }
            catch (IOException e) {
                PDECore.log(e);
            }
            catch (ParserConfigurationException e) {
                PDECore.log(e);
            }
        }
        return null;
    }

    private State readStateCache(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            try {
                return stateObjectFactory.readState(dir);
            }
            catch (IllegalStateException e) {
                PDECore.log(e);
            }
            catch (FileNotFoundException e) {
                PDECore.log(e);
            }
            catch (IOException e) {
                PDECore.log(e);
            }
        }
        return null;
    }

    private long computeTimestamp(URL[] urls) {
        long timestamp = 0L;
        int i = 0;
        while (i < urls.length) {
            File file = new File(urls[i].getFile());
            if (file.exists()) {
                if (file.isFile()) {
                    timestamp ^= file.lastModified();
                } else {
                    File manifest = new File(file, "META-INF/MANIFEST.MF");
                    if (manifest.exists()) {
                        timestamp ^= manifest.lastModified();
                    }
                    if ((manifest = new File(file, "plugin.xml")).exists()) {
                        timestamp ^= manifest.lastModified();
                    }
                    if ((manifest = new File(file, "fragment.xml")).exists()) {
                        timestamp ^= manifest.lastModified();
                    }
                }
                timestamp ^= (long)file.getAbsolutePath().hashCode();
            }
            ++i;
        }
        return timestamp;
    }

    private IPluginModelBase createWorkspaceModel(BundleDescription desc) {
        String projectName = this.getProject(desc.getBundleId());
        IProject project = PDECore.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            return null;
        }
        if (WorkspaceModelManager.hasBundleManifest(project)) {
            BundlePluginModelBase model = null;
            model = desc.getHost() == null ? new BundlePluginModel() : new BundleFragmentModel();
            model.setEnabled(true);
            WorkspaceBundleModel bundle = new WorkspaceBundleModel(project.getFile("META-INF/MANIFEST.MF"));
            bundle.load(desc, this);
            model.setBundleDescription(desc);
            model.setBundleModel(bundle);
            String filename = desc.getHost() == null ? "plugin.xml" : "fragment.xml";
            IFile file = project.getFile(filename);
            if (file.exists()) {
                WorkspaceExtensionsModel extensions = new WorkspaceExtensionsModel(file);
                extensions.load(desc, this);
                extensions.setBundleModel(model);
                model.setExtensionsModel(extensions);
            }
            return model;
        }
        WorkspacePluginModelBase model = null;
        model = desc.getHost() == null ? new WorkspacePluginModel(project.getFile("plugin.xml"), true) : new WorkspaceFragmentModel(project.getFile("fragment.xml"), true);
        model.load(desc, this, false);
        model.setBundleDescription(desc);
        return model;
    }

    private IPluginModelBase createExternalModel(BundleDescription desc) {
        ExternalPluginModelBase model = null;
        model = desc.getHost() == null ? new ExternalPluginModel() : new ExternalFragmentModel();
        model.load(desc, this, !this.fResolve);
        model.setBundleDescription(desc);
        return model;
    }

    public IPluginModelBase[] getTargetModels() {
        return this.fTargetModels.values().toArray(new IPluginModelBase[this.fTargetModels.size()]);
    }

    public IPluginModelBase[] getWorkspaceModels() {
        return this.fWorkspaceModels.toArray(new IPluginModelBase[this.fWorkspaceModels.size()]);
    }

    public IPluginModelBase[] getModels() {
        IPluginModelBase[] workspace = this.getWorkspaceModels();
        IPluginModelBase[] target = this.getTargetModels();
        IPluginModelBase[] all = new IPluginModelBase[workspace.length + target.length];
        if (workspace.length > 0) {
            System.arraycopy(workspace, 0, all, 0, workspace.length);
        }
        if (target.length > 0) {
            System.arraycopy(target, 0, all, workspace.length, target.length);
        }
        return all;
    }

    public String getClassName(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? null : info.className;
    }

    public boolean hasExtensibleAPI(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? false : info.hasExtensibleAPI;
    }

    public boolean isLegacy(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? false : info.legacy;
    }

    public String getPluginName(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? null : info.name;
    }

    public String getProviderName(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? null : info.providerName;
    }

    public String[] getLibraryNames(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? new String[]{} : info.libraries;
    }

    public String getProject(long bundleID) {
        PluginInfo info = (PluginInfo)this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? null : info.project;
    }

    public Node[] getExtensions(long bundleID) {
        return this.getChildren(bundleID, "extension");
    }

    public Node[] getExtensionPoints(long bundleID) {
        return this.getChildren(bundleID, "extension-point");
    }

    private Node[] getChildren(long bundleID, String tagName) {
        Element bundle;
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.fExtensions != null && (bundle = (Element)this.fExtensions.get(Long.toString(bundleID))) != null) {
            NodeList children = bundle.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (tagName.equals(children.item(i).getNodeName())) {
                    list.add(children.item(i));
                }
                ++i;
            }
        }
        return list.toArray(new Node[list.size()]);
    }

    public Node[] getAllExtensions(long bundleID) {
        Element bundle;
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.fExtensions != null && (bundle = (Element)this.fExtensions.get(Long.toString(bundleID))) != null) {
            NodeList children = bundle.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                String name = children.item(i).getNodeName();
                if ("extension".equals(name) || "extension-point".equals(name)) {
                    list.add(children.item(i));
                }
                ++i;
            }
        }
        return list.toArray(new Node[list.size()]);
    }

    public void shutdown() {
        IPluginModelBase[] models = PDECore.getDefault().getModelManager().getWorkspaceModels();
        long timestamp = 0L;
        if (!"true".equals(System.getProperty("pde.nocache")) && this.shouldSaveState(models)) {
            timestamp = this.computeTimestamp(models);
            File dir = new File(DIR, String.valueOf(Long.toString(timestamp)) + ".workspace");
            State state = stateObjectFactory.createState();
            int i = 0;
            while (i < models.length) {
                state.addBundle(models[i].getBundleDescription());
                ++i;
            }
            this.saveState(state, dir);
            this.writePluginInfo(models, dir);
            this.writeExtensions(models, dir);
        }
        this.clearStaleStates(".target", this.fTargetTimestamp);
        this.clearStaleStates(".workspace", timestamp);
        this.clearStaleStates(".cache", 0L);
    }

    public void writePluginInfo(IPluginModelBase[] models, File destination) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("map");
            doc.appendChild(root);
            int i = 0;
            while (i < models.length) {
                IPluginBase plugin = models[i].getPluginBase();
                BundleDescription desc = models[i].getBundleDescription();
                Element element = doc.createElement("bundle");
                element.setAttribute("bundleID", Long.toString(desc.getBundleId()));
                element.setAttribute("project", models[i].getUnderlyingResource().getProject().getName());
                if (plugin instanceof IPlugin && ((IPlugin)plugin).getClassName() != null) {
                    element.setAttribute("class", ((IPlugin)plugin).getClassName());
                }
                if (plugin.getProviderName() != null) {
                    element.setAttribute("provider", plugin.getProviderName());
                }
                if (plugin.getName() != null) {
                    element.setAttribute("name", plugin.getName());
                }
                if (plugin instanceof IPlugin && ClasspathUtilCore.hasExtensibleAPI((IPlugin)plugin)) {
                    element.setAttribute("hasExtensibleAPI", "true");
                }
                if (plugin.getSchemaVersion() == null) {
                    element.setAttribute("legacy", "true");
                }
                IPluginLibrary[] libraries = plugin.getLibraries();
                int j = 0;
                while (j < libraries.length) {
                    Element lib = doc.createElement("library");
                    lib.setAttribute("name", libraries[j].getName());
                    if (!libraries[j].isExported()) {
                        lib.setAttribute("exported", "false");
                    }
                    element.appendChild(lib);
                    ++j;
                }
                root.appendChild(element);
                ++i;
            }
            XMLPrintHandler.writeFile(doc, new File(destination, ".pluginInfo"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (IOException iOException) {}
    }

    public void writeExtensions(IPluginModelBase[] models, File destination) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("extensions");
            doc.appendChild(root);
            int i = 0;
            while (i < models.length) {
                IPluginBase plugin = models[i].getPluginBase();
                IPluginExtension[] extensions = plugin.getExtensions();
                IPluginExtensionPoint[] extPoints = plugin.getExtensionPoints();
                if (extensions.length != 0 || extPoints.length != 0) {
                    Element element = doc.createElement("bundle");
                    element.setAttribute("bundleID", Long.toString(models[i].getBundleDescription().getBundleId()));
                    int j = 0;
                    while (j < extensions.length) {
                        element.appendChild(CoreUtility.writeExtension(doc, extensions[j]));
                        ++j;
                    }
                    j = 0;
                    while (j < extPoints.length) {
                        element.appendChild(CoreUtility.writeExtensionPoint(doc, extPoints[j]));
                        ++j;
                    }
                    root.appendChild(element);
                }
                ++i;
            }
            XMLPrintHandler.writeFile(doc, new File(destination, ".extensions"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (IOException iOException) {}
    }

    private long computeTimestamp(IPluginModelBase[] models) {
        URL[] urls = new URL[models.length];
        int i = 0;
        while (i < models.length) {
            try {
                IProject project = models[i].getUnderlyingResource().getProject();
                urls[i] = new File(project.getLocation().toString()).toURL();
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        return this.computeTimestamp(urls);
    }

    private boolean shouldSaveState(IPluginModelBase[] models) {
        int i = 0;
        while (i < models.length) {
            String id = models[i].getPluginBase().getId();
            if (id == null || id.trim().length() == 0 || !models[i].isLoaded() || !models[i].isInSync() || models[i].getBundleDescription() == null) {
                return false;
            }
            ++i;
        }
        return models.length > 0;
    }

    private void clearStaleStates(String extension, long latest) {
        File dir = new File(PDECore.getDefault().getStateLocation().toOSString());
        File[] children = dir.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                String name;
                File child = children[i];
                if (child.isDirectory() && (name = child.getName()).endsWith(extension) && name.length() > extension.length() && !name.equals(String.valueOf(Long.toString(latest)) + extension)) {
                    CoreUtility.deleteContent(child);
                }
                ++i;
            }
        }
    }

    class PluginInfo {
        String name;
        String providerName;
        String className;
        boolean hasExtensibleAPI;
        boolean legacy;
        String[] libraries;
        String project;

        PluginInfo() {
        }
    }
}

