/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.osgi.framework.Bundle;

public class RemotePluginTestRunner
extends RemoteTestRunner {
    private String fTestPluginName;

    public static void main(String[] args) {
        RemotePluginTestRunner testRunner = new RemotePluginTestRunner();
        testRunner.init(args);
        testRunner.run();
    }

    protected ClassLoader getClassLoader() {
        Bundle bundle = Platform.getBundle((String)this.fTestPluginName);
        if (bundle == null) {
            throw new IllegalArgumentException("No Classloader found for plug-in " + this.fTestPluginName);
        }
        return new BundleClassLoader(bundle);
    }

    protected void init(String[] args) {
        this.defaultInit(args);
        this.setTestPluginName(args);
    }

    protected void setTestPluginName(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].toLowerCase(Locale.ENGLISH).equals("-testpluginname")) {
                if (i < args.length - 1) {
                    this.fTestPluginName = args[i + 1];
                }
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Parameter -testpluginnname not specified.");
    }

    class BundleClassLoader
    extends ClassLoader {
        private Bundle bundle;

        public BundleClassLoader(Bundle target) {
            this.bundle = target;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        protected URL findResource(String name) {
            return this.bundle.getResource(name);
        }

        protected Enumeration findResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }
    }
}

