/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra;

import com.sybase.connector.repra.logging.RaLogger;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.resource.cci.Connection;

public class ConnectionContainer {
    private static ConnectionContainer _container;
    private static Hashtable _threadSet;
    public static Hashtable _connectionSet;
    public static Properties _controlCommands;
    private static RaLogger _log;
    private static Object _lockThread;
    private static Object _lockConnection;

    private ConnectionContainer() {
        _log = new RaLogger(0);
    }

    public static ConnectionContainer getInstance() {
        if (_container == null) {
            _container = new ConnectionContainer();
            _connectionSet = new Hashtable();
            _threadSet = new Hashtable();
            _controlCommands = new Properties();
        }
        return _container;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(String name, Connection conn) throws Exception {
        Object object = _lockConnection;
        synchronized (object) {
            if (_connectionSet.containsKey(name)) {
                throw new Exception(_log.getResourceBundle().getString("ConnectionConatiner.setConnection.m1"));
            }
            _connectionSet.put(name, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String name) throws Exception {
        Connection conn;
        Object object = _lockConnection;
        synchronized (object) {
            conn = (Connection)_connectionSet.get(name);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getThreadVector(String name) throws Exception {
        Object object = _lockThread;
        synchronized (object) {
            if (_threadSet.containsKey(name)) {
                return (Vector)_threadSet.get(name);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadVector(String name, Thread thread) throws Exception {
        Object object = _lockThread;
        synchronized (object) {
            if (!_threadSet.containsKey(name)) {
                _threadSet.put(name, new Vector());
            }
            Vector threads = (Vector)_threadSet.get(name);
            threads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(String name) throws Exception {
        Object object = _lockThread;
        synchronized (object) {
            _controlCommands.setProperty(name, "STOP");
            Vector threads = (Vector)_threadSet.get(name);
            if (threads != null) {
                Thread elem = null;
                for (int ido = 0; ido < threads.size(); ++ido) {
                    elem = (Thread)threads.elementAt(ido);
                    if (elem.isAlive()) {
                        elem.destroy();
                    }
                    elem = null;
                }
            }
            _threadSet.remove(name);
            _controlCommands.remove(name);
        }
        object = _lockConnection;
        synchronized (object) {
            _connectionSet.remove(name);
        }
    }

    public void setControl(String name, String control) {
        _controlCommands.setProperty(name, control);
    }

    public String getControl(String name) {
        String status = _controlCommands.getProperty(name, "STOP");
        if (status.equals("")) {
            status = "STOP";
        }
        return status;
    }

    static {
        _threadSet = null;
        _connectionSet = null;
        _controlCommands = null;
        _lockThread = new Object();
        _lockConnection = new Object();
    }
}

