/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra;

import com.sybase.connector.repra.RepraManagedConnection;
import com.sybase.connector.repra.RepraManagedConnectionFactory;
import com.sybase.connector.repra.logging.RaLogger;
import java.util.Vector;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;

public class RepraConnectionEventListener
implements ConnectionEventListener {
    private static RaLogger _log = null;
    private Vector _connEventListeners = new Vector();
    private ManagedConnection _mConn;

    public RepraConnectionEventListener(ManagedConnection mConn) {
        this._mConn = mConn;
        RepraManagedConnectionFactory mcf = (RepraManagedConnectionFactory)((RepraManagedConnection)this._mConn).getManagedConnectionFactory();
    }

    public void setLogger(RaLogger log) {
        if (_log == null) {
            _log = log;
        }
    }

    public void sendEvent(int eventType, Exception ex, Object connHandler) {
        Vector aCloned = (Vector)this._connEventListeners.clone();
        ConnectionEvent connEvent = null;
        connEvent = ex == null ? new ConnectionEvent(this._mConn, eventType) : new ConnectionEvent(this._mConn, eventType, ex);
        if (connHandler != null) {
            connEvent.setConnectionHandle(connHandler);
        }
        int size = aCloned.size();
        for (int i = 0; i < size; ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)aCloned.elementAt(i);
            if (eventType == 1) {
                listener.connectionClosed(connEvent);
                continue;
            }
            if (eventType == 2) {
                listener.localTransactionStarted(connEvent);
                continue;
            }
            if (eventType == 3) {
                listener.localTransactionCommitted(connEvent);
                continue;
            }
            if (eventType == 4) {
                listener.localTransactionRolledback(connEvent);
                continue;
            }
            if (eventType == 5) {
                listener.connectionErrorOccurred(connEvent);
                continue;
            }
            IllegalArgumentException ilex = new IllegalArgumentException(_log.getResourceBundle().getString("RepraConnectionEventListener.m2") + eventType);
            Object[] params = new String[]{Integer.toString(eventType)};
            _log.error("RepraConnectionEventListener.m2", params, (Throwable)ilex);
        }
    }

    public void addConnectorListener(ConnectionEventListener listener) {
        this._connEventListeners.addElement(listener);
    }

    public void removeConnectorListener(ConnectionEventListener listener) {
        this._connEventListeners.removeElement(listener);
    }

    public void connectionClosed(ConnectionEvent connEvent) {
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this.sendEvent(5, event.getException(), null);
    }

    public void localTransactionStarted(ConnectionEvent event) {
        this.sendEvent(0, event.getException(), null);
    }

    public void localTransactionCommitted(ConnectionEvent event) {
        this.sendEvent(0, event.getException(), null);
    }

    public void localTransactionRolledback(ConnectionEvent event) {
        this.sendEvent(0, event.getException(), null);
    }
}

