/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra;

import com.sybase.connector.repra.RepraConnection;
import com.sybase.connector.repra.RepraConnectionFactory;
import com.sybase.connector.repra.RepraConnectionRequestInfo;
import com.sybase.connector.repra.RepraConnectionSpec;
import com.sybase.connector.repra.RepraResourceAdapterMetaData;
import com.sybase.connector.repra.logging.RaLogger;
import java.util.Properties;
import javax.naming.Reference;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class RepraConnectionFactoryImpl
implements RepraConnectionFactory {
    private static RaLogger _log = null;
    private String _desc;
    private ManagedConnectionFactory _mcFactory;
    private ConnectionManager _connMgr;
    private Reference _reference;

    public RepraConnectionFactoryImpl() {
        if (_log == null) {
            _log = new RaLogger(0);
        }
    }

    public RepraConnectionFactoryImpl(ManagedConnectionFactory mcFactory, ConnectionManager connMgr) {
        this._mcFactory = mcFactory;
        this._connMgr = connMgr;
        if (_log == null) {
            _log = new RaLogger(0);
        }
    }

    public void setLogger(RaLogger log) {
        _log = log;
    }

    public Connection getConnection(ConnectionSpec connSpec) throws ResourceException {
        try {
            RepraConnectionRequestInfo connReqInfo = new RepraConnectionRequestInfo((RepraConnectionSpec)connSpec);
            String connName = connReqInfo.getConnectionName();
            if (connName == null && connName.equals("")) {
                return null;
            }
            Connection conn = (Connection)this._connMgr.allocateConnection(this._mcFactory, (ConnectionRequestInfo)connReqInfo);
            ((RepraConnection)conn).setLogger(_log);
            ((RepraConnection)conn).setProperties(((RepraConnectionSpec)connSpec).getProperties());
            ((RepraConnection)conn).startAdapter();
            return conn;
        }
        catch (Exception ex) {
            _log.fatal("RepraConnectionFactoryImpl.e1", (Throwable)ex);
            ResourceException rex = new ResourceException(_log.getResourceBundle().getString("RepraConnectionFactoryImpl.e1"));
            rex.setLinkedException(ex);
            throw rex;
        }
    }

    public Connection getConnection() throws ResourceException {
        try {
            RepraConnectionRequestInfo connReqInfo = new RepraConnectionRequestInfo();
            Connection conn = (Connection)this._connMgr.allocateConnection(this._mcFactory, (ConnectionRequestInfo)connReqInfo);
            _log.debug("RepraConnectionFactoryImpl.m2");
            return conn;
        }
        catch (Exception ex) {
            _log.fatal("RepraConnectionFactoryImpl.e2", (Throwable)ex);
            ResourceException rex = new ResourceException(_log.getResourceBundle().getString("RepraConnectionFactoryImpl.e2"));
            rex.setLinkedException(ex);
            throw rex;
        }
    }

    public Connection getConnection(Properties props) throws ResourceException {
        try {
            RepraConnectionRequestInfo connReqInfo = new RepraConnectionRequestInfo(props);
            Connection conn = (Connection)this._connMgr.allocateConnection(this._mcFactory, (ConnectionRequestInfo)connReqInfo);
            ((RepraConnection)conn).startAdapter(props);
            _log.debug("RepraConnectionFactoryImpl.m2");
            return conn;
        }
        catch (Exception ex) {
            _log.fatal("RepraConnectionFactoryImpl.e2", (Throwable)ex);
            ResourceException rex = new ResourceException(_log.getResourceBundle().getString("RepraConnectionFactoryImpl.e2"));
            rex.setLinkedException(ex);
            throw rex;
        }
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return new RepraResourceAdapterMetaData();
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        NotSupportedException ex = new NotSupportedException(_log.getResourceBundle().getString("RepraConnectionFactoryImpl.m3"));
        _log.warn("RepraConnectionFactoryImpl.m3", (Throwable)ex);
        throw ex;
    }

    public String getDescription() {
        return this._desc;
    }

    public void setDescription(String desc) {
        this._desc = desc;
    }

    public void setReference(Reference reference) {
        this._reference = reference;
    }

    public Reference getReference() {
        return this._reference;
    }
}

