/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra;

import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.RepraAdapter;
import com.sybase.connector.repra.RepraConnection;
import com.sybase.connector.repra.RepraManagedConnection;
import com.sybase.connector.repra.RepraManagedConnectionFactory;
import com.sybase.connector.repra.RepraMetaDataImpl;
import com.sybase.connector.repra.jms.JMSAdapterImpl;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.mq.MQAdapterImpl;
import com.sybase.connector.repra.mq.MQJMSAdapterImpl;
import com.sybase.connector.repra.rep.RepAdapterImpl;
import com.sybase.connector.repra.tibrv.TIBRVAdapterImpl;
import com.sybase.connector.repra.tibrv.TIBRVCMAdapterImpl;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.resource.spi.ConnectionRequestInfo;

public class RepraConnectionImpl
implements RepraConnection,
Serializable {
    private static RaLogger _log = null;
    private RepraManagedConnection _rjmConn;
    private RepraAdapter _adapterImpl = null;
    private Properties _props = new Properties();
    private static ConnectionContainer _connectionContainer = ConnectionContainer.getInstance();
    private static final int CHECK_LIMIT = 10;
    private static final long CHECK_PERIOD = 1000L;

    public RepraConnectionImpl(RepraManagedConnection rjmConn, ConnectionRequestInfo repraConnReqInfo) {
        RepraManagedConnectionFactory mcf = (RepraManagedConnectionFactory)rjmConn.getManagedConnectionFactory();
        this._rjmConn = rjmConn;
    }

    public void setLogger(RaLogger log) {
        if (_log == null) {
            _log = log;
        }
    }

    public void setProperties(Properties props) {
        this._props = props;
    }

    public boolean startAdapter(Properties props) throws Exception {
        this.setProperties(props);
        return this.startAdapter();
    }

    public boolean startAdapter() throws Exception {
        if (this._props == null || this._props.getProperty("ConnectionName", "").equals("")) {
            return false;
        }
        String connName = this._props.getProperty("ConnectionName");
        try {
            if (this._adapterImpl == null) {
                this.buildAdapter();
            }
            ((Thread)((Object)this._adapterImpl)).start();
            for (int ido = 0; ido < 10; ++ido) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (_connectionContainer.getControl(connName).equals("RUNNING")) break;
            }
            if (_connectionContainer.getControl(connName).equals("STOP")) {
                throw new Exception(_log.getResourceBundleString("RepraConnectionImpl.startAdapter.e1"));
            }
            _log.info("RepraConnectionImpl.startAdapter.m1", connName);
            return true;
        }
        catch (Exception ex) {
            _log.error("RepraConnectionImpl.startAdapter.e2", (Object)connName, (Throwable)ex);
            throw ex;
        }
    }

    public boolean stopAdapter() throws Exception {
        if (this._props == null || this._props.getProperty("ConnectionName", "").equals("")) {
            return true;
        }
        String connName = this._props.getProperty("ConnectionName");
        Vector threads = _connectionContainer.getThreadVector(connName);
        try {
            if (threads != null && threads.size() > 0) {
                Object thread = null;
                for (int ido = threads.size() - 1; ido >= 0; --ido) {
                    Object obj = threads.remove(ido);
                    if (obj == null) continue;
                    if (obj instanceof RepraAdapter) {
                        ((RepraAdapter)obj).close();
                    }
                    if (!(obj instanceof Thread) || !((Thread)obj).isAlive()) continue;
                    ((Thread)obj).destroy();
                }
            }
            if (this._adapterImpl != null) {
                this._adapterImpl.close();
                if (((Thread)((Object)this._adapterImpl)).isAlive()) {
                    try {
                        ((Thread)((Object)this._adapterImpl)).destroy();
                    }
                    catch (NoSuchMethodError nsme) {
                        // empty catch block
                    }
                }
            }
            for (int ido = 0; ido < 10; ++ido) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception sleepex) {
                    // empty catch block
                }
                if (_connectionContainer.getControl(connName).equals("STOP")) break;
            }
            if (_connectionContainer.getControl(connName).equals("RUNNING")) {
                throw new Exception(_log.getResourceBundleString("RepraConnectionImpl.stopAdapter.e1"));
            }
            _connectionContainer.setControl(connName, "STOP");
            _log.info("RepraConnectionImpl.stopAdapter.m1", connName);
            return true;
        }
        catch (Exception ex) {
            _log.error("RepraConnectionImpl.stopAdapter.e1", (Object)connName, (Throwable)ex);
            throw ex;
        }
    }

    public void close() throws ResourceException {
        try {
            if (this._props != null && !this._props.getProperty("ConnectionName", "").equals("")) {
                if (!this.stopAdapter()) {
                    throw new ResourceException(_log.getResourceBundleString("RepraConnectionImpl.close.e1"));
                }
                _log.debug("RepraConnectionImpl.close.m1");
            }
        }
        catch (Exception ex) {
            _log.error("RepraConnectionImpl.close.e1", (Throwable)ex);
            throw new ResourceException(_log.getResourceBundleString("RepraConnectionImpl.close.e1"));
        }
        if (this._rjmConn != null) {
            this._rjmConn.destroy();
            this._rjmConn = null;
        }
        try {
            if (this._props != null && !this._props.getProperty("ConnectionName", "").equals("")) {
                _connectionContainer.setControl(this._props.getProperty("ConnectionName"), "STOP");
            }
        }
        catch (Exception ex) {
            _log.error("RepraConnectionImpl.close.e2", (Throwable)ex);
            ResourceException rEx = new ResourceException(_log.getResourceBundle().getString("RepraConnectionImpl.close.e2"));
            rEx.setLinkedException(ex);
            throw rEx;
        }
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return (ConnectionMetaData)new RepraMetaDataImpl(this._rjmConn);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        NotSupportedException ex = new NotSupportedException(_log.getResourceBundle().getString("RepraConnectionImpl.e1"));
        _log.debug("RepraConnectionImpl.e1", (Throwable)ex);
        throw ex;
    }

    public Interaction createInteraction() throws ResourceException {
        NotSupportedException ex = new NotSupportedException(_log.getResourceBundle().getString("RepraConnectionImpl.e2"));
        _log.debug("RepraConnectionImpl.e2", (Throwable)ex);
        throw ex;
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        NotSupportedException ex = new NotSupportedException(_log.getResourceBundle().getString("RepraConnectionImpl.e3"));
        _log.debug("RepraConnectionImpl.e3", (Throwable)ex);
        throw ex;
    }

    public void associateConnection(RepraManagedConnection rjmConn) throws ResourceException {
        try {
            this._rjmConn = rjmConn;
        }
        catch (Exception ex) {
            _log.error("RepraConnectionImpl.e4", (Throwable)ex);
            ResourceException rex = new ResourceException(_log.getResourceBundle().getString("RepraConnectionImpl.e4"));
            rex.setLinkedException(ex);
            throw rex;
        }
    }

    public void invalidate() {
        this._rjmConn = null;
    }

    public boolean buildAdapter() throws Exception {
        String inboundType = this._props.getProperty("InboundType", "REPLICATION");
        _connectionContainer.setControl(this._props.getProperty("ConnectionName"), "STOP");
        if (inboundType.equals("REPLICATION")) {
            this._adapterImpl = new RepAdapterImpl(this._props);
        } else if (inboundType.equals("JMS")) {
            this._adapterImpl = new JMSAdapterImpl(this._props);
        } else if (inboundType.equals("TIBCO")) {
            if (this._props.getProperty("TIBType", "RV").equals("RV")) {
                this._adapterImpl = new TIBRVAdapterImpl(this._props);
            } else if (this._props.getProperty("TIBType", "RV").equals("RVCM")) {
                this._adapterImpl = new TIBRVCMAdapterImpl(this._props);
            }
        } else if (inboundType.equals("IBMMQ")) {
            if (this._props.getProperty("MQType", "MQ").equals("MQJMS")) {
                this._adapterImpl = new MQJMSAdapterImpl(this._props);
            } else if (this._props.getProperty("MQType", "MQ").equals("MQ")) {
                this._adapterImpl = new MQAdapterImpl(this._props);
            }
        } else {
            throw new Exception(_log.getResourceBundle().getString("RepraConnectionImpl.buildAdapter.e1"));
        }
        return true;
    }
}

