/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra;

import com.sybase.connector.repra.RepraConnection;
import com.sybase.connector.repra.RepraConnectionEventListener;
import com.sybase.connector.repra.RepraConnectionImpl;
import com.sybase.connector.repra.RepraMetaDataImpl;
import com.sybase.connector.repra.SecurityUtil;
import com.sybase.connector.repra.logging.RaLogger;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class RepraManagedConnection
implements ManagedConnection {
    private static RaLogger _log = null;
    private RepraConnectionEventListener _repraConnEventListener;
    private PasswordCredential _passCredent;
    private ManagedConnectionFactory _mcFactory;
    private boolean _closed;
    private Set _connSet;

    RepraManagedConnection(ManagedConnectionFactory mcFactory, PasswordCredential passCredent) {
        this._mcFactory = mcFactory;
        this._passCredent = passCredent;
        this._connSet = new HashSet();
        this._repraConnEventListener = new RepraConnectionEventListener(this);
        this._repraConnEventListener.setLogger(_log);
    }

    public void setLogger(RaLogger log) {
        if (_log == null) {
            _log = log;
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this._repraConnEventListener.addConnectorListener(listener);
        _log.debug("RepraManagedConnection.m2");
    }

    public void associateConnection(Object conn) throws ResourceException {
        if (this._closed || !(conn instanceof RepraConnection)) {
            IllegalStateException ex = new IllegalStateException(_log.getResourceBundle().getString("RepraManagedConnection.m4"));
            _log.error("RepraManagedConnection.m4", (Throwable)ex);
            throw ex;
        }
        ((RepraConnection)conn).associateConnection(this);
        _log.debug("RepraManagedConnection.m3");
    }

    public void cleanup() throws ResourceException {
        try {
            for (RepraConnection conn : this._connSet) {
                conn.invalidate();
            }
            this._connSet.clear();
            _log.debug("RepraManagedConnection.m5");
        }
        catch (Exception ex) {
            _log.error("RepraManagedConnection.m6", (Throwable)ex);
            throw new ResourceException(ex.getMessage());
        }
    }

    public void destroy() throws ResourceException {
        try {
            if (this._closed) {
                return;
            }
            this._closed = true;
            for (RepraConnection conn : this._connSet) {
                conn.invalidate();
            }
            this._connSet.clear();
        }
        catch (Exception ex) {
            _log.error("RepraManagedConnection.m7", (Throwable)ex);
            throw new ResourceException(ex.getMessage());
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connReqInfo) throws ResourceException {
        PasswordCredential passCredent = SecurityUtil.getPasswordCredential(this._mcFactory, subject, connReqInfo);
        RepraConnectionImpl conn = new RepraConnectionImpl(this, connReqInfo);
        conn.setLogger(_log);
        this._connSet.add(conn);
        _log.debug("RepraManagedConnection.m9");
        return conn;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        NotSupportedException ex = new NotSupportedException(_log.getResourceBundle().getString("RepraManagedConnection.m10"));
        _log.debug("RepraManagedConnection.m10", (Throwable)ex);
        throw ex;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        NotSupportedException ex = new NotSupportedException(_log.getResourceBundle().getString("RepraManagedConnection.m11"));
        _log.debug("RepraManagedConnection.m11", (Throwable)ex);
        throw ex;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        NotSupportedException ex = new NotSupportedException(_log.getResourceBundle().getString("RepraManagedConnection.m12"));
        _log.debug("RepraManagedConnection.m12", (Throwable)ex);
        throw ex;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new RepraMetaDataImpl(this);
    }

    public XAResource getXAResource() throws ResourceException {
        NotSupportedException ex = new NotSupportedException(_log.getResourceBundle().getString("RepraManagedConnection.m13"));
        _log.debug("RepraManagedConnection.m13", (Throwable)ex);
        throw ex;
    }

    public void removeConnectionEventListener(ConnectionEventListener cxEventListener) {
        this._repraConnEventListener.removeConnectorListener(cxEventListener);
        _log.debug("RepraManagedConnection.m14");
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this._mcFactory;
    }

    public PasswordCredential getPasswordCredential() {
        return this._passCredent;
    }

    public boolean isClosed() {
        return this._closed;
    }
}

