/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.jdbc;

import com.sybase.connector.repra.RepraClient;
import com.sybase.connector.repra.RepraConst;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.util.RepraPingUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;

public class JDBCClient
implements RepraClient {
    private RaLogger _log = null;
    private Connection _conn = null;
    private Statement _stmt = null;
    private String _jdbcURL = null;
    private String _jdbcDriver = null;
    private String _username = null;
    private String _password = null;
    private String _encryption = null;
    private Properties _cProps = null;

    public JDBCClient(Properties props) {
        this.initJDBCClient(props);
    }

    public JDBCClient(Properties props, RaLogger log) {
        this._log = log;
        this.initJDBCClient(props);
    }

    public void initJDBCClient(Properties props) {
        this._cProps = props;
        this._jdbcURL = this._cProps.getProperty("DATABASE_URL", "jdbc:sybase:Tds:localhost:4100");
        this._jdbcDriver = this._cProps.getProperty("DATABASE_Driver", "com.sybase.jdbc3.jdbc.SybDriver");
        this._username = this._cProps.getProperty("DATABASE_Username");
        this._password = this._cProps.getProperty("DATABASE_Password");
        this._encryption = this._cProps.getProperty("EncryptedFlag", "false");
        this._log.info("JDBCClient.init.m1");
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public void configureClient() throws Exception {
        try {
            Class.forName(this._jdbcDriver);
        }
        catch (Exception ex) {
            this._log.error("JDBCClient.configureClient.e1", this._jdbcDriver);
            throw ex;
        }
        try {
            this._conn = DriverManager.getConnection(this._jdbcURL, this._username, this._password);
        }
        catch (Exception ex) {
            this._log.error("JDBCClient.configureClient.e2", (Object)this._jdbcURL, this._username);
            throw ex;
        }
        if (this._encryption.equals("true")) {
            try {
                this._log.debug("set ciphertext on");
                this.sendEvent("set ciphertext on");
            }
            catch (Exception ex) {
                this._log.error("JDBCClient.configureClient.e3", this._jdbcDriver);
                throw ex;
            }
        }
    }

    public int getDatabaseType() throws Exception {
        String productName = null;
        int databaseType = 0;
        DatabaseMetaData dbmd = null;
        dbmd = this.getDatabaseMetaData();
        try {
            productName = dbmd.getDatabaseProductName();
            this._log.debug("JDBCClient.getDatabaseType.m1", productName);
        }
        catch (SQLException sqle) {
            this._log.error("JDBCClient.getDatabaseType.e1", (Object)this._jdbcURL, sqle.getMessage());
            throw sqle;
        }
        if (productName != null) {
            if (productName.toLowerCase().startsWith("oracle")) {
                databaseType = 1;
            } else if (productName.toLowerCase().startsWith("adaptive server")) {
                databaseType = 0;
            }
        }
        this._log.debug("JDBCClient.getDatabaseType.m2", RepraConst.DBTYPES[databaseType]);
        return databaseType;
    }

    public DatabaseMetaData getDatabaseMetaData() throws Exception {
        DatabaseMetaData dbmd = null;
        if (this._conn == null) {
            this._log.error("JDBCClient.getDatabaseMetaData.e2", this._jdbcURL);
            throw new Exception(this._log.getResourceBundle().getString("JDBCClient.getDatabaseMetaData.e3"));
        }
        try {
            dbmd = this._conn.getMetaData();
        }
        catch (SQLException sqle) {
            this._log.error("JDBCClient.getDatabaseMetaData.e1", sqle.getMessage());
            throw sqle;
        }
        return dbmd;
    }

    public boolean sendEvent(Object jdbcmsg) throws Exception {
        try {
            if (this._stmt == null) {
                this._stmt = this._conn.createStatement();
            }
        }
        catch (Exception ex) {
            this._log.error("JDBCClient.sendEvent.e1", (Object)this._jdbcURL, (Object)this._username, ex);
            throw ex;
        }
        try {
            this._stmt.clearBatch();
            if (jdbcmsg instanceof String) {
                this._log.debug("JDBCClient.sendEvent.m2", (String)jdbcmsg);
                boolean rets = this._stmt.execute((String)jdbcmsg);
            } else {
                List stmts = (List)jdbcmsg;
                if (stmts.size() == 1) {
                    this._log.debug("JDBCClient.sendEvent.m2", (String)stmts.get(0));
                    boolean rets = this._stmt.execute((String)stmts.get(0));
                    this._log.info("JDBCClient.sendEvent.m1", (Object)this._jdbcURL, this._username);
                    return true;
                }
                this._log.debug("JDBCClient.sendEvent.m3");
                for (String stmt : stmts) {
                    this._stmt.addBatch(stmt);
                    this._log.debug("JDBCClient.sendEvent.m2", stmt);
                }
                int[] status = this._stmt.executeBatch();
                this._stmt.clearBatch();
            }
            this._log.info("JDBCClient.sendEvent.m1", (Object)this._jdbcURL, this._username);
            return true;
        }
        catch (Exception ex) {
            this._log.error("JDBCClient.sendEvent.e2", (Object)jdbcmsg.toString(), (Object)this._jdbcURL, (Object)this._username, ex);
            throw ex;
        }
    }

    public boolean isReady() {
        try {
            return RepraPingUtil.pingDB(this._log, this._jdbcURL, this._jdbcDriver, this._username, this._password);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void close() {
        if (this._conn != null) {
            if (this._stmt != null) {
                try {
                    this._stmt.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            try {
                this._conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

