/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.jms;

import com.sybase.connector.repra.RepraAdapter;
import com.sybase.connector.repra.RepraJmsClient;
import com.sybase.connector.repra.logging.RaLogger;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public abstract class JMSClient
extends Thread
implements RepraAdapter,
RepraJmsClient {
    protected RaLogger _log = null;
    protected Properties _cProps = null;
    protected Context _ctx;
    protected String _queueConnFactory = null;
    protected Queue _queue = null;
    protected Topic _topic = null;
    protected ConnectionFactory _jcf = null;
    protected Connection _jConnection = null;
    protected Session _jSession = null;
    protected MessageProducer _jSender = null;
    protected String _url = null;
    protected String _user = null;
    protected String _pass = null;
    protected String _initCTX = null;
    protected String _connFactory = null;
    protected boolean _isQueue = true;
    protected boolean _isAdapter = false;
    protected String _lqueue = null;
    protected String _ltopic = null;
    protected boolean _sonicmq = false;

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    protected void initProperties(Properties cProps) throws Exception {
        this._cProps = cProps;
        this._url = this._cProps.getProperty("JMS_ProviderURL", "iiop://localhost:2000");
        this._initCTX = this._cProps.getProperty("JMS_InitialContext", "com.sybase.jms.InitialContextFactory");
        this._user = this._cProps.getProperty("JMS_Username", "");
        this._pass = this._cProps.getProperty("JMS_Password", "");
        this._connFactory = this._cProps.getProperty("JMS_QCF", "javax.jms.QueueConnectionFactory");
    }

    protected void configureJMSClient() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        try {
            env.put("java.naming.factory.initial", this._initCTX);
            env.put("java.naming.provider.url", this._url);
            if (this._user != null) {
                env.put("java.naming.security.principal", this._user);
            }
            if (this._pass != null) {
                env.put("java.naming.security.credentials", this._pass);
            }
        }
        catch (Exception ee) {
            this._log.error("JMSClient.configureJMSClient.e1", (Object)env.toString(), (Throwable)ee);
            throw ee;
        }
        if (this._initCTX.indexOf("com.tibco.tibjms.naming.TibjmsInitialContextFactory") >= 0) {
            Class<?> factory = null;
            try {
                factory = Class.forName(this._connFactory);
            }
            catch (ClassNotFoundException cnfe) {
                this._log.error("JMSClient.configureJMSClient.e2", (Object)this._connFactory, (Throwable)cnfe);
                throw cnfe;
            }
            catch (Exception ee) {
                this._log.error("JMSClient.configureJMSClient.e3", (Object)this._connFactory, (Throwable)ee);
                throw ee;
            }
            try {
                try {
                    this._ctx = new InitialContext(env);
                }
                catch (Exception ex) {
                    env.put("java.naming.referral", "throw");
                    this._ctx = new InitialDirContext(env);
                }
                Class[] args1 = new Class[]{String.class};
                Object[] urlObj = new Object[]{this._url};
                Constructor<?> cons = factory.getConstructor(args1);
                this._jcf = (ConnectionFactory)cons.newInstance(urlObj);
            }
            catch (NoSuchMethodException nsme) {
                this._log.error("JMSClient.configureJMSClient.e4", (Object)this._connFactory, (Object)this._url, nsme);
                throw nsme;
            }
            catch (InstantiationException ie) {
                this._log.error("JMSClient.configureJMSClient.e4", (Object)this._connFactory, (Throwable)ie);
                throw ie;
            }
            catch (Exception ee) {
                this._log.error("JMSClient.configureJMSClient.e4", (Object)this._connFactory, (Object)this._url, ee);
            }
        } else {
            if (this._initCTX.indexOf("progress.message.jclient.QueueConnectionFactory") >= 0 || this._initCTX.indexOf("progress.message.jclient.TopicConnectionFactory") >= 0) {
                this._sonicmq = true;
                Class<?> factory = null;
                try {
                    factory = Class.forName(this._connFactory);
                }
                catch (ClassNotFoundException cnfe) {
                    this._log.error("JMSClient.configureJMSClient.e2", (Object)this._connFactory, (Throwable)cnfe);
                    throw cnfe;
                }
                catch (Exception ee) {
                    this._log.error("JMSClient.configureJMSClient.e3", (Object)this._connFactory, (Throwable)ee);
                    throw ee;
                }
                try {
                    Class[] args1 = new Class[]{String.class};
                    Object[] urlObj = new Object[]{this._url};
                    Constructor<?> cons = factory.getConstructor(args1);
                    this._jcf = (ConnectionFactory)cons.newInstance(urlObj);
                }
                catch (NoSuchMethodException nsme) {
                    this._log.error("JMSClient.configureJMSClient.e4", (Object)this._connFactory, (Throwable)nsme);
                    throw nsme;
                }
                catch (InstantiationException ie) {
                    this._log.error("JMSClient.configureJMSClient.e4", (Object)this._connFactory, (Throwable)ie);
                    throw ie;
                }
                catch (Exception ee) {
                    this._log.error("JMSClient.configureJMSClient.e4", (Object)this._connFactory, (Throwable)ee);
                    throw ee;
                }
            }
            try {
                try {
                    this._ctx = new InitialContext(env);
                }
                catch (Exception ex) {
                    env.put("java.naming.referral", "throw");
                    this._ctx = new InitialDirContext(env);
                }
                this._jcf = (ConnectionFactory)this._ctx.lookup(this._connFactory);
            }
            catch (NamingException ne) {
                this._log.error("JMSClient.configureJMSClient.e5", (Object)this._connFactory, (Object)this._url, ne);
                throw ne;
            }
        }
        if (this._cProps.getProperty("JMSType", "queue").equals("topic")) {
            this.configureTopic();
            this._isQueue = false;
        } else {
            this.configureQueue();
            this._isQueue = true;
        }
    }

    private void configureQueue() throws Exception {
        this._lqueue = this._cProps.getProperty("JMS_LocalQueue", "repra_DEFAULT_QUEUE");
        try {
            this._jConnection = ((QueueConnectionFactory)this._jcf).createQueueConnection(this._user, this._pass);
            this._jConnection.start();
            this._jSession = ((QueueConnection)this._jConnection).createQueueSession(false, 2);
            this._queue = this._sonicmq ? ((QueueSession)this._jSession).createQueue(this._lqueue.trim()) : (Queue)this._ctx.lookup(this._lqueue.trim());
        }
        catch (Exception ex) {
            this._log.error("JMSClient.configureQueue.e1", (Object)this._lqueue.trim(), (Object)this._url, ex);
            throw ex;
        }
    }

    private void configureTopic() throws Exception {
        this._ltopic = this._cProps.getProperty("JMS_LocalQueue", "repra_DEFAULT_QUEUE");
        try {
            this._jConnection = ((TopicConnectionFactory)this._jcf).createTopicConnection(this._user, this._pass);
            this._jConnection.setClientID(this._cProps.getProperty("ConnectionName"));
            this._jConnection.start();
            this._jSession = ((TopicConnection)this._jConnection).createTopicSession(false, 2);
            this._topic = this._sonicmq ? ((TopicSession)this._jSession).createTopic(this._ltopic.trim()) : (Topic)this._ctx.lookup(this._ltopic.trim());
        }
        catch (Exception ex) {
            this._log.error("JMSClient.configureTopic.e1", (Object)this._ltopic.trim(), (Object)this._url, ex);
            throw ex;
        }
    }

    protected Message createMessage(Object repMessage, String eventId) throws Exception {
        BytesMessage message = null;
        try {
            if (repMessage instanceof String) {
                message = this._jSession.createBytesMessage();
                message.writeUTF((String)repMessage);
            } else if (repMessage instanceof ByteArrayOutputStream) {
                byte[] tmp = ((ByteArrayOutputStream)repMessage).toByteArray();
                message = this._jSession.createBytesMessage();
                message.writeBytes(tmp);
            } else {
                message = this._jSession.createObjectMessage();
                ((ObjectMessage)message).setObject((Serializable)repMessage);
            }
            if (eventId == null || eventId.equals("")) {
                eventId = Long.toString(System.currentTimeMillis());
            }
            message.setJMSMessageID(eventId);
            message.setStringProperty("eventId", eventId);
            return message;
        }
        catch (Throwable ex) {
            if (this._isQueue) {
                this._log.error("JMSClient.createMessage.e1", (Object)this._lqueue, (Object)this._url, ex);
            } else {
                this._log.error("JMSClient.createMessage.e2", (Object)this._ltopic, (Object)this._url, ex);
            }
            throw new Exception(ex.toString());
        }
    }

    public void close() {
        try {
            if (this._jConnection != null) {
                this._jConnection.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean sendEvent(Object repmsg, String eventId) throws Exception {
        return false;
    }

    public void configureClient() throws Exception {
    }

    public boolean sendEvent(Object repmsg) throws Exception {
        return false;
    }

    public boolean isReady() {
        return false;
    }

    public Properties getProperties() {
        return null;
    }

    public void setProperties(Properties props) {
    }
}

