/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.jms;

import com.sybase.connector.repra.jms.JMSClient;
import com.sybase.connector.repra.logging.RaLogger;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.Message;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class JMSTopicClient
extends JMSClient {
    public void init(Properties cProps, RaLogger log) {
        this._log = log;
        try {
            this.initProperties(cProps);
            this._log.info("JMSTopicClient.init.m1");
        }
        catch (Exception ex) {
            this._log.error("JMSTopicClient.init.e1", (Throwable)ex);
        }
    }

    public void configureClient() throws Exception {
        this.configureJMSClient();
        try {
            this._jSender = ((TopicSession)this._jSession).createPublisher(this._topic);
            this._jSender.setDisableMessageID(true);
            if (!this._cProps.getProperty("JMS_TopicSubscribers", "").equals("")) {
                StringTokenizer stoken = new StringTokenizer(this._cProps.getProperty("JMS_TopicSubscribers"), ",");
                String sub = "";
                while (stoken.hasMoreTokens()) {
                    sub = stoken.nextToken().trim();
                    TopicSubscriber topicSubscriber = ((TopicSession)this._jSession).createDurableSubscriber(this._topic, sub);
                }
            }
            this._log.info("JMSTopicClient.configureClient.m1", (Object)this._topic.getTopicName(), this._url);
        }
        catch (Exception ex) {
            this._log.error("JMSTopicClient.configureClient.e1", (Object)this._topic.getTopicName(), (Object)this._url, ex);
            throw ex;
        }
    }

    public boolean sendEvent(Object repMessage) throws Exception {
        throw new Exception("Method not Implemented");
    }

    public boolean sendEvent(Object repMessage, String eventId) throws Exception {
        Message message = null;
        message = this.createMessage(repMessage, eventId);
        try {
            ((TopicPublisher)this._jSender).publish(message, 2, 4, 0L);
            this._log.info("JMSTopicClient.sendEvent.m1", (Object)this._topic.getTopicName(), this._url);
            this._log.debug("JMSTopicClient.sendEvent.m1", repMessage.toString());
            return true;
        }
        catch (Exception ex) {
            this._log.error("JMSTopicClient.sendEvent.e1", (Object)this._topic.getTopicName(), (Object)this._url, ex);
            throw ex;
        }
    }

    public boolean isReady() {
        return this._jSender != null;
    }
}

